/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ListMeta;
import io.kubernetes.client.openapi.models.V1ListMetaBuilder;
import io.kubernetes.client.openapi.models.V1ListMetaFluent;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V1StatusDetails;
import io.kubernetes.client.openapi.models.V1StatusDetailsBuilder;
import io.kubernetes.client.openapi.models.V1StatusDetailsFluent;
import java.util.Objects;
import java.util.Optional;

public class V1StatusFluent<A extends V1StatusFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private Integer code;
    private V1StatusDetailsBuilder details;
    private String kind;
    private String message;
    private V1ListMetaBuilder metadata;
    private String reason;
    private String status;

    public V1StatusFluent() {
    }

    public V1StatusFluent(V1Status instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1Status instance) {
        V1Status v1Status = instance = instance != null ? instance : new V1Status();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withCode(instance.getCode());
            this.withDetails(instance.getDetails());
            this.withKind(instance.getKind());
            this.withMessage(instance.getMessage());
            this.withMetadata(instance.getMetadata());
            this.withReason(instance.getReason());
            this.withStatus(instance.getStatus());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public Integer getCode() {
        return this.code;
    }

    public A withCode(Integer code) {
        this.code = code;
        return (A)this;
    }

    public boolean hasCode() {
        return this.code != null;
    }

    public V1StatusDetails buildDetails() {
        return this.details != null ? this.details.build() : null;
    }

    public A withDetails(V1StatusDetails details) {
        this._visitables.remove("details");
        if (details != null) {
            this.details = new V1StatusDetailsBuilder(details);
            this._visitables.get("details").add(this.details);
        } else {
            this.details = null;
            this._visitables.get("details").remove(this.details);
        }
        return (A)this;
    }

    public boolean hasDetails() {
        return this.details != null;
    }

    public DetailsNested<A> withNewDetails() {
        return new DetailsNested(null);
    }

    public DetailsNested<A> withNewDetailsLike(V1StatusDetails item) {
        return new DetailsNested(item);
    }

    public DetailsNested<A> editDetails() {
        return this.withNewDetailsLike(Optional.ofNullable(this.buildDetails()).orElse(null));
    }

    public DetailsNested<A> editOrNewDetails() {
        return this.withNewDetailsLike(Optional.ofNullable(this.buildDetails()).orElse(new V1StatusDetailsBuilder().build()));
    }

    public DetailsNested<A> editOrNewDetailsLike(V1StatusDetails item) {
        return this.withNewDetailsLike(Optional.ofNullable(this.buildDetails()).orElse(item));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public V1ListMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ListMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ListMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ListMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ListMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ListMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public String getStatus() {
        return this.status;
    }

    public A withStatus(String status) {
        this.status = status;
        return (A)this;
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1StatusFluent that = (V1StatusFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.code, that.code)) {
            return false;
        }
        if (!Objects.equals(this.details, that.details)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        return Objects.equals(this.status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.code, this.details, this.kind, this.message, this.metadata, this.reason, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.code != null) {
            sb.append("code:");
            sb.append(this.code);
            sb.append(",");
        }
        if (this.details != null) {
            sb.append("details:");
            sb.append(this.details);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message);
            sb.append(",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
            sb.append(",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason);
            sb.append(",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DetailsNested<N>
    extends V1StatusDetailsFluent<DetailsNested<N>>
    implements Nested<N> {
        V1StatusDetailsBuilder builder;

        DetailsNested(V1StatusDetails item) {
            this.builder = new V1StatusDetailsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1StatusFluent.this.withDetails(this.builder.build());
        }

        public N endDetails() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends V1ListMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ListMetaBuilder builder;

        MetadataNested(V1ListMeta item) {
            this.builder = new V1ListMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1StatusFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

