/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1SuccessPolicyRule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="SuccessPolicy describes when a Job can be declared as succeeded based on the success of some indexes.")
public class V1SuccessPolicy {
    public static final String SERIALIZED_NAME_RULES = "rules";
    @SerializedName(value="rules")
    private List<V1SuccessPolicyRule> rules = new ArrayList<V1SuccessPolicyRule>();

    public V1SuccessPolicy rules(List<V1SuccessPolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    public V1SuccessPolicy addRulesItem(V1SuccessPolicyRule rulesItem) {
        this.rules.add(rulesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="rules represents the list of alternative rules for the declaring the Jobs as successful before `.status.succeeded >= .spec.completions`. Once any of the rules are met, the \"SuccessCriteriaMet\" condition is added, and the lingering pods are removed. The terminal state for such a Job has the \"Complete\" condition. Additionally, these rules are evaluated in order; Once the Job meets one of the rules, other rules are ignored. At most 20 elements are allowed.")
    public List<V1SuccessPolicyRule> getRules() {
        return this.rules;
    }

    public void setRules(List<V1SuccessPolicyRule> rules) {
        this.rules = rules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1SuccessPolicy v1SuccessPolicy = (V1SuccessPolicy)o;
        return Objects.equals(this.rules, v1SuccessPolicy.rules);
    }

    public int hashCode() {
        return Objects.hash(this.rules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1SuccessPolicy {\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

