/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1TokenReviewStatus;
import io.kubernetes.client.openapi.models.V1UserInfo;
import io.kubernetes.client.openapi.models.V1UserInfoBuilder;
import io.kubernetes.client.openapi.models.V1UserInfoFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1TokenReviewStatusFluent<A extends V1TokenReviewStatusFluent<A>>
extends BaseFluent<A> {
    private List<String> audiences;
    private Boolean authenticated;
    private String error;
    private V1UserInfoBuilder user;

    public V1TokenReviewStatusFluent() {
    }

    public V1TokenReviewStatusFluent(V1TokenReviewStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1TokenReviewStatus instance) {
        V1TokenReviewStatus v1TokenReviewStatus = instance = instance != null ? instance : new V1TokenReviewStatus();
        if (instance != null) {
            this.withAudiences(instance.getAudiences());
            this.withAuthenticated(instance.getAuthenticated());
            this.withError(instance.getError());
            this.withUser(instance.getUser());
        }
    }

    public A addToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(index, item);
        return (A)this;
    }

    public A setToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.set(index, item);
        return (A)this;
    }

    public A addToAudiences(String ... items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    public A addAllToAudiences(Collection<String> items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    public A removeFromAudiences(String ... items) {
        if (this.audiences == null) {
            return (A)this;
        }
        for (String item : items) {
            this.audiences.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromAudiences(Collection<String> items) {
        if (this.audiences == null) {
            return (A)this;
        }
        for (String item : items) {
            this.audiences.remove(item);
        }
        return (A)this;
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public String getAudience(int index) {
        return this.audiences.get(index);
    }

    public String getFirstAudience() {
        return this.audiences.get(0);
    }

    public String getLastAudience() {
        return this.audiences.get(this.audiences.size() - 1);
    }

    public String getMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAudiences(List<String> audiences) {
        if (audiences != null) {
            this.audiences = new ArrayList<String>();
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        } else {
            this.audiences = null;
        }
        return (A)this;
    }

    public A withAudiences(String ... audiences) {
        if (this.audiences != null) {
            this.audiences.clear();
            this._visitables.remove("audiences");
        }
        if (audiences != null) {
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        }
        return (A)this;
    }

    public boolean hasAudiences() {
        return this.audiences != null && !this.audiences.isEmpty();
    }

    public Boolean getAuthenticated() {
        return this.authenticated;
    }

    public A withAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
        return (A)this;
    }

    public boolean hasAuthenticated() {
        return this.authenticated != null;
    }

    public String getError() {
        return this.error;
    }

    public A withError(String error) {
        this.error = error;
        return (A)this;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public V1UserInfo buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    public A withUser(V1UserInfo user) {
        this._visitables.remove("user");
        if (user != null) {
            this.user = new V1UserInfoBuilder(user);
            this._visitables.get("user").add(this.user);
        } else {
            this.user = null;
            this._visitables.get("user").remove(this.user);
        }
        return (A)this;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public UserNested<A> withNewUser() {
        return new UserNested(null);
    }

    public UserNested<A> withNewUserLike(V1UserInfo item) {
        return new UserNested(item);
    }

    public UserNested<A> editUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(null));
    }

    public UserNested<A> editOrNewUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(new V1UserInfoBuilder().build()));
    }

    public UserNested<A> editOrNewUserLike(V1UserInfo item) {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1TokenReviewStatusFluent that = (V1TokenReviewStatusFluent)o;
        if (!Objects.equals(this.audiences, that.audiences)) {
            return false;
        }
        if (!Objects.equals(this.authenticated, that.authenticated)) {
            return false;
        }
        if (!Objects.equals(this.error, that.error)) {
            return false;
        }
        return Objects.equals(this.user, that.user);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.audiences, this.authenticated, this.error, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.audiences != null && !this.audiences.isEmpty()) {
            sb.append("audiences:");
            sb.append(this.audiences);
            sb.append(",");
        }
        if (this.authenticated != null) {
            sb.append("authenticated:");
            sb.append(this.authenticated);
            sb.append(",");
        }
        if (this.error != null) {
            sb.append("error:");
            sb.append(this.error);
            sb.append(",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(this.user);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAuthenticated() {
        return this.withAuthenticated(true);
    }

    public class UserNested<N>
    extends V1UserInfoFluent<UserNested<N>>
    implements Nested<N> {
        V1UserInfoBuilder builder;

        UserNested(V1UserInfo item) {
            this.builder = new V1UserInfoBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1TokenReviewStatusFluent.this.withUser(this.builder.build());
        }

        public N endUser() {
            return this.and();
        }
    }
}

