/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="TopologySpreadConstraint specifies how to spread matching pods among the given topology.")
public class V1TopologySpreadConstraint {
    public static final String SERIALIZED_NAME_LABEL_SELECTOR = "labelSelector";
    @SerializedName(value="labelSelector")
    private V1LabelSelector labelSelector;
    public static final String SERIALIZED_NAME_MATCH_LABEL_KEYS = "matchLabelKeys";
    @SerializedName(value="matchLabelKeys")
    private List<String> matchLabelKeys = null;
    public static final String SERIALIZED_NAME_MAX_SKEW = "maxSkew";
    @SerializedName(value="maxSkew")
    private Integer maxSkew;
    public static final String SERIALIZED_NAME_MIN_DOMAINS = "minDomains";
    @SerializedName(value="minDomains")
    private Integer minDomains;
    public static final String SERIALIZED_NAME_NODE_AFFINITY_POLICY = "nodeAffinityPolicy";
    @SerializedName(value="nodeAffinityPolicy")
    private String nodeAffinityPolicy;
    public static final String SERIALIZED_NAME_NODE_TAINTS_POLICY = "nodeTaintsPolicy";
    @SerializedName(value="nodeTaintsPolicy")
    private String nodeTaintsPolicy;
    public static final String SERIALIZED_NAME_TOPOLOGY_KEY = "topologyKey";
    @SerializedName(value="topologyKey")
    private String topologyKey;
    public static final String SERIALIZED_NAME_WHEN_UNSATISFIABLE = "whenUnsatisfiable";
    @SerializedName(value="whenUnsatisfiable")
    private String whenUnsatisfiable;

    public V1TopologySpreadConstraint labelSelector(V1LabelSelector labelSelector) {
        this.labelSelector = labelSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getLabelSelector() {
        return this.labelSelector;
    }

    public void setLabelSelector(V1LabelSelector labelSelector) {
        this.labelSelector = labelSelector;
    }

    public V1TopologySpreadConstraint matchLabelKeys(List<String> matchLabelKeys) {
        this.matchLabelKeys = matchLabelKeys;
        return this;
    }

    public V1TopologySpreadConstraint addMatchLabelKeysItem(String matchLabelKeysItem) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        this.matchLabelKeys.add(matchLabelKeysItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MatchLabelKeys is a set of pod label keys to select the pods over which spreading will be calculated. The keys are used to lookup values from the incoming pod labels, those key-value labels are ANDed with labelSelector to select the group of existing pods over which spreading will be calculated for the incoming pod. The same key is forbidden to exist in both MatchLabelKeys and LabelSelector. MatchLabelKeys cannot be set when LabelSelector isn't set. Keys that don't exist in the incoming pod labels will be ignored. A null or empty list means only match against labelSelector.  This is a beta field and requires the MatchLabelKeysInPodTopologySpread feature gate to be enabled (enabled by default).")
    public List<String> getMatchLabelKeys() {
        return this.matchLabelKeys;
    }

    public void setMatchLabelKeys(List<String> matchLabelKeys) {
        this.matchLabelKeys = matchLabelKeys;
    }

    public V1TopologySpreadConstraint maxSkew(Integer maxSkew) {
        this.maxSkew = maxSkew;
        return this;
    }

    @ApiModelProperty(required=true, value="MaxSkew describes the degree to which pods may be unevenly distributed. When `whenUnsatisfiable=DoNotSchedule`, it is the maximum permitted difference between the number of matching pods in the target topology and the global minimum. The global minimum is the minimum number of matching pods in an eligible domain or zero if the number of eligible domains is less than MinDomains. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 2/2/1: In this case, the global minimum is 1. | zone1 | zone2 | zone3 | |  P P  |  P P  |   P   | - if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 2/2/2; scheduling it onto zone1(zone2) would make the ActualSkew(3-1) on zone1(zone2) violate MaxSkew(1). - if MaxSkew is 2, incoming pod can be scheduled onto any zone. When `whenUnsatisfiable=ScheduleAnyway`, it is used to give higher precedence to topologies that satisfy it. It's a required field. Default value is 1 and 0 is not allowed.")
    public Integer getMaxSkew() {
        return this.maxSkew;
    }

    public void setMaxSkew(Integer maxSkew) {
        this.maxSkew = maxSkew;
    }

    public V1TopologySpreadConstraint minDomains(Integer minDomains) {
        this.minDomains = minDomains;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MinDomains indicates a minimum number of eligible domains. When the number of eligible domains with matching topology keys is less than minDomains, Pod Topology Spread treats \"global minimum\" as 0, and then the calculation of Skew is performed. And when the number of eligible domains with matching topology keys equals or greater than minDomains, this value has no effect on scheduling. As a result, when the number of eligible domains is less than minDomains, scheduler won't schedule more than maxSkew Pods to those domains. If value is nil, the constraint behaves as if MinDomains is equal to 1. Valid values are integers greater than 0. When value is not nil, WhenUnsatisfiable must be DoNotSchedule.  For example, in a 3-zone cluster, MaxSkew is set to 2, MinDomains is set to 5 and pods with the same labelSelector spread as 2/2/2: | zone1 | zone2 | zone3 | |  P P  |  P P  |  P P  | The number of domains is less than 5(MinDomains), so \"global minimum\" is treated as 0. In this situation, new pod with the same labelSelector cannot be scheduled, because computed skew will be 3(3 - 0) if new Pod is scheduled to any of the three zones, it will violate MaxSkew.")
    public Integer getMinDomains() {
        return this.minDomains;
    }

    public void setMinDomains(Integer minDomains) {
        this.minDomains = minDomains;
    }

    public V1TopologySpreadConstraint nodeAffinityPolicy(String nodeAffinityPolicy) {
        this.nodeAffinityPolicy = nodeAffinityPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NodeAffinityPolicy indicates how we will treat Pod's nodeAffinity/nodeSelector when calculating pod topology spread skew. Options are: - Honor: only nodes matching nodeAffinity/nodeSelector are included in the calculations. - Ignore: nodeAffinity/nodeSelector are ignored. All nodes are included in the calculations.  If this value is nil, the behavior is equivalent to the Honor policy.")
    public String getNodeAffinityPolicy() {
        return this.nodeAffinityPolicy;
    }

    public void setNodeAffinityPolicy(String nodeAffinityPolicy) {
        this.nodeAffinityPolicy = nodeAffinityPolicy;
    }

    public V1TopologySpreadConstraint nodeTaintsPolicy(String nodeTaintsPolicy) {
        this.nodeTaintsPolicy = nodeTaintsPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NodeTaintsPolicy indicates how we will treat node taints when calculating pod topology spread skew. Options are: - Honor: nodes without taints, along with tainted nodes for which the incoming pod has a toleration, are included. - Ignore: node taints are ignored. All nodes are included.  If this value is nil, the behavior is equivalent to the Ignore policy.")
    public String getNodeTaintsPolicy() {
        return this.nodeTaintsPolicy;
    }

    public void setNodeTaintsPolicy(String nodeTaintsPolicy) {
        this.nodeTaintsPolicy = nodeTaintsPolicy;
    }

    public V1TopologySpreadConstraint topologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
        return this;
    }

    @ApiModelProperty(required=true, value="TopologyKey is the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology. We consider each <key, value> as a \"bucket\", and try to put balanced number of pods into each bucket. We define a domain as a particular instance of a topology. Also, we define an eligible domain as a domain whose nodes meet the requirements of nodeAffinityPolicy and nodeTaintsPolicy. e.g. If TopologyKey is \"kubernetes.io/hostname\", each Node is a domain of that topology. And, if TopologyKey is \"topology.kubernetes.io/zone\", each zone is a domain of that topology. It's a required field.")
    public String getTopologyKey() {
        return this.topologyKey;
    }

    public void setTopologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
    }

    public V1TopologySpreadConstraint whenUnsatisfiable(String whenUnsatisfiable) {
        this.whenUnsatisfiable = whenUnsatisfiable;
        return this;
    }

    @ApiModelProperty(required=true, value="WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy the spread constraint. - DoNotSchedule (default) tells the scheduler not to schedule it. - ScheduleAnyway tells the scheduler to schedule the pod in any location,   but giving higher precedence to topologies that would help reduce the   skew. A constraint is considered \"Unsatisfiable\" for an incoming pod if and only if every possible node assignment for that pod would violate \"MaxSkew\" on some topology. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 3/1/1: | zone1 | zone2 | zone3 | | P P P |   P   |   P   | If WhenUnsatisfiable is set to DoNotSchedule, incoming pod can only be scheduled to zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies MaxSkew(1). In other words, the cluster can still be imbalanced, but scheduler won't make it *more* imbalanced. It's a required field.")
    public String getWhenUnsatisfiable() {
        return this.whenUnsatisfiable;
    }

    public void setWhenUnsatisfiable(String whenUnsatisfiable) {
        this.whenUnsatisfiable = whenUnsatisfiable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1TopologySpreadConstraint v1TopologySpreadConstraint = (V1TopologySpreadConstraint)o;
        return Objects.equals(this.labelSelector, v1TopologySpreadConstraint.labelSelector) && Objects.equals(this.matchLabelKeys, v1TopologySpreadConstraint.matchLabelKeys) && Objects.equals(this.maxSkew, v1TopologySpreadConstraint.maxSkew) && Objects.equals(this.minDomains, v1TopologySpreadConstraint.minDomains) && Objects.equals(this.nodeAffinityPolicy, v1TopologySpreadConstraint.nodeAffinityPolicy) && Objects.equals(this.nodeTaintsPolicy, v1TopologySpreadConstraint.nodeTaintsPolicy) && Objects.equals(this.topologyKey, v1TopologySpreadConstraint.topologyKey) && Objects.equals(this.whenUnsatisfiable, v1TopologySpreadConstraint.whenUnsatisfiable);
    }

    public int hashCode() {
        return Objects.hash(this.labelSelector, this.matchLabelKeys, this.maxSkew, this.minDomains, this.nodeAffinityPolicy, this.nodeTaintsPolicy, this.topologyKey, this.whenUnsatisfiable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1TopologySpreadConstraint {\n");
        sb.append("    labelSelector: ").append(this.toIndentedString(this.labelSelector)).append("\n");
        sb.append("    matchLabelKeys: ").append(this.toIndentedString(this.matchLabelKeys)).append("\n");
        sb.append("    maxSkew: ").append(this.toIndentedString(this.maxSkew)).append("\n");
        sb.append("    minDomains: ").append(this.toIndentedString(this.minDomains)).append("\n");
        sb.append("    nodeAffinityPolicy: ").append(this.toIndentedString(this.nodeAffinityPolicy)).append("\n");
        sb.append("    nodeTaintsPolicy: ").append(this.toIndentedString(this.nodeTaintsPolicy)).append("\n");
        sb.append("    topologyKey: ").append(this.toIndentedString(this.topologyKey)).append("\n");
        sb.append("    whenUnsatisfiable: ").append(this.toIndentedString(this.whenUnsatisfiable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

