/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1alpha1NamedRuleWithOperations;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="MatchResources decides whether to run the admission control policy on an object based on whether it meets the match criteria. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)")
public class V1alpha1MatchResources {
    public static final String SERIALIZED_NAME_EXCLUDE_RESOURCE_RULES = "excludeResourceRules";
    @SerializedName(value="excludeResourceRules")
    private List<V1alpha1NamedRuleWithOperations> excludeResourceRules = null;
    public static final String SERIALIZED_NAME_MATCH_POLICY = "matchPolicy";
    @SerializedName(value="matchPolicy")
    private String matchPolicy;
    public static final String SERIALIZED_NAME_NAMESPACE_SELECTOR = "namespaceSelector";
    @SerializedName(value="namespaceSelector")
    private V1LabelSelector namespaceSelector;
    public static final String SERIALIZED_NAME_OBJECT_SELECTOR = "objectSelector";
    @SerializedName(value="objectSelector")
    private V1LabelSelector objectSelector;
    public static final String SERIALIZED_NAME_RESOURCE_RULES = "resourceRules";
    @SerializedName(value="resourceRules")
    private List<V1alpha1NamedRuleWithOperations> resourceRules = null;

    public V1alpha1MatchResources excludeResourceRules(List<V1alpha1NamedRuleWithOperations> excludeResourceRules) {
        this.excludeResourceRules = excludeResourceRules;
        return this;
    }

    public V1alpha1MatchResources addExcludeResourceRulesItem(V1alpha1NamedRuleWithOperations excludeResourceRulesItem) {
        if (this.excludeResourceRules == null) {
            this.excludeResourceRules = new ArrayList<V1alpha1NamedRuleWithOperations>();
        }
        this.excludeResourceRules.add(excludeResourceRulesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ExcludeResourceRules describes what operations on what resources/subresources the policy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)")
    public List<V1alpha1NamedRuleWithOperations> getExcludeResourceRules() {
        return this.excludeResourceRules;
    }

    public void setExcludeResourceRules(List<V1alpha1NamedRuleWithOperations> excludeResourceRules) {
        this.excludeResourceRules = excludeResourceRules;
    }

    public V1alpha1MatchResources matchPolicy(String matchPolicy) {
        this.matchPolicy = matchPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="matchPolicy defines how the \"MatchResources\" list is used to match incoming requests. Allowed values are \"Exact\" or \"Equivalent\".  - Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, the admission policy does not consider requests to apps/v1beta1 or extensions/v1beta1 API groups.  - Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, the admission policy **does** consider requests made to apps/v1beta1 or extensions/v1beta1 API groups. The API server translates the request to a matched resource API if necessary.  Defaults to \"Equivalent\"")
    public String getMatchPolicy() {
        return this.matchPolicy;
    }

    public void setMatchPolicy(String matchPolicy) {
        this.matchPolicy = matchPolicy;
    }

    public V1alpha1MatchResources namespaceSelector(V1LabelSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getNamespaceSelector() {
        return this.namespaceSelector;
    }

    public void setNamespaceSelector(V1LabelSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
    }

    public V1alpha1MatchResources objectSelector(V1LabelSelector objectSelector) {
        this.objectSelector = objectSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getObjectSelector() {
        return this.objectSelector;
    }

    public void setObjectSelector(V1LabelSelector objectSelector) {
        this.objectSelector = objectSelector;
    }

    public V1alpha1MatchResources resourceRules(List<V1alpha1NamedRuleWithOperations> resourceRules) {
        this.resourceRules = resourceRules;
        return this;
    }

    public V1alpha1MatchResources addResourceRulesItem(V1alpha1NamedRuleWithOperations resourceRulesItem) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList<V1alpha1NamedRuleWithOperations>();
        }
        this.resourceRules.add(resourceRulesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceRules describes what operations on what resources/subresources the admission policy matches. The policy cares about an operation if it matches _any_ Rule.")
    public List<V1alpha1NamedRuleWithOperations> getResourceRules() {
        return this.resourceRules;
    }

    public void setResourceRules(List<V1alpha1NamedRuleWithOperations> resourceRules) {
        this.resourceRules = resourceRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1MatchResources v1alpha1MatchResources = (V1alpha1MatchResources)o;
        return Objects.equals(this.excludeResourceRules, v1alpha1MatchResources.excludeResourceRules) && Objects.equals(this.matchPolicy, v1alpha1MatchResources.matchPolicy) && Objects.equals(this.namespaceSelector, v1alpha1MatchResources.namespaceSelector) && Objects.equals(this.objectSelector, v1alpha1MatchResources.objectSelector) && Objects.equals(this.resourceRules, v1alpha1MatchResources.resourceRules);
    }

    public int hashCode() {
        return Objects.hash(this.excludeResourceRules, this.matchPolicy, this.namespaceSelector, this.objectSelector, this.resourceRules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1MatchResources {\n");
        sb.append("    excludeResourceRules: ").append(this.toIndentedString(this.excludeResourceRules)).append("\n");
        sb.append("    matchPolicy: ").append(this.toIndentedString(this.matchPolicy)).append("\n");
        sb.append("    namespaceSelector: ").append(this.toIndentedString(this.namespaceSelector)).append("\n");
        sb.append("    objectSelector: ").append(this.toIndentedString(this.objectSelector)).append("\n");
        sb.append("    resourceRules: ").append(this.toIndentedString(this.resourceRules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

