/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluent;
import io.kubernetes.client.openapi.models.V1alpha1ParamRef;
import java.util.Objects;
import java.util.Optional;

public class V1alpha1ParamRefFluent<A extends V1alpha1ParamRefFluent<A>>
extends BaseFluent<A> {
    private String name;
    private String namespace;
    private String parameterNotFoundAction;
    private V1LabelSelectorBuilder selector;

    public V1alpha1ParamRefFluent() {
    }

    public V1alpha1ParamRefFluent(V1alpha1ParamRef instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha1ParamRef instance) {
        V1alpha1ParamRef v1alpha1ParamRef = instance = instance != null ? instance : new V1alpha1ParamRef();
        if (instance != null) {
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withParameterNotFoundAction(instance.getParameterNotFoundAction());
            this.withSelector(instance.getSelector());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public String getParameterNotFoundAction() {
        return this.parameterNotFoundAction;
    }

    public A withParameterNotFoundAction(String parameterNotFoundAction) {
        this.parameterNotFoundAction = parameterNotFoundAction;
        return (A)this;
    }

    public boolean hasParameterNotFoundAction() {
        return this.parameterNotFoundAction != null;
    }

    public V1LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(V1LabelSelector selector) {
        this._visitables.remove("selector");
        if (selector != null) {
            this.selector = new V1LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get("selector").remove(this.selector);
        }
        return (A)this;
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(V1LabelSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new V1LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha1ParamRefFluent that = (V1alpha1ParamRefFluent)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.parameterNotFoundAction, that.parameterNotFoundAction)) {
            return false;
        }
        return Objects.equals(this.selector, that.selector);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.namespace, this.parameterNotFoundAction, this.selector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace);
            sb.append(",");
        }
        if (this.parameterNotFoundAction != null) {
            sb.append("parameterNotFoundAction:");
            sb.append(this.parameterNotFoundAction);
            sb.append(",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SelectorNested<N>
    extends V1LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        V1LabelSelectorBuilder builder;

        SelectorNested(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha1ParamRefFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }
}

