/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1beta1DeviceClaimConfiguration;
import io.kubernetes.client.openapi.models.V1beta1DeviceConstraint;
import io.kubernetes.client.openapi.models.V1beta1DeviceRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DeviceClaim defines how to request devices with a ResourceClaim.")
public class V1beta1DeviceClaim {
    public static final String SERIALIZED_NAME_CONFIG = "config";
    @SerializedName(value="config")
    private List<V1beta1DeviceClaimConfiguration> config = null;
    public static final String SERIALIZED_NAME_CONSTRAINTS = "constraints";
    @SerializedName(value="constraints")
    private List<V1beta1DeviceConstraint> constraints = null;
    public static final String SERIALIZED_NAME_REQUESTS = "requests";
    @SerializedName(value="requests")
    private List<V1beta1DeviceRequest> requests = null;

    public V1beta1DeviceClaim config(List<V1beta1DeviceClaimConfiguration> config) {
        this.config = config;
        return this;
    }

    public V1beta1DeviceClaim addConfigItem(V1beta1DeviceClaimConfiguration configItem) {
        if (this.config == null) {
            this.config = new ArrayList<V1beta1DeviceClaimConfiguration>();
        }
        this.config.add(configItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This field holds configuration for multiple potential drivers which could satisfy requests in this claim. It is ignored while allocating the claim.")
    public List<V1beta1DeviceClaimConfiguration> getConfig() {
        return this.config;
    }

    public void setConfig(List<V1beta1DeviceClaimConfiguration> config) {
        this.config = config;
    }

    public V1beta1DeviceClaim constraints(List<V1beta1DeviceConstraint> constraints) {
        this.constraints = constraints;
        return this;
    }

    public V1beta1DeviceClaim addConstraintsItem(V1beta1DeviceConstraint constraintsItem) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<V1beta1DeviceConstraint>();
        }
        this.constraints.add(constraintsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="These constraints must be satisfied by the set of devices that get allocated for the claim.")
    public List<V1beta1DeviceConstraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<V1beta1DeviceConstraint> constraints) {
        this.constraints = constraints;
    }

    public V1beta1DeviceClaim requests(List<V1beta1DeviceRequest> requests) {
        this.requests = requests;
        return this;
    }

    public V1beta1DeviceClaim addRequestsItem(V1beta1DeviceRequest requestsItem) {
        if (this.requests == null) {
            this.requests = new ArrayList<V1beta1DeviceRequest>();
        }
        this.requests.add(requestsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Requests represent individual requests for distinct devices which must all be satisfied. If empty, nothing needs to be allocated.")
    public List<V1beta1DeviceRequest> getRequests() {
        return this.requests;
    }

    public void setRequests(List<V1beta1DeviceRequest> requests) {
        this.requests = requests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1DeviceClaim v1beta1DeviceClaim = (V1beta1DeviceClaim)o;
        return Objects.equals(this.config, v1beta1DeviceClaim.config) && Objects.equals(this.constraints, v1beta1DeviceClaim.constraints) && Objects.equals(this.requests, v1beta1DeviceClaim.requests);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.constraints, this.requests);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1DeviceClaim {\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    constraints: ").append(this.toIndentedString(this.constraints)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

