/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1beta1CapacityRequirements;
import io.kubernetes.client.openapi.models.V1beta1DeviceSelector;
import io.kubernetes.client.openapi.models.V1beta1DeviceSubRequest;
import io.kubernetes.client.openapi.models.V1beta1DeviceToleration;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices.")
public class V1beta1DeviceRequest {
    public static final String SERIALIZED_NAME_ADMIN_ACCESS = "adminAccess";
    @SerializedName(value="adminAccess")
    private Boolean adminAccess;
    public static final String SERIALIZED_NAME_ALLOCATION_MODE = "allocationMode";
    @SerializedName(value="allocationMode")
    private String allocationMode;
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    private V1beta1CapacityRequirements capacity;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Long count;
    public static final String SERIALIZED_NAME_DEVICE_CLASS_NAME = "deviceClassName";
    @SerializedName(value="deviceClassName")
    private String deviceClassName;
    public static final String SERIALIZED_NAME_FIRST_AVAILABLE = "firstAvailable";
    @SerializedName(value="firstAvailable")
    private List<V1beta1DeviceSubRequest> firstAvailable = null;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_SELECTORS = "selectors";
    @SerializedName(value="selectors")
    private List<V1beta1DeviceSelector> selectors = null;
    public static final String SERIALIZED_NAME_TOLERATIONS = "tolerations";
    @SerializedName(value="tolerations")
    private List<V1beta1DeviceToleration> tolerations = null;

    public V1beta1DeviceRequest adminAccess(Boolean adminAccess) {
        this.adminAccess = adminAccess;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AdminAccess indicates that this is a claim for administrative access to the device(s). Claims with AdminAccess are expected to be used for monitoring or other management services for a device.  They ignore all ordinary claims to the device with respect to access modes and any resource allocations.  This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.  This is an alpha field and requires enabling the DRAAdminAccess feature gate. Admin access is disabled if this field is unset or set to false, otherwise it is enabled.")
    public Boolean getAdminAccess() {
        return this.adminAccess;
    }

    public void setAdminAccess(Boolean adminAccess) {
        this.adminAccess = adminAccess;
    }

    public V1beta1DeviceRequest allocationMode(String allocationMode) {
        this.allocationMode = allocationMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllocationMode and its related fields define how devices are allocated to satisfy this request. Supported values are:  - ExactCount: This request is for a specific number of devices.   This is the default. The exact number is provided in the   count field.  - All: This request is for all of the matching devices in a pool.   At least one device must exist on the node for the allocation to succeed.   Allocation will fail if some devices are already allocated,   unless adminAccess is requested.  If AllocationMode is not specified, the default mode is ExactCount. If the mode is ExactCount and count is not specified, the default count is one. Any other requests must specify this field.  This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.  More modes may get added in the future. Clients must refuse to handle requests with unknown modes.")
    public String getAllocationMode() {
        return this.allocationMode;
    }

    public void setAllocationMode(String allocationMode) {
        this.allocationMode = allocationMode;
    }

    public V1beta1DeviceRequest capacity(V1beta1CapacityRequirements capacity) {
        this.capacity = capacity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta1CapacityRequirements getCapacity() {
        return this.capacity;
    }

    public void setCapacity(V1beta1CapacityRequirements capacity) {
        this.capacity = capacity;
    }

    public V1beta1DeviceRequest count(Long count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Count is used only when the count mode is \"ExactCount\". Must be greater than zero. If AllocationMode is ExactCount and this field is not specified, the default is one.  This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.")
    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public V1beta1DeviceRequest deviceClassName(String deviceClassName) {
        this.deviceClassName = deviceClassName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DeviceClassName references a specific DeviceClass, which can define additional configuration and selectors to be inherited by this request.  A class is required if no subrequests are specified in the firstAvailable list and no class can be set if subrequests are specified in the firstAvailable list. Which classes are available depends on the cluster.  Administrators may use this to restrict which devices may get requested by only installing classes with selectors for permitted devices. If users are free to request anything without restrictions, then administrators can create an empty DeviceClass for users to reference.")
    public String getDeviceClassName() {
        return this.deviceClassName;
    }

    public void setDeviceClassName(String deviceClassName) {
        this.deviceClassName = deviceClassName;
    }

    public V1beta1DeviceRequest firstAvailable(List<V1beta1DeviceSubRequest> firstAvailable) {
        this.firstAvailable = firstAvailable;
        return this;
    }

    public V1beta1DeviceRequest addFirstAvailableItem(V1beta1DeviceSubRequest firstAvailableItem) {
        if (this.firstAvailable == null) {
            this.firstAvailable = new ArrayList<V1beta1DeviceSubRequest>();
        }
        this.firstAvailable.add(firstAvailableItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="FirstAvailable contains subrequests, of which exactly one will be satisfied by the scheduler to satisfy this request. It tries to satisfy them in the order in which they are listed here. So if there are two entries in the list, the scheduler will only check the second one if it determines that the first one cannot be used.  This field may only be set in the entries of DeviceClaim.Requests.  DRA does not yet implement scoring, so the scheduler will select the first set of devices that satisfies all the requests in the claim. And if the requirements can be satisfied on more than one node, other scheduling features will determine which node is chosen. This means that the set of devices allocated to a claim might not be the optimal set available to the cluster. Scoring will be implemented later.")
    public List<V1beta1DeviceSubRequest> getFirstAvailable() {
        return this.firstAvailable;
    }

    public void setFirstAvailable(List<V1beta1DeviceSubRequest> firstAvailable) {
        this.firstAvailable = firstAvailable;
    }

    public V1beta1DeviceRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.  Must be a DNS label and unique among all DeviceRequests in a ResourceClaim.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1beta1DeviceRequest selectors(List<V1beta1DeviceSelector> selectors) {
        this.selectors = selectors;
        return this;
    }

    public V1beta1DeviceRequest addSelectorsItem(V1beta1DeviceSelector selectorsItem) {
        if (this.selectors == null) {
            this.selectors = new ArrayList<V1beta1DeviceSelector>();
        }
        this.selectors.add(selectorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Selectors define criteria which must be satisfied by a specific device in order for that device to be considered for this request. All selectors must be satisfied for a device to be considered.  This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.")
    public List<V1beta1DeviceSelector> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(List<V1beta1DeviceSelector> selectors) {
        this.selectors = selectors;
    }

    public V1beta1DeviceRequest tolerations(List<V1beta1DeviceToleration> tolerations) {
        this.tolerations = tolerations;
        return this;
    }

    public V1beta1DeviceRequest addTolerationsItem(V1beta1DeviceToleration tolerationsItem) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1beta1DeviceToleration>();
        }
        this.tolerations.add(tolerationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, the request's tolerations.  Tolerations for NoSchedule are required to allocate a device which has a taint with that effect. The same applies to NoExecute.  In addition, should any of the allocated devices get tainted with NoExecute after allocation and that effect is not tolerated, then all pods consuming the ResourceClaim get deleted to evict them. The scheduler will not let new pods reserve the claim while it has these tainted devices. Once all pods are evicted, the claim will get deallocated.  The maximum number of tolerations is 16.  This field can only be set when deviceClassName is set and no subrequests are specified in the firstAvailable list.  This is an alpha field and requires enabling the DRADeviceTaints feature gate.")
    public List<V1beta1DeviceToleration> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(List<V1beta1DeviceToleration> tolerations) {
        this.tolerations = tolerations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1DeviceRequest v1beta1DeviceRequest = (V1beta1DeviceRequest)o;
        return Objects.equals(this.adminAccess, v1beta1DeviceRequest.adminAccess) && Objects.equals(this.allocationMode, v1beta1DeviceRequest.allocationMode) && Objects.equals(this.capacity, v1beta1DeviceRequest.capacity) && Objects.equals(this.count, v1beta1DeviceRequest.count) && Objects.equals(this.deviceClassName, v1beta1DeviceRequest.deviceClassName) && Objects.equals(this.firstAvailable, v1beta1DeviceRequest.firstAvailable) && Objects.equals(this.name, v1beta1DeviceRequest.name) && Objects.equals(this.selectors, v1beta1DeviceRequest.selectors) && Objects.equals(this.tolerations, v1beta1DeviceRequest.tolerations);
    }

    public int hashCode() {
        return Objects.hash(this.adminAccess, this.allocationMode, this.capacity, this.count, this.deviceClassName, this.firstAvailable, this.name, this.selectors, this.tolerations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1DeviceRequest {\n");
        sb.append("    adminAccess: ").append(this.toIndentedString(this.adminAccess)).append("\n");
        sb.append("    allocationMode: ").append(this.toIndentedString(this.allocationMode)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    deviceClassName: ").append(this.toIndentedString(this.deviceClassName)).append("\n");
        sb.append("    firstAvailable: ").append(this.toIndentedString(this.firstAvailable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    selectors: ").append(this.toIndentedString(this.selectors)).append("\n");
        sb.append("    tolerations: ").append(this.toIndentedString(this.tolerations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

