/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1beta1NetworkDeviceData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1beta1NetworkDeviceDataFluent<A extends V1beta1NetworkDeviceDataFluent<A>>
extends BaseFluent<A> {
    private String hardwareAddress;
    private String interfaceName;
    private List<String> ips;

    public V1beta1NetworkDeviceDataFluent() {
    }

    public V1beta1NetworkDeviceDataFluent(V1beta1NetworkDeviceData instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1beta1NetworkDeviceData instance) {
        V1beta1NetworkDeviceData v1beta1NetworkDeviceData = instance = instance != null ? instance : new V1beta1NetworkDeviceData();
        if (instance != null) {
            this.withHardwareAddress(instance.getHardwareAddress());
            this.withInterfaceName(instance.getInterfaceName());
            this.withIps(instance.getIps());
        }
    }

    public String getHardwareAddress() {
        return this.hardwareAddress;
    }

    public A withHardwareAddress(String hardwareAddress) {
        this.hardwareAddress = hardwareAddress;
        return (A)this;
    }

    public boolean hasHardwareAddress() {
        return this.hardwareAddress != null;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public A withInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
        return (A)this;
    }

    public boolean hasInterfaceName() {
        return this.interfaceName != null;
    }

    public A addToIps(int index, String item) {
        if (this.ips == null) {
            this.ips = new ArrayList<String>();
        }
        this.ips.add(index, item);
        return (A)this;
    }

    public A setToIps(int index, String item) {
        if (this.ips == null) {
            this.ips = new ArrayList<String>();
        }
        this.ips.set(index, item);
        return (A)this;
    }

    public A addToIps(String ... items) {
        if (this.ips == null) {
            this.ips = new ArrayList<String>();
        }
        for (String item : items) {
            this.ips.add(item);
        }
        return (A)this;
    }

    public A addAllToIps(Collection<String> items) {
        if (this.ips == null) {
            this.ips = new ArrayList<String>();
        }
        for (String item : items) {
            this.ips.add(item);
        }
        return (A)this;
    }

    public A removeFromIps(String ... items) {
        if (this.ips == null) {
            return (A)this;
        }
        for (String item : items) {
            this.ips.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromIps(Collection<String> items) {
        if (this.ips == null) {
            return (A)this;
        }
        for (String item : items) {
            this.ips.remove(item);
        }
        return (A)this;
    }

    public List<String> getIps() {
        return this.ips;
    }

    public String getIp(int index) {
        return this.ips.get(index);
    }

    public String getFirstIp() {
        return this.ips.get(0);
    }

    public String getLastIp() {
        return this.ips.get(this.ips.size() - 1);
    }

    public String getMatchingIp(Predicate<String> predicate) {
        for (String item : this.ips) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIp(Predicate<String> predicate) {
        for (String item : this.ips) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIps(List<String> ips) {
        if (ips != null) {
            this.ips = new ArrayList<String>();
            for (String item : ips) {
                this.addToIps(item);
            }
        } else {
            this.ips = null;
        }
        return (A)this;
    }

    public A withIps(String ... ips) {
        if (this.ips != null) {
            this.ips.clear();
            this._visitables.remove("ips");
        }
        if (ips != null) {
            for (String item : ips) {
                this.addToIps(item);
            }
        }
        return (A)this;
    }

    public boolean hasIps() {
        return this.ips != null && !this.ips.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1beta1NetworkDeviceDataFluent that = (V1beta1NetworkDeviceDataFluent)o;
        if (!Objects.equals(this.hardwareAddress, that.hardwareAddress)) {
            return false;
        }
        if (!Objects.equals(this.interfaceName, that.interfaceName)) {
            return false;
        }
        return Objects.equals(this.ips, that.ips);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hardwareAddress, this.interfaceName, this.ips);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hardwareAddress != null) {
            sb.append("hardwareAddress:");
            sb.append(this.hardwareAddress);
            sb.append(",");
        }
        if (this.interfaceName != null) {
            sb.append("interfaceName:");
            sb.append(this.interfaceName);
            sb.append(",");
        }
        if (this.ips != null && !this.ips.isEmpty()) {
            sb.append("ips:");
            sb.append(this.ips);
        }
        sb.append("}");
        return sb.toString();
    }
}

