/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.models.V2HPAScalingPolicy;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="HPAScalingRules configures the scaling behavior for one direction via scaling Policy Rules and a configurable metric tolerance.  Scaling Policy Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.  The tolerance is applied to the metric values and prevents scaling too eagerly for small metric variations. (Note that setting a tolerance requires enabling the alpha HPAConfigurableTolerance feature gate.)")
public class V2HPAScalingRules {
    public static final String SERIALIZED_NAME_POLICIES = "policies";
    @SerializedName(value="policies")
    private List<V2HPAScalingPolicy> policies = null;
    public static final String SERIALIZED_NAME_SELECT_POLICY = "selectPolicy";
    @SerializedName(value="selectPolicy")
    private String selectPolicy;
    public static final String SERIALIZED_NAME_STABILIZATION_WINDOW_SECONDS = "stabilizationWindowSeconds";
    @SerializedName(value="stabilizationWindowSeconds")
    private Integer stabilizationWindowSeconds;
    public static final String SERIALIZED_NAME_TOLERANCE = "tolerance";
    @SerializedName(value="tolerance")
    private Quantity tolerance;

    public V2HPAScalingRules policies(List<V2HPAScalingPolicy> policies) {
        this.policies = policies;
        return this;
    }

    public V2HPAScalingRules addPoliciesItem(V2HPAScalingPolicy policiesItem) {
        if (this.policies == null) {
            this.policies = new ArrayList<V2HPAScalingPolicy>();
        }
        this.policies.add(policiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="policies is a list of potential scaling polices which can be used during scaling. If not set, use the default values: - For scale up: allow doubling the number of pods, or an absolute change of 4 pods in a 15s window. - For scale down: allow all pods to be removed in a 15s window.")
    public List<V2HPAScalingPolicy> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<V2HPAScalingPolicy> policies) {
        this.policies = policies;
    }

    public V2HPAScalingRules selectPolicy(String selectPolicy) {
        this.selectPolicy = selectPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.")
    public String getSelectPolicy() {
        return this.selectPolicy;
    }

    public void setSelectPolicy(String selectPolicy) {
        this.selectPolicy = selectPolicy;
    }

    public V2HPAScalingRules stabilizationWindowSeconds(Integer stabilizationWindowSeconds) {
        this.stabilizationWindowSeconds = stabilizationWindowSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).")
    public Integer getStabilizationWindowSeconds() {
        return this.stabilizationWindowSeconds;
    }

    public void setStabilizationWindowSeconds(Integer stabilizationWindowSeconds) {
        this.stabilizationWindowSeconds = stabilizationWindowSeconds;
    }

    public V2HPAScalingRules tolerance(Quantity tolerance) {
        this.tolerance = tolerance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Quantity is a fixed-point representation of a number. It provides convenient marshaling/unmarshaling in JSON and YAML, in addition to String() and AsInt64() accessors.  The serialization format is:  ``` <quantity>        ::= <signedNumber><suffix>   (Note that <suffix> may be empty, from the \"\" case in <decimalSI>.)  <digit>           ::= 0 | 1 | ... | 9 <digits>          ::= <digit> | <digit><digits> <number>          ::= <digits> | <digits>.<digits> | <digits>. | .<digits> <sign>            ::= \"+\" | \"-\" <signedNumber>    ::= <number> | <sign><number> <suffix>          ::= <binarySI> | <decimalExponent> | <decimalSI> <binarySI>        ::= Ki | Mi | Gi | Ti | Pi | Ei   (International System of units; See: http://physics.nist.gov/cuu/Units/binary.html)  <decimalSI>       ::= m | \"\" | k | M | G | T | P | E   (Note that 1024 = 1Ki but 1000 = 1k; I didn't choose the capitalization.)  <decimalExponent> ::= \"e\" <signedNumber> | \"E\" <signedNumber> ```  No matter which of the three exponent forms is used, no quantity may represent a number greater than 2^63-1 in magnitude, nor may it have more than 3 decimal places. Numbers larger or more precise will be capped or rounded up. (E.g.: 0.1m will rounded up to 1m.) This may be extended in the future if we require larger or smaller quantities.  When a Quantity is parsed from a string, it will remember the type of suffix it had, and will use the same type again when it is serialized.  Before serializing, Quantity will be put in \"canonical form\". This means that Exponent/suffix will be adjusted up or down (with a corresponding increase or decrease in Mantissa) such that:  - No precision is lost - No fractional digits will be emitted - The exponent (or suffix) is as large as possible.  The sign will be omitted unless the number is negative.  Examples:  - 1.5 will be serialized as \"1500m\" - 1.5Gi will be serialized as \"1536Mi\"  Note that the quantity will NEVER be internally represented by a floating point number. That is the whole point of this exercise.  Non-canonical values will still parse as long as they are well formed, but will be re-emitted in their canonical form. (So always use canonical form, or don't diff.)  This format is intended to make it difficult to use these numbers without writing some sort of special handling code in the hopes that that will cause implementors to also use a fixed point implementation.")
    public Quantity getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(Quantity tolerance) {
        this.tolerance = tolerance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2HPAScalingRules v2HPAScalingRules = (V2HPAScalingRules)o;
        return Objects.equals(this.policies, v2HPAScalingRules.policies) && Objects.equals(this.selectPolicy, v2HPAScalingRules.selectPolicy) && Objects.equals(this.stabilizationWindowSeconds, v2HPAScalingRules.stabilizationWindowSeconds) && Objects.equals(this.tolerance, v2HPAScalingRules.tolerance);
    }

    public int hashCode() {
        return Objects.hash(this.policies, this.selectPolicy, this.stabilizationWindowSeconds, this.tolerance);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2HPAScalingRules {\n");
        sb.append("    policies: ").append(this.toIndentedString(this.policies)).append("\n");
        sb.append("    selectPolicy: ").append(this.toIndentedString(this.selectPolicy)).append("\n");
        sb.append("    stabilizationWindowSeconds: ").append(this.toIndentedString(this.stabilizationWindowSeconds)).append("\n");
        sb.append("    tolerance: ").append(this.toIndentedString(this.tolerance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

