/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V2MetricValueStatus;
import java.util.Objects;

public class V2MetricValueStatusFluent<A extends V2MetricValueStatusFluent<A>>
extends BaseFluent<A> {
    private Integer averageUtilization;
    private Quantity averageValue;
    private Quantity value;

    public V2MetricValueStatusFluent() {
    }

    public V2MetricValueStatusFluent(V2MetricValueStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V2MetricValueStatus instance) {
        V2MetricValueStatus v2MetricValueStatus = instance = instance != null ? instance : new V2MetricValueStatus();
        if (instance != null) {
            this.withAverageUtilization(instance.getAverageUtilization());
            this.withAverageValue(instance.getAverageValue());
            this.withValue(instance.getValue());
        }
    }

    public Integer getAverageUtilization() {
        return this.averageUtilization;
    }

    public A withAverageUtilization(Integer averageUtilization) {
        this.averageUtilization = averageUtilization;
        return (A)this;
    }

    public boolean hasAverageUtilization() {
        return this.averageUtilization != null;
    }

    public Quantity getAverageValue() {
        return this.averageValue;
    }

    public A withAverageValue(Quantity averageValue) {
        this.averageValue = averageValue;
        return (A)this;
    }

    public boolean hasAverageValue() {
        return this.averageValue != null;
    }

    public A withNewAverageValue(String value) {
        return this.withAverageValue(new Quantity(value));
    }

    public Quantity getValue() {
        return this.value;
    }

    public A withValue(Quantity value) {
        this.value = value;
        return (A)this;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public A withNewValue(String value) {
        return this.withValue(new Quantity(value));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V2MetricValueStatusFluent that = (V2MetricValueStatusFluent)o;
        if (!Objects.equals(this.averageUtilization, that.averageUtilization)) {
            return false;
        }
        if (!Objects.equals(this.averageValue, that.averageValue)) {
            return false;
        }
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.averageUtilization, this.averageValue, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.averageUtilization != null) {
            sb.append("averageUtilization:");
            sb.append(this.averageUtilization);
            sb.append(",");
        }
        if (this.averageValue != null) {
            sb.append("averageValue:");
            sb.append(this.averageValue);
            sb.append(",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value);
        }
        sb.append("}");
        return sb.toString();
    }
}

