package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1AggregationRuleBuilder extends V1AggregationRuleFluentImpl<V1AggregationRuleBuilder> implements VisitableBuilder<V1AggregationRule,V1AggregationRuleBuilder> {

    V1AggregationRuleFluent<?> fluent;
    Boolean validationEnabled;

    public V1AggregationRuleBuilder() { 
        this(true);
    }


    public V1AggregationRuleBuilder(Boolean validationEnabled) { 
        this(new V1AggregationRule(), validationEnabled);
    }


    public V1AggregationRuleBuilder(V1AggregationRuleFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1AggregationRuleBuilder(V1AggregationRuleFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1AggregationRule(), validationEnabled);
    }


    public V1AggregationRuleBuilder(V1AggregationRuleFluent<?> fluent,V1AggregationRule instance) { 
        this(fluent, instance, true);
    }


    public V1AggregationRuleBuilder(V1AggregationRuleFluent<?> fluent,V1AggregationRule instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withClusterRoleSelectors(instance.getClusterRoleSelectors());

        this.validationEnabled = validationEnabled; 
    }


    public V1AggregationRuleBuilder(V1AggregationRule instance) { 
        this(instance,true);
    }


    public V1AggregationRuleBuilder(V1AggregationRule instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withClusterRoleSelectors(instance.getClusterRoleSelectors());

        this.validationEnabled = validationEnabled; 
    }


    public V1AggregationRule build() {
        V1AggregationRule buildable = new V1AggregationRule();
        buildable.setClusterRoleSelectors(fluent.getClusterRoleSelectors());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1AggregationRuleBuilder that = (V1AggregationRuleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
