package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1CertificateSigningRequestBuilder extends V1CertificateSigningRequestFluentImpl<V1CertificateSigningRequestBuilder> implements VisitableBuilder<V1CertificateSigningRequest,V1CertificateSigningRequestBuilder> {

    V1CertificateSigningRequestFluent<?> fluent;
    Boolean validationEnabled;

    public V1CertificateSigningRequestBuilder() { 
        this(true);
    }


    public V1CertificateSigningRequestBuilder(Boolean validationEnabled) { 
        this(new V1CertificateSigningRequest(), validationEnabled);
    }


    public V1CertificateSigningRequestBuilder(V1CertificateSigningRequestFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1CertificateSigningRequestBuilder(V1CertificateSigningRequestFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1CertificateSigningRequest(), validationEnabled);
    }


    public V1CertificateSigningRequestBuilder(V1CertificateSigningRequestFluent<?> fluent,V1CertificateSigningRequest instance) { 
        this(fluent, instance, true);
    }


    public V1CertificateSigningRequestBuilder(V1CertificateSigningRequestFluent<?> fluent,V1CertificateSigningRequest instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());

        fluent.withKind(instance.getKind());

        fluent.withMetadata(instance.getMetadata());

        fluent.withSpec(instance.getSpec());

        fluent.withStatus(instance.getStatus());

        this.validationEnabled = validationEnabled; 
    }


    public V1CertificateSigningRequestBuilder(V1CertificateSigningRequest instance) { 
        this(instance,true);
    }


    public V1CertificateSigningRequestBuilder(V1CertificateSigningRequest instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());

        this.withKind(instance.getKind());

        this.withMetadata(instance.getMetadata());

        this.withSpec(instance.getSpec());

        this.withStatus(instance.getStatus());

        this.validationEnabled = validationEnabled; 
    }


    public V1CertificateSigningRequest build() {
        V1CertificateSigningRequest buildable = new V1CertificateSigningRequest();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1CertificateSigningRequestBuilder that = (V1CertificateSigningRequestBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
