package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ConfigMapEnvSourceBuilder extends V1ConfigMapEnvSourceFluentImpl<V1ConfigMapEnvSourceBuilder> implements VisitableBuilder<V1ConfigMapEnvSource,V1ConfigMapEnvSourceBuilder> {

    V1ConfigMapEnvSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1ConfigMapEnvSourceBuilder() { 
        this(true);
    }


    public V1ConfigMapEnvSourceBuilder(Boolean validationEnabled) { 
        this(new V1ConfigMapEnvSource(), validationEnabled);
    }


    public V1ConfigMapEnvSourceBuilder(V1ConfigMapEnvSourceFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1ConfigMapEnvSourceBuilder(V1ConfigMapEnvSourceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1ConfigMapEnvSource(), validationEnabled);
    }


    public V1ConfigMapEnvSourceBuilder(V1ConfigMapEnvSourceFluent<?> fluent,V1ConfigMapEnvSource instance) { 
        this(fluent, instance, true);
    }


    public V1ConfigMapEnvSourceBuilder(V1ConfigMapEnvSourceFluent<?> fluent,V1ConfigMapEnvSource instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withName(instance.getName());

        fluent.withOptional(instance.getOptional());

        this.validationEnabled = validationEnabled; 
    }


    public V1ConfigMapEnvSourceBuilder(V1ConfigMapEnvSource instance) { 
        this(instance,true);
    }


    public V1ConfigMapEnvSourceBuilder(V1ConfigMapEnvSource instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withName(instance.getName());

        this.withOptional(instance.getOptional());

        this.validationEnabled = validationEnabled; 
    }


    public V1ConfigMapEnvSource build() {
        V1ConfigMapEnvSource buildable = new V1ConfigMapEnvSource();
        buildable.setName(fluent.getName());
        buildable.setOptional(fluent.isOptional());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1ConfigMapEnvSourceBuilder that = (V1ConfigMapEnvSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
