package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1NamespaceStatusFluentImpl<A extends V1NamespaceStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1NamespaceStatusFluent<A> {

    private List<V1NamespaceConditionBuilder> conditions;
    private String phase;

    public V1NamespaceStatusFluentImpl() { 
    }


    public V1NamespaceStatusFluentImpl(V1NamespaceStatus instance) { 
        this.withConditions(instance.getConditions());

        this.withPhase(instance.getPhase());

    }


    public A addToConditions(int index,V1NamespaceCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<V1NamespaceConditionBuilder>();}
        V1NamespaceConditionBuilder builder = new V1NamespaceConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,V1NamespaceCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<V1NamespaceConditionBuilder>();}
        V1NamespaceConditionBuilder builder = new V1NamespaceConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(V1NamespaceCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<V1NamespaceConditionBuilder>();}
        for (V1NamespaceCondition item : items) {V1NamespaceConditionBuilder builder = new V1NamespaceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<V1NamespaceCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<V1NamespaceConditionBuilder>();}
        for (V1NamespaceCondition item : items) {V1NamespaceConditionBuilder builder = new V1NamespaceConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(V1NamespaceCondition... items) {
        for (V1NamespaceCondition item : items) {V1NamespaceConditionBuilder builder = new V1NamespaceConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<V1NamespaceCondition> items) {
        for (V1NamespaceCondition item : items) {V1NamespaceConditionBuilder builder = new V1NamespaceConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(io.kubernetes.client.fluent.Predicate<V1NamespaceConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<V1NamespaceConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          V1NamespaceConditionBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1NamespaceCondition> getConditions() {
        return build(conditions);
    }

    public List<V1NamespaceCondition> buildConditions() {
        return build(conditions);
    }

    public V1NamespaceCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public V1NamespaceCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public V1NamespaceCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public V1NamespaceCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1NamespaceConditionBuilder> predicate) {
        for (V1NamespaceConditionBuilder item: conditions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<V1NamespaceConditionBuilder> predicate) {
        for (V1NamespaceConditionBuilder item: conditions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConditions(List<V1NamespaceCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<V1NamespaceConditionBuilder>(); for (V1NamespaceCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(V1NamespaceCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (V1NamespaceCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public V1NamespaceStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public V1NamespaceStatusFluent.ConditionsNested<A> addNewConditionLike(V1NamespaceCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public V1NamespaceStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1NamespaceCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public V1NamespaceStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public V1NamespaceStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public V1NamespaceStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public V1NamespaceStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1NamespaceConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.apply(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase=phase; return (A) this;
    }

    public Boolean hasPhase() {
        return this.phase != null;
    }

    public A withNewPhase(String arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuilder arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuffer arg1) {
        return (A)withPhase(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1NamespaceStatusFluentImpl that = (V1NamespaceStatusFluentImpl) o;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditions,  phase,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends V1NamespaceConditionFluentImpl<V1NamespaceStatusFluent.ConditionsNested<N>> implements V1NamespaceStatusFluent.ConditionsNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1NamespaceConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index,V1NamespaceCondition item) {
            this.index = index;
            this.builder = new V1NamespaceConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1NamespaceConditionBuilder(this);
        }

        public N and() {
             return (N) V1NamespaceStatusFluentImpl.this.setToConditions(index,builder.build());
        }

        public N endCondition() {
             return and();
        }
    }


}
