package io.kubernetes.client.openapi.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.kubernetes.client.custom.IntOrString;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1NetworkPolicyPortFluentImpl<A extends V1NetworkPolicyPortFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1NetworkPolicyPortFluent<A> {

    private IntOrString port;
    private String protocol;

    public V1NetworkPolicyPortFluentImpl() { 
    }


    public V1NetworkPolicyPortFluentImpl(V1NetworkPolicyPort instance) { 
        this.withPort(instance.getPort());

        this.withProtocol(instance.getProtocol());

    }


    public IntOrString getPort() {
        return this.port;
    }

    public A withPort(IntOrString port) {
        this.port=port; return (A) this;
    }

    public Boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(final int value) {
        return (A)withPort(new IntOrString(value));
    }

    public A withNewPort(final String value) {
        return (A)withPort(new IntOrString(value));
    }

    public String getProtocol() {
        return this.protocol;
    }

    public A withProtocol(String protocol) {
        this.protocol=protocol; return (A) this;
    }

    public Boolean hasProtocol() {
        return this.protocol != null;
    }

    public A withNewProtocol(String arg1) {
        return (A)withProtocol(new String(arg1));
    }

    public A withNewProtocol(StringBuilder arg1) {
        return (A)withProtocol(new String(arg1));
    }

    public A withNewProtocol(StringBuffer arg1) {
        return (A)withProtocol(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1NetworkPolicyPortFluentImpl that = (V1NetworkPolicyPortFluentImpl) o;
        if (port != null ? !port.equals(that.port) :that.port != null) return false;
        if (protocol != null ? !protocol.equals(that.protocol) :that.protocol != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(port,  protocol,  super.hashCode());
    }

}
