package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1NodeSelectorTermBuilder extends V1NodeSelectorTermFluentImpl<V1NodeSelectorTermBuilder> implements VisitableBuilder<V1NodeSelectorTerm,V1NodeSelectorTermBuilder> {

    V1NodeSelectorTermFluent<?> fluent;
    Boolean validationEnabled;

    public V1NodeSelectorTermBuilder() { 
        this(true);
    }


    public V1NodeSelectorTermBuilder(Boolean validationEnabled) { 
        this(new V1NodeSelectorTerm(), validationEnabled);
    }


    public V1NodeSelectorTermBuilder(V1NodeSelectorTermFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1NodeSelectorTermBuilder(V1NodeSelectorTermFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1NodeSelectorTerm(), validationEnabled);
    }


    public V1NodeSelectorTermBuilder(V1NodeSelectorTermFluent<?> fluent,V1NodeSelectorTerm instance) { 
        this(fluent, instance, true);
    }


    public V1NodeSelectorTermBuilder(V1NodeSelectorTermFluent<?> fluent,V1NodeSelectorTerm instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withMatchExpressions(instance.getMatchExpressions());

        fluent.withMatchFields(instance.getMatchFields());

        this.validationEnabled = validationEnabled; 
    }


    public V1NodeSelectorTermBuilder(V1NodeSelectorTerm instance) { 
        this(instance,true);
    }


    public V1NodeSelectorTermBuilder(V1NodeSelectorTerm instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withMatchExpressions(instance.getMatchExpressions());

        this.withMatchFields(instance.getMatchFields());

        this.validationEnabled = validationEnabled; 
    }


    public V1NodeSelectorTerm build() {
        V1NodeSelectorTerm buildable = new V1NodeSelectorTerm();
        buildable.setMatchExpressions(fluent.getMatchExpressions());
        buildable.setMatchFields(fluent.getMatchFields());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1NodeSelectorTermBuilder that = (V1NodeSelectorTermBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
