package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1PersistentVolumeClaimStatusBuilder extends V1PersistentVolumeClaimStatusFluentImpl<V1PersistentVolumeClaimStatusBuilder> implements VisitableBuilder<V1PersistentVolumeClaimStatus,V1PersistentVolumeClaimStatusBuilder> {

    V1PersistentVolumeClaimStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1PersistentVolumeClaimStatusBuilder() { 
        this(true);
    }


    public V1PersistentVolumeClaimStatusBuilder(Boolean validationEnabled) { 
        this(new V1PersistentVolumeClaimStatus(), validationEnabled);
    }


    public V1PersistentVolumeClaimStatusBuilder(V1PersistentVolumeClaimStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1PersistentVolumeClaimStatusBuilder(V1PersistentVolumeClaimStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1PersistentVolumeClaimStatus(), validationEnabled);
    }


    public V1PersistentVolumeClaimStatusBuilder(V1PersistentVolumeClaimStatusFluent<?> fluent,V1PersistentVolumeClaimStatus instance) { 
        this(fluent, instance, true);
    }


    public V1PersistentVolumeClaimStatusBuilder(V1PersistentVolumeClaimStatusFluent<?> fluent,V1PersistentVolumeClaimStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withAccessModes(instance.getAccessModes());

        fluent.withCapacity(instance.getCapacity());

        fluent.withConditions(instance.getConditions());

        fluent.withPhase(instance.getPhase());

        this.validationEnabled = validationEnabled; 
    }


    public V1PersistentVolumeClaimStatusBuilder(V1PersistentVolumeClaimStatus instance) { 
        this(instance,true);
    }


    public V1PersistentVolumeClaimStatusBuilder(V1PersistentVolumeClaimStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withAccessModes(instance.getAccessModes());

        this.withCapacity(instance.getCapacity());

        this.withConditions(instance.getConditions());

        this.withPhase(instance.getPhase());

        this.validationEnabled = validationEnabled; 
    }


    public V1PersistentVolumeClaimStatus build() {
        V1PersistentVolumeClaimStatus buildable = new V1PersistentVolumeClaimStatus();
        buildable.setAccessModes(fluent.getAccessModes());
        buildable.setCapacity(fluent.getCapacity());
        buildable.setConditions(fluent.getConditions());
        buildable.setPhase(fluent.getPhase());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1PersistentVolumeClaimStatusBuilder that = (V1PersistentVolumeClaimStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
