package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ReplicaSetConditionBuilder extends V1ReplicaSetConditionFluentImpl<V1ReplicaSetConditionBuilder> implements VisitableBuilder<V1ReplicaSetCondition,V1ReplicaSetConditionBuilder> {

    V1ReplicaSetConditionFluent<?> fluent;
    Boolean validationEnabled;

    public V1ReplicaSetConditionBuilder() { 
        this(true);
    }


    public V1ReplicaSetConditionBuilder(Boolean validationEnabled) { 
        this(new V1ReplicaSetCondition(), validationEnabled);
    }


    public V1ReplicaSetConditionBuilder(V1ReplicaSetConditionFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1ReplicaSetConditionBuilder(V1ReplicaSetConditionFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1ReplicaSetCondition(), validationEnabled);
    }


    public V1ReplicaSetConditionBuilder(V1ReplicaSetConditionFluent<?> fluent,V1ReplicaSetCondition instance) { 
        this(fluent, instance, true);
    }


    public V1ReplicaSetConditionBuilder(V1ReplicaSetConditionFluent<?> fluent,V1ReplicaSetCondition instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withLastTransitionTime(instance.getLastTransitionTime());

        fluent.withMessage(instance.getMessage());

        fluent.withReason(instance.getReason());

        fluent.withStatus(instance.getStatus());

        fluent.withType(instance.getType());

        this.validationEnabled = validationEnabled; 
    }


    public V1ReplicaSetConditionBuilder(V1ReplicaSetCondition instance) { 
        this(instance,true);
    }


    public V1ReplicaSetConditionBuilder(V1ReplicaSetCondition instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withLastTransitionTime(instance.getLastTransitionTime());

        this.withMessage(instance.getMessage());

        this.withReason(instance.getReason());

        this.withStatus(instance.getStatus());

        this.withType(instance.getType());

        this.validationEnabled = validationEnabled; 
    }


    public V1ReplicaSetCondition build() {
        V1ReplicaSetCondition buildable = new V1ReplicaSetCondition();
        buildable.setLastTransitionTime(fluent.getLastTransitionTime());
        buildable.setMessage(fluent.getMessage());
        buildable.setReason(fluent.getReason());
        buildable.setStatus(fluent.getStatus());
        buildable.setType(fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1ReplicaSetConditionBuilder that = (V1ReplicaSetConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
