package io.kubernetes.client.openapi.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.custom.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1ResourceFieldSelectorFluentImpl<A extends V1ResourceFieldSelectorFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1ResourceFieldSelectorFluent<A> {

    private String containerName;
    private Quantity divisor;
    private String resource;

    public V1ResourceFieldSelectorFluentImpl() { 
    }


    public V1ResourceFieldSelectorFluentImpl(V1ResourceFieldSelector instance) { 
        this.withContainerName(instance.getContainerName());

        this.withDivisor(instance.getDivisor());

        this.withResource(instance.getResource());

    }


    public String getContainerName() {
        return this.containerName;
    }

    public A withContainerName(String containerName) {
        this.containerName=containerName; return (A) this;
    }

    public Boolean hasContainerName() {
        return this.containerName != null;
    }

    public A withNewContainerName(String arg1) {
        return (A)withContainerName(new String(arg1));
    }

    public A withNewContainerName(StringBuilder arg1) {
        return (A)withContainerName(new String(arg1));
    }

    public A withNewContainerName(StringBuffer arg1) {
        return (A)withContainerName(new String(arg1));
    }

    public Quantity getDivisor() {
        return this.divisor;
    }

    public A withDivisor(Quantity divisor) {
        this.divisor=divisor; return (A) this;
    }

    public Boolean hasDivisor() {
        return this.divisor != null;
    }

    public A withNewDivisor(final String value) {
        return (A)withDivisor(new Quantity(value));
    }

    public String getResource() {
        return this.resource;
    }

    public A withResource(String resource) {
        this.resource=resource; return (A) this;
    }

    public Boolean hasResource() {
        return this.resource != null;
    }

    public A withNewResource(String arg1) {
        return (A)withResource(new String(arg1));
    }

    public A withNewResource(StringBuilder arg1) {
        return (A)withResource(new String(arg1));
    }

    public A withNewResource(StringBuffer arg1) {
        return (A)withResource(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1ResourceFieldSelectorFluentImpl that = (V1ResourceFieldSelectorFluentImpl) o;
        if (containerName != null ? !containerName.equals(that.containerName) :that.containerName != null) return false;
        if (divisor != null ? !divisor.equals(that.divisor) :that.divisor != null) return false;
        if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(containerName,  divisor,  resource,  super.hashCode());
    }

}
