package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1StatefulSetStatusFluent<A extends V1StatefulSetStatusFluent<A>> extends Fluent<A> {


    public Integer getCollisionCount();
    public A withCollisionCount(Integer collisionCount);
    public Boolean hasCollisionCount();
    public A addToConditions(int index,V1StatefulSetCondition item);
    public A setToConditions(int index,V1StatefulSetCondition item);
    public A addToConditions(V1StatefulSetCondition... items);
    public A addAllToConditions(Collection<V1StatefulSetCondition> items);
    public A removeFromConditions(V1StatefulSetCondition... items);
    public A removeAllFromConditions(Collection<V1StatefulSetCondition> items);
    public A removeMatchingFromConditions(io.kubernetes.client.fluent.Predicate<V1StatefulSetConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1StatefulSetCondition> getConditions();
    public List<V1StatefulSetCondition> buildConditions();
    public V1StatefulSetCondition buildCondition(int index);
    public V1StatefulSetCondition buildFirstCondition();
    public V1StatefulSetCondition buildLastCondition();
    public V1StatefulSetCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1StatefulSetConditionBuilder> predicate);
    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<V1StatefulSetConditionBuilder> predicate);
    public A withConditions(List<V1StatefulSetCondition> conditions);
    public A withConditions(V1StatefulSetCondition... conditions);
    public Boolean hasConditions();
    public V1StatefulSetStatusFluent.ConditionsNested<A> addNewCondition();
    public V1StatefulSetStatusFluent.ConditionsNested<A> addNewConditionLike(V1StatefulSetCondition item);
    public V1StatefulSetStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1StatefulSetCondition item);
    public V1StatefulSetStatusFluent.ConditionsNested<A> editCondition(int index);
    public V1StatefulSetStatusFluent.ConditionsNested<A> editFirstCondition();
    public V1StatefulSetStatusFluent.ConditionsNested<A> editLastCondition();
    public V1StatefulSetStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1StatefulSetConditionBuilder> predicate);
    public Integer getCurrentReplicas();
    public A withCurrentReplicas(Integer currentReplicas);
    public Boolean hasCurrentReplicas();
    public String getCurrentRevision();
    public A withCurrentRevision(String currentRevision);
    public Boolean hasCurrentRevision();
    public A withNewCurrentRevision(String arg1);
    public A withNewCurrentRevision(StringBuilder arg1);
    public A withNewCurrentRevision(StringBuffer arg1);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public Integer getReadyReplicas();
    public A withReadyReplicas(Integer readyReplicas);
    public Boolean hasReadyReplicas();
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public String getUpdateRevision();
    public A withUpdateRevision(String updateRevision);
    public Boolean hasUpdateRevision();
    public A withNewUpdateRevision(String arg1);
    public A withNewUpdateRevision(StringBuilder arg1);
    public A withNewUpdateRevision(StringBuffer arg1);
    public Integer getUpdatedReplicas();
    public A withUpdatedReplicas(Integer updatedReplicas);
    public Boolean hasUpdatedReplicas();
    public interface ConditionsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1StatefulSetConditionFluent<V1StatefulSetStatusFluent.ConditionsNested<N>> {

        public N and();
        public N endCondition();    }


}
