package io.kubernetes.client.openapi.models;

import java.lang.Integer;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1QueuingConfigurationFluentImpl<A extends V1alpha1QueuingConfigurationFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1alpha1QueuingConfigurationFluent<A> {

    private Integer handSize;
    private Integer queueLengthLimit;
    private Integer queues;

    public V1alpha1QueuingConfigurationFluentImpl() { 
    }


    public V1alpha1QueuingConfigurationFluentImpl(V1alpha1QueuingConfiguration instance) { 
        this.withHandSize(instance.getHandSize());

        this.withQueueLengthLimit(instance.getQueueLengthLimit());

        this.withQueues(instance.getQueues());

    }


    public Integer getHandSize() {
        return this.handSize;
    }

    public A withHandSize(Integer handSize) {
        this.handSize=handSize; return (A) this;
    }

    public Boolean hasHandSize() {
        return this.handSize != null;
    }

    public Integer getQueueLengthLimit() {
        return this.queueLengthLimit;
    }

    public A withQueueLengthLimit(Integer queueLengthLimit) {
        this.queueLengthLimit=queueLengthLimit; return (A) this;
    }

    public Boolean hasQueueLengthLimit() {
        return this.queueLengthLimit != null;
    }

    public Integer getQueues() {
        return this.queues;
    }

    public A withQueues(Integer queues) {
        this.queues=queues; return (A) this;
    }

    public Boolean hasQueues() {
        return this.queues != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1alpha1QueuingConfigurationFluentImpl that = (V1alpha1QueuingConfigurationFluentImpl) o;
        if (handSize != null ? !handSize.equals(that.handSize) :that.handSize != null) return false;
        if (queueLengthLimit != null ? !queueLengthLimit.equals(that.queueLengthLimit) :that.queueLengthLimit != null) return false;
        if (queues != null ? !queues.equals(that.queues) :that.queues != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(handSize,  queueLengthLimit,  queues,  super.hashCode());
    }

}
