/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The pod this Toleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.")
public class V1Toleration {
    public static final String SERIALIZED_NAME_EFFECT = "effect";
    @SerializedName(value="effect")
    private EffectEnum effect;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_OPERATOR = "operator";
    @SerializedName(value="operator")
    private OperatorEnum operator;
    public static final String SERIALIZED_NAME_TOLERATION_SECONDS = "tolerationSeconds";
    @SerializedName(value="tolerationSeconds")
    private Long tolerationSeconds;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private String value;

    public V1Toleration effect(EffectEnum effect) {
        this.effect = effect;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.  Possible enum values:  - `\"NoExecute\"` Evict any already-running pods that do not tolerate the taint. Currently enforced by NodeController.  - `\"NoSchedule\"` Do not allow new pods to schedule onto the node unless they tolerate the taint, but allow all pods submitted to Kubelet without going through the scheduler to start, and allow all already-running pods to continue running. Enforced by the scheduler.  - `\"PreferNoSchedule\"` Like TaintEffectNoSchedule, but the scheduler tries not to schedule new pods onto the node, rather than prohibiting new pods from scheduling onto the node entirely. Enforced by the scheduler.")
    public EffectEnum getEffect() {
        return this.effect;
    }

    public void setEffect(EffectEnum effect) {
        this.effect = effect;
    }

    public V1Toleration key(String key) {
        this.key = key;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public V1Toleration operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.  Possible enum values:  - `\"Equal\"`  - `\"Exists\"`")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public V1Toleration tolerationSeconds(Long tolerationSeconds) {
        this.tolerationSeconds = tolerationSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.")
    public Long getTolerationSeconds() {
        return this.tolerationSeconds;
    }

    public void setTolerationSeconds(Long tolerationSeconds) {
        this.tolerationSeconds = tolerationSeconds;
    }

    public V1Toleration value(String value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Toleration v1Toleration = (V1Toleration)o;
        return Objects.equals((Object)this.effect, (Object)v1Toleration.effect) && Objects.equals(this.key, v1Toleration.key) && Objects.equals((Object)this.operator, (Object)v1Toleration.operator) && Objects.equals(this.tolerationSeconds, v1Toleration.tolerationSeconds) && Objects.equals(this.value, v1Toleration.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.effect, this.key, this.operator, this.tolerationSeconds, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Toleration {\n");
        sb.append("    effect: ").append(this.toIndentedString((Object)this.effect)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    tolerationSeconds: ").append(this.toIndentedString(this.tolerationSeconds)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OperatorEnum {
        EQUAL("Equal"),
        EXISTS("Exists");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OperatorEnum fromValue(String value) {
            for (OperatorEnum b : OperatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<OperatorEnum> {
            public void write(JsonWriter jsonWriter, OperatorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OperatorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OperatorEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EffectEnum {
        NOEXECUTE("NoExecute"),
        NOSCHEDULE("NoSchedule"),
        PREFERNOSCHEDULE("PreferNoSchedule");

        private String value;

        private EffectEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EffectEnum fromValue(String value) {
            for (EffectEnum b : EffectEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<EffectEnum> {
            public void write(JsonWriter jsonWriter, EffectEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EffectEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EffectEnum.fromValue(value);
            }
        }
    }
}

