/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="NonResourcePolicyRule is a predicate that matches non-resource requests according to their verb and the target non-resource URL. A NonResourcePolicyRule matches a request if and only if both (a) at least one member of verbs matches the request and (b) at least one member of nonResourceURLs matches the request.")
public class V1beta1NonResourcePolicyRule {
    public static final String SERIALIZED_NAME_NON_RESOURCE_U_R_LS = "nonResourceURLs";
    @SerializedName(value="nonResourceURLs")
    private List<String> nonResourceURLs = new ArrayList<String>();
    public static final String SERIALIZED_NAME_VERBS = "verbs";
    @SerializedName(value="verbs")
    private List<String> verbs = new ArrayList<String>();

    public V1beta1NonResourcePolicyRule nonResourceURLs(List<String> nonResourceURLs) {
        this.nonResourceURLs = nonResourceURLs;
        return this;
    }

    public V1beta1NonResourcePolicyRule addNonResourceURLsItem(String nonResourceURLsItem) {
        this.nonResourceURLs.add(nonResourceURLsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="`nonResourceURLs` is a set of url prefixes that a user should have access to and may not be empty. For example:   - \"/healthz\" is legal   - \"/hea*\" is illegal   - \"/hea\" is legal but matches nothing   - \"/hea/_*\" also matches nothing   - \"/healthz/_*\" matches all per-component health checks. \"*\" matches all non-resource urls. if it is present, it must be the only entry. Required.")
    public List<String> getNonResourceURLs() {
        return this.nonResourceURLs;
    }

    public void setNonResourceURLs(List<String> nonResourceURLs) {
        this.nonResourceURLs = nonResourceURLs;
    }

    public V1beta1NonResourcePolicyRule verbs(List<String> verbs) {
        this.verbs = verbs;
        return this;
    }

    public V1beta1NonResourcePolicyRule addVerbsItem(String verbsItem) {
        this.verbs.add(verbsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="`verbs` is a list of matching verbs and may not be empty. \"*\" matches all verbs. If it is present, it must be the only entry. Required.")
    public List<String> getVerbs() {
        return this.verbs;
    }

    public void setVerbs(List<String> verbs) {
        this.verbs = verbs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1NonResourcePolicyRule v1beta1NonResourcePolicyRule = (V1beta1NonResourcePolicyRule)o;
        return Objects.equals(this.nonResourceURLs, v1beta1NonResourcePolicyRule.nonResourceURLs) && Objects.equals(this.verbs, v1beta1NonResourcePolicyRule.verbs);
    }

    public int hashCode() {
        return Objects.hash(this.nonResourceURLs, this.verbs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1NonResourcePolicyRule {\n");
        sb.append("    nonResourceURLs: ").append(this.toIndentedString(this.nonResourceURLs)).append("\n");
        sb.append("    verbs: ").append(this.toIndentedString(this.verbs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

