/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V2CrossVersionObjectReference;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerBehavior;
import io.kubernetes.client.openapi.models.V2MetricSpec;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.")
public class V2HorizontalPodAutoscalerSpec {
    public static final String SERIALIZED_NAME_BEHAVIOR = "behavior";
    @SerializedName(value="behavior")
    private V2HorizontalPodAutoscalerBehavior behavior;
    public static final String SERIALIZED_NAME_MAX_REPLICAS = "maxReplicas";
    @SerializedName(value="maxReplicas")
    private Integer maxReplicas;
    public static final String SERIALIZED_NAME_METRICS = "metrics";
    @SerializedName(value="metrics")
    private List<V2MetricSpec> metrics = null;
    public static final String SERIALIZED_NAME_MIN_REPLICAS = "minReplicas";
    @SerializedName(value="minReplicas")
    private Integer minReplicas;
    public static final String SERIALIZED_NAME_SCALE_TARGET_REF = "scaleTargetRef";
    @SerializedName(value="scaleTargetRef")
    private V2CrossVersionObjectReference scaleTargetRef;

    public V2HorizontalPodAutoscalerSpec behavior(V2HorizontalPodAutoscalerBehavior behavior) {
        this.behavior = behavior;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V2HorizontalPodAutoscalerBehavior getBehavior() {
        return this.behavior;
    }

    public void setBehavior(V2HorizontalPodAutoscalerBehavior behavior) {
        this.behavior = behavior;
    }

    public V2HorizontalPodAutoscalerSpec maxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return this;
    }

    @ApiModelProperty(required=true, value="maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.")
    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public void setMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
    }

    public V2HorizontalPodAutoscalerSpec metrics(List<V2MetricSpec> metrics) {
        this.metrics = metrics;
        return this;
    }

    public V2HorizontalPodAutoscalerSpec addMetricsItem(V2MetricSpec metricsItem) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<V2MetricSpec>();
        }
        this.metrics.add(metricsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.")
    public List<V2MetricSpec> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<V2MetricSpec> metrics) {
        this.metrics = metrics;
    }

    public V2HorizontalPodAutoscalerSpec minReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.")
    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public void setMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
    }

    public V2HorizontalPodAutoscalerSpec scaleTargetRef(V2CrossVersionObjectReference scaleTargetRef) {
        this.scaleTargetRef = scaleTargetRef;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V2CrossVersionObjectReference getScaleTargetRef() {
        return this.scaleTargetRef;
    }

    public void setScaleTargetRef(V2CrossVersionObjectReference scaleTargetRef) {
        this.scaleTargetRef = scaleTargetRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2HorizontalPodAutoscalerSpec v2HorizontalPodAutoscalerSpec = (V2HorizontalPodAutoscalerSpec)o;
        return Objects.equals(this.behavior, v2HorizontalPodAutoscalerSpec.behavior) && Objects.equals(this.maxReplicas, v2HorizontalPodAutoscalerSpec.maxReplicas) && Objects.equals(this.metrics, v2HorizontalPodAutoscalerSpec.metrics) && Objects.equals(this.minReplicas, v2HorizontalPodAutoscalerSpec.minReplicas) && Objects.equals(this.scaleTargetRef, v2HorizontalPodAutoscalerSpec.scaleTargetRef);
    }

    public int hashCode() {
        return Objects.hash(this.behavior, this.maxReplicas, this.metrics, this.minReplicas, this.scaleTargetRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2HorizontalPodAutoscalerSpec {\n");
        sb.append("    behavior: ").append(this.toIndentedString(this.behavior)).append("\n");
        sb.append("    maxReplicas: ").append(this.toIndentedString(this.maxReplicas)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    minReplicas: ").append(this.toIndentedString(this.minReplicas)).append("\n");
        sb.append("    scaleTargetRef: ").append(this.toIndentedString(this.scaleTargetRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

