/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.custom;

import io.kubernetes.client.custom.BaseExponent;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.custom.QuantityFormatException;
import java.util.HashMap;
import java.util.Map;

public class SuffixFormatter {
    private static final Map<String, BaseExponent> suffixToBinary = new HashMap<String, BaseExponent>(){
        {
            this.put("", new BaseExponent(2, 0, Quantity.Format.BINARY_SI));
            this.put("Ki", new BaseExponent(2, 10, Quantity.Format.BINARY_SI));
            this.put("Mi", new BaseExponent(2, 20, Quantity.Format.BINARY_SI));
            this.put("Gi", new BaseExponent(2, 30, Quantity.Format.BINARY_SI));
            this.put("Ti", new BaseExponent(2, 40, Quantity.Format.BINARY_SI));
            this.put("Pi", new BaseExponent(2, 50, Quantity.Format.BINARY_SI));
            this.put("Ei", new BaseExponent(2, 60, Quantity.Format.BINARY_SI));
        }
    };
    private static final Map<String, BaseExponent> suffixToDecimal = new HashMap<String, BaseExponent>(){
        {
            this.put("n", new BaseExponent(10, -9, Quantity.Format.DECIMAL_SI));
            this.put("u", new BaseExponent(10, -6, Quantity.Format.DECIMAL_SI));
            this.put("m", new BaseExponent(10, -3, Quantity.Format.DECIMAL_SI));
            this.put("", new BaseExponent(10, 0, Quantity.Format.DECIMAL_SI));
            this.put("k", new BaseExponent(10, 3, Quantity.Format.DECIMAL_SI));
            this.put("M", new BaseExponent(10, 6, Quantity.Format.DECIMAL_SI));
            this.put("G", new BaseExponent(10, 9, Quantity.Format.DECIMAL_SI));
            this.put("T", new BaseExponent(10, 12, Quantity.Format.DECIMAL_SI));
            this.put("P", new BaseExponent(10, 15, Quantity.Format.DECIMAL_SI));
            this.put("E", new BaseExponent(10, 18, Quantity.Format.DECIMAL_SI));
        }
    };
    private static final Map<BaseExponent, String> decimalToSuffix = new HashMap<BaseExponent, String>(){
        {
            for (Map.Entry<String, BaseExponent> entry : suffixToDecimal.entrySet()) {
                this.put(entry.getValue(), entry.getKey());
            }
        }
    };
    private static final Map<BaseExponent, String> binaryToSuffix = new HashMap<BaseExponent, String>(){
        {
            for (Map.Entry<String, BaseExponent> entry : suffixToBinary.entrySet()) {
                this.put(entry.getValue(), entry.getKey());
            }
        }
    };

    public BaseExponent parse(String suffix) {
        BaseExponent decimalSuffix = suffixToDecimal.get(suffix);
        if (decimalSuffix != null) {
            return decimalSuffix;
        }
        BaseExponent binarySuffix = suffixToBinary.get(suffix);
        if (binarySuffix != null) {
            return binarySuffix;
        }
        if (suffix.length() > 0 && (suffix.charAt(0) == 'E' || suffix.charAt(0) == 'e')) {
            return this.extractDecimalExponent(suffix);
        }
        throw new QuantityFormatException("Could not parse suffix");
    }

    private BaseExponent extractDecimalExponent(String suffix) {
        try {
            int exponent = Integer.parseInt(suffix.substring(1));
            return new BaseExponent(10, exponent, Quantity.Format.DECIMAL_EXPONENT);
        }
        catch (NumberFormatException e) {
            throw new QuantityFormatException("Can't parse decimal exponent from " + suffix.substring(1));
        }
    }

    public String format(Quantity.Format format, int exponent) {
        switch (format) {
            case DECIMAL_SI: {
                return this.getDecimalSiSuffix(exponent);
            }
            case BINARY_SI: {
                return this.getBinarySiSuffix(exponent);
            }
            case DECIMAL_EXPONENT: {
                return exponent == 0 ? "" : "e" + exponent;
            }
        }
        throw new IllegalStateException("Can't format " + format + " with exponent " + exponent);
    }

    private String getBinarySiSuffix(int exponent) {
        String suffix = binaryToSuffix.get(new BaseExponent(2, exponent, Quantity.Format.BINARY_SI));
        if (suffix == null) {
            throw new IllegalArgumentException("No suffix for exponent" + exponent);
        }
        return suffix;
    }

    private String getDecimalSiSuffix(int exponent) {
        String suffix = decimalToSuffix.get(new BaseExponent(10, exponent, Quantity.Format.DECIMAL_SI));
        if (suffix == null) {
            throw new IllegalArgumentException("No suffix for exponent" + exponent);
        }
        return suffix;
    }
}

