/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1PodAffinityTerm;
import io.kubernetes.client.openapi.models.V1WeightedPodAffinityTerm;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="Pod affinity is a group of inter pod affinity scheduling rules.")
public class V1PodAffinity {
    public static final String SERIALIZED_NAME_PREFERRED_DURING_SCHEDULING_IGNORED_DURING_EXECUTION = "preferredDuringSchedulingIgnoredDuringExecution";
    @SerializedName(value="preferredDuringSchedulingIgnoredDuringExecution")
    private List<V1WeightedPodAffinityTerm> preferredDuringSchedulingIgnoredDuringExecution = new ArrayList<V1WeightedPodAffinityTerm>();
    public static final String SERIALIZED_NAME_REQUIRED_DURING_SCHEDULING_IGNORED_DURING_EXECUTION = "requiredDuringSchedulingIgnoredDuringExecution";
    @SerializedName(value="requiredDuringSchedulingIgnoredDuringExecution")
    private List<V1PodAffinityTerm> requiredDuringSchedulingIgnoredDuringExecution = new ArrayList<V1PodAffinityTerm>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1PodAffinity preferredDuringSchedulingIgnoredDuringExecution(List<V1WeightedPodAffinityTerm> preferredDuringSchedulingIgnoredDuringExecution) {
        this.preferredDuringSchedulingIgnoredDuringExecution = preferredDuringSchedulingIgnoredDuringExecution;
        return this;
    }

    public V1PodAffinity addPreferredDuringSchedulingIgnoredDuringExecutionItem(V1WeightedPodAffinityTerm preferredDuringSchedulingIgnoredDuringExecutionItem) {
        if (this.preferredDuringSchedulingIgnoredDuringExecution == null) {
            this.preferredDuringSchedulingIgnoredDuringExecution = new ArrayList<V1WeightedPodAffinityTerm>();
        }
        this.preferredDuringSchedulingIgnoredDuringExecution.add(preferredDuringSchedulingIgnoredDuringExecutionItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding \"weight\" to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.")
    public List<V1WeightedPodAffinityTerm> getPreferredDuringSchedulingIgnoredDuringExecution() {
        return this.preferredDuringSchedulingIgnoredDuringExecution;
    }

    public void setPreferredDuringSchedulingIgnoredDuringExecution(List<V1WeightedPodAffinityTerm> preferredDuringSchedulingIgnoredDuringExecution) {
        this.preferredDuringSchedulingIgnoredDuringExecution = preferredDuringSchedulingIgnoredDuringExecution;
    }

    public V1PodAffinity requiredDuringSchedulingIgnoredDuringExecution(List<V1PodAffinityTerm> requiredDuringSchedulingIgnoredDuringExecution) {
        this.requiredDuringSchedulingIgnoredDuringExecution = requiredDuringSchedulingIgnoredDuringExecution;
        return this;
    }

    public V1PodAffinity addRequiredDuringSchedulingIgnoredDuringExecutionItem(V1PodAffinityTerm requiredDuringSchedulingIgnoredDuringExecutionItem) {
        if (this.requiredDuringSchedulingIgnoredDuringExecution == null) {
            this.requiredDuringSchedulingIgnoredDuringExecution = new ArrayList<V1PodAffinityTerm>();
        }
        this.requiredDuringSchedulingIgnoredDuringExecution.add(requiredDuringSchedulingIgnoredDuringExecutionItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.")
    public List<V1PodAffinityTerm> getRequiredDuringSchedulingIgnoredDuringExecution() {
        return this.requiredDuringSchedulingIgnoredDuringExecution;
    }

    public void setRequiredDuringSchedulingIgnoredDuringExecution(List<V1PodAffinityTerm> requiredDuringSchedulingIgnoredDuringExecution) {
        this.requiredDuringSchedulingIgnoredDuringExecution = requiredDuringSchedulingIgnoredDuringExecution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodAffinity v1PodAffinity = (V1PodAffinity)o;
        return Objects.equals(this.preferredDuringSchedulingIgnoredDuringExecution, v1PodAffinity.preferredDuringSchedulingIgnoredDuringExecution) && Objects.equals(this.requiredDuringSchedulingIgnoredDuringExecution, v1PodAffinity.requiredDuringSchedulingIgnoredDuringExecution);
    }

    public int hashCode() {
        return Objects.hash(this.preferredDuringSchedulingIgnoredDuringExecution, this.requiredDuringSchedulingIgnoredDuringExecution);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodAffinity {\n");
        sb.append("    preferredDuringSchedulingIgnoredDuringExecution: ").append(this.toIndentedString(this.preferredDuringSchedulingIgnoredDuringExecution)).append("\n");
        sb.append("    requiredDuringSchedulingIgnoredDuringExecution: ").append(this.toIndentedString(this.requiredDuringSchedulingIgnoredDuringExecution)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayrequiredDuringSchedulingIgnoredDuringExecution;
        int i;
        JsonArray jsonArraypreferredDuringSchedulingIgnoredDuringExecution;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1PodAffinity is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1PodAffinity` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_PREFERRED_DURING_SCHEDULING_IGNORED_DURING_EXECUTION) != null && !jsonObj.get(SERIALIZED_NAME_PREFERRED_DURING_SCHEDULING_IGNORED_DURING_EXECUTION).isJsonNull() && (jsonArraypreferredDuringSchedulingIgnoredDuringExecution = jsonObj.getAsJsonArray(SERIALIZED_NAME_PREFERRED_DURING_SCHEDULING_IGNORED_DURING_EXECUTION)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PREFERRED_DURING_SCHEDULING_IGNORED_DURING_EXECUTION).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `preferredDuringSchedulingIgnoredDuringExecution` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PREFERRED_DURING_SCHEDULING_IGNORED_DURING_EXECUTION).toString()));
            }
            for (i = 0; i < jsonArraypreferredDuringSchedulingIgnoredDuringExecution.size(); ++i) {
                V1WeightedPodAffinityTerm.validateJsonElement(jsonArraypreferredDuringSchedulingIgnoredDuringExecution.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUIRED_DURING_SCHEDULING_IGNORED_DURING_EXECUTION) != null && !jsonObj.get(SERIALIZED_NAME_REQUIRED_DURING_SCHEDULING_IGNORED_DURING_EXECUTION).isJsonNull() && (jsonArrayrequiredDuringSchedulingIgnoredDuringExecution = jsonObj.getAsJsonArray(SERIALIZED_NAME_REQUIRED_DURING_SCHEDULING_IGNORED_DURING_EXECUTION)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_REQUIRED_DURING_SCHEDULING_IGNORED_DURING_EXECUTION).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `requiredDuringSchedulingIgnoredDuringExecution` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUIRED_DURING_SCHEDULING_IGNORED_DURING_EXECUTION).toString()));
            }
            for (i = 0; i < jsonArrayrequiredDuringSchedulingIgnoredDuringExecution.size(); ++i) {
                V1PodAffinityTerm.validateJsonElement(jsonArrayrequiredDuringSchedulingIgnoredDuringExecution.get(i));
            }
        }
    }

    public static V1PodAffinity fromJson(String jsonString) throws IOException {
        return (V1PodAffinity)JSON.getGson().fromJson(jsonString, V1PodAffinity.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PREFERRED_DURING_SCHEDULING_IGNORED_DURING_EXECUTION);
        openapiFields.add(SERIALIZED_NAME_REQUIRED_DURING_SCHEDULING_IGNORED_DURING_EXECUTION);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1PodAffinity.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1PodAffinity.class));
            return new TypeAdapter<V1PodAffinity>(){

                public void write(JsonWriter out, V1PodAffinity value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1PodAffinity read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1PodAffinity.validateJsonElement(jsonElement);
                    return (V1PodAffinity)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

