/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ResourceFieldSelector represents container resources (cpu, memory) and their output format")
public class V1ResourceFieldSelector {
    public static final String SERIALIZED_NAME_CONTAINER_NAME = "containerName";
    @SerializedName(value="containerName")
    private String containerName;
    public static final String SERIALIZED_NAME_DIVISOR = "divisor";
    @SerializedName(value="divisor")
    private Quantity divisor;
    public static final String SERIALIZED_NAME_RESOURCE = "resource";
    @SerializedName(value="resource")
    private String resource;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ResourceFieldSelector containerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container name: required for volumes, optional for env vars")
    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public V1ResourceFieldSelector divisor(Quantity divisor) {
        this.divisor = divisor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Quantity is a fixed-point representation of a number. It provides convenient marshaling/unmarshaling in JSON and YAML, in addition to String() and AsInt64() accessors.  The serialization format is:  ``` <quantity>        ::= <signedNumber><suffix>   (Note that <suffix> may be empty, from the \"\" case in <decimalSI>.)  <digit>           ::= 0 | 1 | ... | 9 <digits>          ::= <digit> | <digit><digits> <number>          ::= <digits> | <digits>.<digits> | <digits>. | .<digits> <sign>            ::= \"+\" | \"-\" <signedNumber>    ::= <number> | <sign><number> <suffix>          ::= <binarySI> | <decimalExponent> | <decimalSI> <binarySI>        ::= Ki | Mi | Gi | Ti | Pi | Ei   (International System of units; See: http://physics.nist.gov/cuu/Units/binary.html)  <decimalSI>       ::= m | \"\" | k | M | G | T | P | E   (Note that 1024 = 1Ki but 1000 = 1k; I didn't choose the capitalization.)  <decimalExponent> ::= \"e\" <signedNumber> | \"E\" <signedNumber> ```  No matter which of the three exponent forms is used, no quantity may represent a number greater than 2^63-1 in magnitude, nor may it have more than 3 decimal places. Numbers larger or more precise will be capped or rounded up. (E.g.: 0.1m will rounded up to 1m.) This may be extended in the future if we require larger or smaller quantities.  When a Quantity is parsed from a string, it will remember the type of suffix it had, and will use the same type again when it is serialized.  Before serializing, Quantity will be put in \"canonical form\". This means that Exponent/suffix will be adjusted up or down (with a corresponding increase or decrease in Mantissa) such that:  - No precision is lost - No fractional digits will be emitted - The exponent (or suffix) is as large as possible.  The sign will be omitted unless the number is negative.  Examples:  - 1.5 will be serialized as \"1500m\" - 1.5Gi will be serialized as \"1536Mi\"  Note that the quantity will NEVER be internally represented by a floating point number. That is the whole point of this exercise.  Non-canonical values will still parse as long as they are well formed, but will be re-emitted in their canonical form. (So always use canonical form, or don't diff.)  This format is intended to make it difficult to use these numbers without writing some sort of special handling code in the hopes that that will cause implementors to also use a fixed point implementation.")
    public Quantity getDivisor() {
        return this.divisor;
    }

    public void setDivisor(Quantity divisor) {
        this.divisor = divisor;
    }

    public V1ResourceFieldSelector resource(String resource) {
        this.resource = resource;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Required: resource to select")
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceFieldSelector v1ResourceFieldSelector = (V1ResourceFieldSelector)o;
        return Objects.equals(this.containerName, v1ResourceFieldSelector.containerName) && Objects.equals(this.divisor, v1ResourceFieldSelector.divisor) && Objects.equals(this.resource, v1ResourceFieldSelector.resource);
    }

    public int hashCode() {
        return Objects.hash(this.containerName, this.divisor, this.resource);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceFieldSelector {\n");
        sb.append("    containerName: ").append(this.toIndentedString(this.containerName)).append("\n");
        sb.append("    divisor: ").append(this.toIndentedString(this.divisor)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ResourceFieldSelector is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ResourceFieldSelector` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONTAINER_NAME) != null && !jsonObj.get(SERIALIZED_NAME_CONTAINER_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTAINER_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `containerName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINER_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DIVISOR) != null && !jsonObj.get(SERIALIZED_NAME_DIVISOR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DIVISOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `divisor` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DIVISOR).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_RESOURCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resource` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE).toString()));
        }
    }

    public static V1ResourceFieldSelector fromJson(String jsonString) throws IOException {
        return (V1ResourceFieldSelector)JSON.getGson().fromJson(jsonString, V1ResourceFieldSelector.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTAINER_NAME);
        openapiFields.add(SERIALIZED_NAME_DIVISOR);
        openapiFields.add(SERIALIZED_NAME_RESOURCE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_RESOURCE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ResourceFieldSelector.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ResourceFieldSelector.class));
            return new TypeAdapter<V1ResourceFieldSelector>(){

                public void write(JsonWriter out, V1ResourceFieldSelector value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ResourceFieldSelector read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ResourceFieldSelector.validateJsonElement(jsonElement);
                    return (V1ResourceFieldSelector)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

