/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ResourceHealth represents the health of a resource. It has the latest device health information. This is a part of KEP https://kep.k8s.io/4680 and historical health changes are planned to be added in future iterations of a KEP.")
public class V1ResourceHealth {
    public static final String SERIALIZED_NAME_HEALTH = "health";
    @SerializedName(value="health")
    private String health;
    public static final String SERIALIZED_NAME_RESOURCE_I_D = "resourceID";
    @SerializedName(value="resourceID")
    private String resourceID;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ResourceHealth health(String health) {
        this.health = health;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Health of the resource. can be one of:  - Healthy: operates as normal  - Unhealthy: reported unhealthy. We consider this a temporary health issue               since we do not have a mechanism today to distinguish               temporary and permanent issues.  - Unknown: The status cannot be determined.             For example, Device Plugin got unregistered and hasn't been re-registered since.  In future we may want to introduce the PermanentlyUnhealthy Status.")
    public String getHealth() {
        return this.health;
    }

    public void setHealth(String health) {
        this.health = health;
    }

    public V1ResourceHealth resourceID(String resourceID) {
        this.resourceID = resourceID;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="ResourceID is the unique identifier of the resource. See the ResourceID type for more information.")
    public String getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceHealth v1ResourceHealth = (V1ResourceHealth)o;
        return Objects.equals(this.health, v1ResourceHealth.health) && Objects.equals(this.resourceID, v1ResourceHealth.resourceID);
    }

    public int hashCode() {
        return Objects.hash(this.health, this.resourceID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceHealth {\n");
        sb.append("    health: ").append(this.toIndentedString(this.health)).append("\n");
        sb.append("    resourceID: ").append(this.toIndentedString(this.resourceID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ResourceHealth is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ResourceHealth` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_HEALTH) != null && !jsonObj.get(SERIALIZED_NAME_HEALTH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HEALTH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `health` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HEALTH).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_RESOURCE_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resourceID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_I_D).toString()));
        }
    }

    public static V1ResourceHealth fromJson(String jsonString) throws IOException {
        return (V1ResourceHealth)JSON.getGson().fromJson(jsonString, V1ResourceHealth.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_HEALTH);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_I_D);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_RESOURCE_I_D);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ResourceHealth.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ResourceHealth.class));
            return new TypeAdapter<V1ResourceHealth>(){

                public void write(JsonWriter out, V1ResourceHealth value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ResourceHealth read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ResourceHealth.validateJsonElement(jsonElement);
                    return (V1ResourceHealth)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

