/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1AttachedVolume;
import io.kubernetes.client.openapi.models.V1ContainerImage;
import io.kubernetes.client.openapi.models.V1NodeAddress;
import io.kubernetes.client.openapi.models.V1NodeCondition;
import io.kubernetes.client.openapi.models.V1NodeConfigStatus;
import io.kubernetes.client.openapi.models.V1NodeDaemonEndpoints;
import io.kubernetes.client.openapi.models.V1NodeFeatures;
import io.kubernetes.client.openapi.models.V1NodeRuntimeHandler;
import io.kubernetes.client.openapi.models.V1NodeSystemInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="NodeStatus is information about the current status of a node.")
public class V1NodeStatus {
    public static final String SERIALIZED_NAME_ADDRESSES = "addresses";
    @SerializedName(value="addresses")
    private List<V1NodeAddress> addresses = new ArrayList<V1NodeAddress>();
    public static final String SERIALIZED_NAME_ALLOCATABLE = "allocatable";
    @SerializedName(value="allocatable")
    private Map<String, Quantity> allocatable = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    private Map<String, Quantity> capacity = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1NodeCondition> conditions = new ArrayList<V1NodeCondition>();
    public static final String SERIALIZED_NAME_CONFIG = "config";
    @SerializedName(value="config")
    private V1NodeConfigStatus config;
    public static final String SERIALIZED_NAME_DAEMON_ENDPOINTS = "daemonEndpoints";
    @SerializedName(value="daemonEndpoints")
    private V1NodeDaemonEndpoints daemonEndpoints;
    public static final String SERIALIZED_NAME_FEATURES = "features";
    @SerializedName(value="features")
    private V1NodeFeatures features;
    public static final String SERIALIZED_NAME_IMAGES = "images";
    @SerializedName(value="images")
    private List<V1ContainerImage> images = new ArrayList<V1ContainerImage>();
    public static final String SERIALIZED_NAME_NODE_INFO = "nodeInfo";
    @SerializedName(value="nodeInfo")
    private V1NodeSystemInfo nodeInfo;
    public static final String SERIALIZED_NAME_PHASE = "phase";
    @SerializedName(value="phase")
    private String phase;
    public static final String SERIALIZED_NAME_RUNTIME_HANDLERS = "runtimeHandlers";
    @SerializedName(value="runtimeHandlers")
    private List<V1NodeRuntimeHandler> runtimeHandlers = new ArrayList<V1NodeRuntimeHandler>();
    public static final String SERIALIZED_NAME_VOLUMES_ATTACHED = "volumesAttached";
    @SerializedName(value="volumesAttached")
    private List<V1AttachedVolume> volumesAttached = new ArrayList<V1AttachedVolume>();
    public static final String SERIALIZED_NAME_VOLUMES_IN_USE = "volumesInUse";
    @SerializedName(value="volumesInUse")
    private List<String> volumesInUse = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1NodeStatus addresses(List<V1NodeAddress> addresses) {
        this.addresses = addresses;
        return this;
    }

    public V1NodeStatus addAddressesItem(V1NodeAddress addressesItem) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<V1NodeAddress>();
        }
        this.addresses.add(addressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of addresses reachable to the node. Queried from cloud provider, if available. More info: https://kubernetes.io/docs/reference/node/node-status/#addresses Note: This field is declared as mergeable, but the merge key is not sufficiently unique, which can cause data corruption when it is merged. Callers should instead use a full-replacement patch. See https://pr.k8s.io/79391 for an example. Consumers should assume that addresses can change during the lifetime of a Node. However, there are some exceptions where this may not be possible, such as Pods that inherit a Node's address in its own status or consumers of the downward API (status.hostIP).")
    public List<V1NodeAddress> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<V1NodeAddress> addresses) {
        this.addresses = addresses;
    }

    public V1NodeStatus allocatable(Map<String, Quantity> allocatable) {
        this.allocatable = allocatable;
        return this;
    }

    public V1NodeStatus putAllocatableItem(String key, Quantity allocatableItem) {
        if (this.allocatable == null) {
            this.allocatable = new HashMap<String, Quantity>();
        }
        this.allocatable.put(key, allocatableItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allocatable represents the resources of a node that are available for scheduling. Defaults to Capacity.")
    public Map<String, Quantity> getAllocatable() {
        return this.allocatable;
    }

    public void setAllocatable(Map<String, Quantity> allocatable) {
        this.allocatable = allocatable;
    }

    public V1NodeStatus capacity(Map<String, Quantity> capacity) {
        this.capacity = capacity;
        return this;
    }

    public V1NodeStatus putCapacityItem(String key, Quantity capacityItem) {
        if (this.capacity == null) {
            this.capacity = new HashMap<String, Quantity>();
        }
        this.capacity.put(key, capacityItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Capacity represents the total resources of a node. More info: https://kubernetes.io/docs/reference/node/node-status/#capacity")
    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Map<String, Quantity> capacity) {
        this.capacity = capacity;
    }

    public V1NodeStatus conditions(List<V1NodeCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1NodeStatus addConditionsItem(V1NodeCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1NodeCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Conditions is an array of current observed node conditions. More info: https://kubernetes.io/docs/reference/node/node-status/#condition")
    public List<V1NodeCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1NodeCondition> conditions) {
        this.conditions = conditions;
    }

    public V1NodeStatus config(V1NodeConfigStatus config) {
        this.config = config;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeConfigStatus getConfig() {
        return this.config;
    }

    public void setConfig(V1NodeConfigStatus config) {
        this.config = config;
    }

    public V1NodeStatus daemonEndpoints(V1NodeDaemonEndpoints daemonEndpoints) {
        this.daemonEndpoints = daemonEndpoints;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeDaemonEndpoints getDaemonEndpoints() {
        return this.daemonEndpoints;
    }

    public void setDaemonEndpoints(V1NodeDaemonEndpoints daemonEndpoints) {
        this.daemonEndpoints = daemonEndpoints;
    }

    public V1NodeStatus features(V1NodeFeatures features) {
        this.features = features;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeFeatures getFeatures() {
        return this.features;
    }

    public void setFeatures(V1NodeFeatures features) {
        this.features = features;
    }

    public V1NodeStatus images(List<V1ContainerImage> images) {
        this.images = images;
        return this;
    }

    public V1NodeStatus addImagesItem(V1ContainerImage imagesItem) {
        if (this.images == null) {
            this.images = new ArrayList<V1ContainerImage>();
        }
        this.images.add(imagesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of container images on this node")
    public List<V1ContainerImage> getImages() {
        return this.images;
    }

    public void setImages(List<V1ContainerImage> images) {
        this.images = images;
    }

    public V1NodeStatus nodeInfo(V1NodeSystemInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeSystemInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public void setNodeInfo(V1NodeSystemInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    public V1NodeStatus phase(String phase) {
        this.phase = phase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NodePhase is the recently observed lifecycle phase of the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#phase The field is never populated, and now is deprecated.")
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public V1NodeStatus runtimeHandlers(List<V1NodeRuntimeHandler> runtimeHandlers) {
        this.runtimeHandlers = runtimeHandlers;
        return this;
    }

    public V1NodeStatus addRuntimeHandlersItem(V1NodeRuntimeHandler runtimeHandlersItem) {
        if (this.runtimeHandlers == null) {
            this.runtimeHandlers = new ArrayList<V1NodeRuntimeHandler>();
        }
        this.runtimeHandlers.add(runtimeHandlersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The available runtime handlers.")
    public List<V1NodeRuntimeHandler> getRuntimeHandlers() {
        return this.runtimeHandlers;
    }

    public void setRuntimeHandlers(List<V1NodeRuntimeHandler> runtimeHandlers) {
        this.runtimeHandlers = runtimeHandlers;
    }

    public V1NodeStatus volumesAttached(List<V1AttachedVolume> volumesAttached) {
        this.volumesAttached = volumesAttached;
        return this;
    }

    public V1NodeStatus addVolumesAttachedItem(V1AttachedVolume volumesAttachedItem) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList<V1AttachedVolume>();
        }
        this.volumesAttached.add(volumesAttachedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of volumes that are attached to the node.")
    public List<V1AttachedVolume> getVolumesAttached() {
        return this.volumesAttached;
    }

    public void setVolumesAttached(List<V1AttachedVolume> volumesAttached) {
        this.volumesAttached = volumesAttached;
    }

    public V1NodeStatus volumesInUse(List<String> volumesInUse) {
        this.volumesInUse = volumesInUse;
        return this;
    }

    public V1NodeStatus addVolumesInUseItem(String volumesInUseItem) {
        if (this.volumesInUse == null) {
            this.volumesInUse = new ArrayList<String>();
        }
        this.volumesInUse.add(volumesInUseItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of attachable volumes in use (mounted) by the node.")
    public List<String> getVolumesInUse() {
        return this.volumesInUse;
    }

    public void setVolumesInUse(List<String> volumesInUse) {
        this.volumesInUse = volumesInUse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NodeStatus v1NodeStatus = (V1NodeStatus)o;
        return Objects.equals(this.addresses, v1NodeStatus.addresses) && Objects.equals(this.allocatable, v1NodeStatus.allocatable) && Objects.equals(this.capacity, v1NodeStatus.capacity) && Objects.equals(this.conditions, v1NodeStatus.conditions) && Objects.equals(this.config, v1NodeStatus.config) && Objects.equals(this.daemonEndpoints, v1NodeStatus.daemonEndpoints) && Objects.equals(this.features, v1NodeStatus.features) && Objects.equals(this.images, v1NodeStatus.images) && Objects.equals(this.nodeInfo, v1NodeStatus.nodeInfo) && Objects.equals(this.phase, v1NodeStatus.phase) && Objects.equals(this.runtimeHandlers, v1NodeStatus.runtimeHandlers) && Objects.equals(this.volumesAttached, v1NodeStatus.volumesAttached) && Objects.equals(this.volumesInUse, v1NodeStatus.volumesInUse);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.allocatable, this.capacity, this.conditions, this.config, this.daemonEndpoints, this.features, this.images, this.nodeInfo, this.phase, this.runtimeHandlers, this.volumesAttached, this.volumesInUse);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NodeStatus {\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    allocatable: ").append(this.toIndentedString(this.allocatable)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    daemonEndpoints: ").append(this.toIndentedString(this.daemonEndpoints)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("    nodeInfo: ").append(this.toIndentedString(this.nodeInfo)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString(this.phase)).append("\n");
        sb.append("    runtimeHandlers: ").append(this.toIndentedString(this.runtimeHandlers)).append("\n");
        sb.append("    volumesAttached: ").append(this.toIndentedString(this.volumesAttached)).append("\n");
        sb.append("    volumesInUse: ").append(this.toIndentedString(this.volumesInUse)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayvolumesAttached;
        JsonArray jsonArrayruntimeHandlers;
        JsonArray jsonArrayimages;
        JsonArray jsonArrayconditions;
        int i;
        JsonArray jsonArrayaddresses;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1NodeStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1NodeStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ADDRESSES) != null && !jsonObj.get(SERIALIZED_NAME_ADDRESSES).isJsonNull() && (jsonArrayaddresses = jsonObj.getAsJsonArray(SERIALIZED_NAME_ADDRESSES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ADDRESSES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `addresses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ADDRESSES).toString()));
            }
            for (i = 0; i < jsonArrayaddresses.size(); ++i) {
                V1NodeAddress.validateJsonElement(jsonArrayaddresses.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonNull() && (jsonArrayconditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONDITIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `conditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONDITIONS).toString()));
            }
            for (i = 0; i < jsonArrayconditions.size(); ++i) {
                V1NodeCondition.validateJsonElement(jsonArrayconditions.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_CONFIG).isJsonNull()) {
            V1NodeConfigStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_DAEMON_ENDPOINTS) != null && !jsonObj.get(SERIALIZED_NAME_DAEMON_ENDPOINTS).isJsonNull()) {
            V1NodeDaemonEndpoints.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DAEMON_ENDPOINTS));
        }
        if (jsonObj.get(SERIALIZED_NAME_FEATURES) != null && !jsonObj.get(SERIALIZED_NAME_FEATURES).isJsonNull()) {
            V1NodeFeatures.validateJsonElement(jsonObj.get(SERIALIZED_NAME_FEATURES));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGES) != null && !jsonObj.get(SERIALIZED_NAME_IMAGES).isJsonNull() && (jsonArrayimages = jsonObj.getAsJsonArray(SERIALIZED_NAME_IMAGES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_IMAGES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `images` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGES).toString()));
            }
            for (i = 0; i < jsonArrayimages.size(); ++i) {
                V1ContainerImage.validateJsonElement(jsonArrayimages.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_NODE_INFO) != null && !jsonObj.get(SERIALIZED_NAME_NODE_INFO).isJsonNull()) {
            V1NodeSystemInfo.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NODE_INFO));
        }
        if (jsonObj.get(SERIALIZED_NAME_PHASE) != null && !jsonObj.get(SERIALIZED_NAME_PHASE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PHASE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `phase` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHASE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RUNTIME_HANDLERS) != null && !jsonObj.get(SERIALIZED_NAME_RUNTIME_HANDLERS).isJsonNull() && (jsonArrayruntimeHandlers = jsonObj.getAsJsonArray(SERIALIZED_NAME_RUNTIME_HANDLERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RUNTIME_HANDLERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `runtimeHandlers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RUNTIME_HANDLERS).toString()));
            }
            for (i = 0; i < jsonArrayruntimeHandlers.size(); ++i) {
                V1NodeRuntimeHandler.validateJsonElement(jsonArrayruntimeHandlers.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES_ATTACHED) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES_ATTACHED).isJsonNull() && (jsonArrayvolumesAttached = jsonObj.getAsJsonArray(SERIALIZED_NAME_VOLUMES_ATTACHED)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VOLUMES_ATTACHED).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `volumesAttached` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES_ATTACHED).toString()));
            }
            for (i = 0; i < jsonArrayvolumesAttached.size(); ++i) {
                V1AttachedVolume.validateJsonElement(jsonArrayvolumesAttached.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES_IN_USE) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES_IN_USE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VOLUMES_IN_USE).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumesInUse` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES_IN_USE).toString()));
        }
    }

    public static V1NodeStatus fromJson(String jsonString) throws IOException {
        return (V1NodeStatus)JSON.getGson().fromJson(jsonString, V1NodeStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDRESSES);
        openapiFields.add(SERIALIZED_NAME_ALLOCATABLE);
        openapiFields.add(SERIALIZED_NAME_CAPACITY);
        openapiFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_CONFIG);
        openapiFields.add(SERIALIZED_NAME_DAEMON_ENDPOINTS);
        openapiFields.add(SERIALIZED_NAME_FEATURES);
        openapiFields.add(SERIALIZED_NAME_IMAGES);
        openapiFields.add(SERIALIZED_NAME_NODE_INFO);
        openapiFields.add(SERIALIZED_NAME_PHASE);
        openapiFields.add(SERIALIZED_NAME_RUNTIME_HANDLERS);
        openapiFields.add(SERIALIZED_NAME_VOLUMES_ATTACHED);
        openapiFields.add(SERIALIZED_NAME_VOLUMES_IN_USE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1NodeStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1NodeStatus.class));
            return new TypeAdapter<V1NodeStatus>(){

                public void write(JsonWriter out, V1NodeStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1NodeStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1NodeStatus.validateJsonElement(jsonElement);
                    return (V1NodeStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

