/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1alpha1ApplyConfiguration;
import io.kubernetes.client.openapi.models.V1alpha1JSONPatch;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="Mutation specifies the CEL expression which is used to apply the Mutation.")
public class V1alpha1Mutation {
    public static final String SERIALIZED_NAME_APPLY_CONFIGURATION = "applyConfiguration";
    @SerializedName(value="applyConfiguration")
    private V1alpha1ApplyConfiguration applyConfiguration;
    public static final String SERIALIZED_NAME_JSON_PATCH = "jsonPatch";
    @SerializedName(value="jsonPatch")
    private V1alpha1JSONPatch jsonPatch;
    public static final String SERIALIZED_NAME_PATCH_TYPE = "patchType";
    @SerializedName(value="patchType")
    private String patchType;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1alpha1Mutation applyConfiguration(V1alpha1ApplyConfiguration applyConfiguration) {
        this.applyConfiguration = applyConfiguration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha1ApplyConfiguration getApplyConfiguration() {
        return this.applyConfiguration;
    }

    public void setApplyConfiguration(V1alpha1ApplyConfiguration applyConfiguration) {
        this.applyConfiguration = applyConfiguration;
    }

    public V1alpha1Mutation jsonPatch(V1alpha1JSONPatch jsonPatch) {
        this.jsonPatch = jsonPatch;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha1JSONPatch getJsonPatch() {
        return this.jsonPatch;
    }

    public void setJsonPatch(V1alpha1JSONPatch jsonPatch) {
        this.jsonPatch = jsonPatch;
    }

    public V1alpha1Mutation patchType(String patchType) {
        this.patchType = patchType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="patchType indicates the patch strategy used. Allowed values are \"ApplyConfiguration\" and \"JSONPatch\". Required.")
    public String getPatchType() {
        return this.patchType;
    }

    public void setPatchType(String patchType) {
        this.patchType = patchType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1Mutation v1alpha1Mutation = (V1alpha1Mutation)o;
        return Objects.equals(this.applyConfiguration, v1alpha1Mutation.applyConfiguration) && Objects.equals(this.jsonPatch, v1alpha1Mutation.jsonPatch) && Objects.equals(this.patchType, v1alpha1Mutation.patchType);
    }

    public int hashCode() {
        return Objects.hash(this.applyConfiguration, this.jsonPatch, this.patchType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1Mutation {\n");
        sb.append("    applyConfiguration: ").append(this.toIndentedString(this.applyConfiguration)).append("\n");
        sb.append("    jsonPatch: ").append(this.toIndentedString(this.jsonPatch)).append("\n");
        sb.append("    patchType: ").append(this.toIndentedString(this.patchType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1alpha1Mutation is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1alpha1Mutation` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_APPLY_CONFIGURATION) != null && !jsonObj.get(SERIALIZED_NAME_APPLY_CONFIGURATION).isJsonNull()) {
            V1alpha1ApplyConfiguration.validateJsonElement(jsonObj.get(SERIALIZED_NAME_APPLY_CONFIGURATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_JSON_PATCH) != null && !jsonObj.get(SERIALIZED_NAME_JSON_PATCH).isJsonNull()) {
            V1alpha1JSONPatch.validateJsonElement(jsonObj.get(SERIALIZED_NAME_JSON_PATCH));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PATCH_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `patchType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PATCH_TYPE).toString()));
        }
    }

    public static V1alpha1Mutation fromJson(String jsonString) throws IOException {
        return (V1alpha1Mutation)JSON.getGson().fromJson(jsonString, V1alpha1Mutation.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_APPLY_CONFIGURATION);
        openapiFields.add(SERIALIZED_NAME_JSON_PATCH);
        openapiFields.add(SERIALIZED_NAME_PATCH_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PATCH_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1alpha1Mutation.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1alpha1Mutation.class));
            return new TypeAdapter<V1alpha1Mutation>(){

                public void write(JsonWriter out, V1alpha1Mutation value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1alpha1Mutation read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1alpha1Mutation.validateJsonElement(jsonElement);
                    return (V1alpha1Mutation)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

