/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1beta1OpaqueDeviceConfiguration;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="DeviceAllocationConfiguration gets embedded in an AllocationResult.")
public class V1beta1DeviceAllocationConfiguration {
    public static final String SERIALIZED_NAME_OPAQUE = "opaque";
    @SerializedName(value="opaque")
    private V1beta1OpaqueDeviceConfiguration opaque;
    public static final String SERIALIZED_NAME_REQUESTS = "requests";
    @SerializedName(value="requests")
    private List<String> requests = new ArrayList<String>();
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private String source;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta1DeviceAllocationConfiguration opaque(V1beta1OpaqueDeviceConfiguration opaque) {
        this.opaque = opaque;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta1OpaqueDeviceConfiguration getOpaque() {
        return this.opaque;
    }

    public void setOpaque(V1beta1OpaqueDeviceConfiguration opaque) {
        this.opaque = opaque;
    }

    public V1beta1DeviceAllocationConfiguration requests(List<String> requests) {
        this.requests = requests;
        return this;
    }

    public V1beta1DeviceAllocationConfiguration addRequestsItem(String requestsItem) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        this.requests.add(requestsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Requests lists the names of requests where the configuration applies. If empty, its applies to all requests.")
    public List<String> getRequests() {
        return this.requests;
    }

    public void setRequests(List<String> requests) {
        this.requests = requests;
    }

    public V1beta1DeviceAllocationConfiguration source(String source) {
        this.source = source;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Source records whether the configuration comes from a class and thus is not something that a normal user would have been able to set or from a claim.")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1DeviceAllocationConfiguration v1beta1DeviceAllocationConfiguration = (V1beta1DeviceAllocationConfiguration)o;
        return Objects.equals(this.opaque, v1beta1DeviceAllocationConfiguration.opaque) && Objects.equals(this.requests, v1beta1DeviceAllocationConfiguration.requests) && Objects.equals(this.source, v1beta1DeviceAllocationConfiguration.source);
    }

    public int hashCode() {
        return Objects.hash(this.opaque, this.requests, this.source);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1DeviceAllocationConfiguration {\n");
        sb.append("    opaque: ").append(this.toIndentedString(this.opaque)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta1DeviceAllocationConfiguration is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta1DeviceAllocationConfiguration` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_OPAQUE) != null && !jsonObj.get(SERIALIZED_NAME_OPAQUE).isJsonNull()) {
            V1beta1OpaqueDeviceConfiguration.validateJsonElement(jsonObj.get(SERIALIZED_NAME_OPAQUE));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUESTS) != null && !jsonObj.get(SERIALIZED_NAME_REQUESTS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REQUESTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `requests` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUESTS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SOURCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `source` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE).toString()));
        }
    }

    public static V1beta1DeviceAllocationConfiguration fromJson(String jsonString) throws IOException {
        return (V1beta1DeviceAllocationConfiguration)JSON.getGson().fromJson(jsonString, V1beta1DeviceAllocationConfiguration.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_OPAQUE);
        openapiFields.add(SERIALIZED_NAME_REQUESTS);
        openapiFields.add(SERIALIZED_NAME_SOURCE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SOURCE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta1DeviceAllocationConfiguration.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta1DeviceAllocationConfiguration.class));
            return new TypeAdapter<V1beta1DeviceAllocationConfiguration>(){

                public void write(JsonWriter out, V1beta1DeviceAllocationConfiguration value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta1DeviceAllocationConfiguration read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta1DeviceAllocationConfiguration.validateJsonElement(jsonElement);
                    return (V1beta1DeviceAllocationConfiguration)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

