/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="LeaseCandidateSpec is a specification of a Lease.")
public class V1beta1LeaseCandidateSpec {
    public static final String SERIALIZED_NAME_BINARY_VERSION = "binaryVersion";
    @SerializedName(value="binaryVersion")
    @Nonnull
    private String binaryVersion;
    public static final String SERIALIZED_NAME_EMULATION_VERSION = "emulationVersion";
    @SerializedName(value="emulationVersion")
    @Nullable
    private String emulationVersion;
    public static final String SERIALIZED_NAME_LEASE_NAME = "leaseName";
    @SerializedName(value="leaseName")
    @Nonnull
    private String leaseName;
    public static final String SERIALIZED_NAME_PING_TIME = "pingTime";
    @SerializedName(value="pingTime")
    @Nullable
    private OffsetDateTime pingTime;
    public static final String SERIALIZED_NAME_RENEW_TIME = "renewTime";
    @SerializedName(value="renewTime")
    @Nullable
    private OffsetDateTime renewTime;
    public static final String SERIALIZED_NAME_STRATEGY = "strategy";
    @SerializedName(value="strategy")
    @Nonnull
    private String strategy;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta1LeaseCandidateSpec binaryVersion(@Nonnull String binaryVersion) {
        this.binaryVersion = binaryVersion;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="BinaryVersion is the binary version. It must be in a semver format without leading `v`. This field is required.")
    public String getBinaryVersion() {
        return this.binaryVersion;
    }

    public void setBinaryVersion(@Nonnull String binaryVersion) {
        this.binaryVersion = binaryVersion;
    }

    public V1beta1LeaseCandidateSpec emulationVersion(@Nullable String emulationVersion) {
        this.emulationVersion = emulationVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EmulationVersion is the emulation version. It must be in a semver format without leading `v`. EmulationVersion must be less than or equal to BinaryVersion. This field is required when strategy is \"OldestEmulationVersion\"")
    public String getEmulationVersion() {
        return this.emulationVersion;
    }

    public void setEmulationVersion(@Nullable String emulationVersion) {
        this.emulationVersion = emulationVersion;
    }

    public V1beta1LeaseCandidateSpec leaseName(@Nonnull String leaseName) {
        this.leaseName = leaseName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="LeaseName is the name of the lease for which this candidate is contending. The limits on this field are the same as on Lease.name. Multiple lease candidates may reference the same Lease.name. This field is immutable.")
    public String getLeaseName() {
        return this.leaseName;
    }

    public void setLeaseName(@Nonnull String leaseName) {
        this.leaseName = leaseName;
    }

    public V1beta1LeaseCandidateSpec pingTime(@Nullable OffsetDateTime pingTime) {
        this.pingTime = pingTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PingTime is the last time that the server has requested the LeaseCandidate to renew. It is only done during leader election to check if any LeaseCandidates have become ineligible. When PingTime is updated, the LeaseCandidate will respond by updating RenewTime.")
    public OffsetDateTime getPingTime() {
        return this.pingTime;
    }

    public void setPingTime(@Nullable OffsetDateTime pingTime) {
        this.pingTime = pingTime;
    }

    public V1beta1LeaseCandidateSpec renewTime(@Nullable OffsetDateTime renewTime) {
        this.renewTime = renewTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RenewTime is the time that the LeaseCandidate was last updated. Any time a Lease needs to do leader election, the PingTime field is updated to signal to the LeaseCandidate that they should update the RenewTime. Old LeaseCandidate objects are also garbage collected if it has been hours since the last renew. The PingTime field is updated regularly to prevent garbage collection for still active LeaseCandidates.")
    public OffsetDateTime getRenewTime() {
        return this.renewTime;
    }

    public void setRenewTime(@Nullable OffsetDateTime renewTime) {
        this.renewTime = renewTime;
    }

    public V1beta1LeaseCandidateSpec strategy(@Nonnull String strategy) {
        this.strategy = strategy;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Strategy is the strategy that coordinated leader election will use for picking the leader. If multiple candidates for the same Lease return different strategies, the strategy provided by the candidate with the latest BinaryVersion will be used. If there is still conflict, this is a user error and coordinated leader election will not operate the Lease until resolved.")
    public String getStrategy() {
        return this.strategy;
    }

    public void setStrategy(@Nonnull String strategy) {
        this.strategy = strategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1LeaseCandidateSpec v1beta1LeaseCandidateSpec = (V1beta1LeaseCandidateSpec)o;
        return Objects.equals(this.binaryVersion, v1beta1LeaseCandidateSpec.binaryVersion) && Objects.equals(this.emulationVersion, v1beta1LeaseCandidateSpec.emulationVersion) && Objects.equals(this.leaseName, v1beta1LeaseCandidateSpec.leaseName) && Objects.equals(this.pingTime, v1beta1LeaseCandidateSpec.pingTime) && Objects.equals(this.renewTime, v1beta1LeaseCandidateSpec.renewTime) && Objects.equals(this.strategy, v1beta1LeaseCandidateSpec.strategy);
    }

    public int hashCode() {
        return Objects.hash(this.binaryVersion, this.emulationVersion, this.leaseName, this.pingTime, this.renewTime, this.strategy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1LeaseCandidateSpec {\n");
        sb.append("    binaryVersion: ").append(this.toIndentedString(this.binaryVersion)).append("\n");
        sb.append("    emulationVersion: ").append(this.toIndentedString(this.emulationVersion)).append("\n");
        sb.append("    leaseName: ").append(this.toIndentedString(this.leaseName)).append("\n");
        sb.append("    pingTime: ").append(this.toIndentedString(this.pingTime)).append("\n");
        sb.append("    renewTime: ").append(this.toIndentedString(this.renewTime)).append("\n");
        sb.append("    strategy: ").append(this.toIndentedString(this.strategy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta1LeaseCandidateSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta1LeaseCandidateSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_BINARY_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `binaryVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BINARY_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMULATION_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_EMULATION_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EMULATION_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `emulationVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMULATION_VERSION).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_LEASE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `leaseName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LEASE_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_STRATEGY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `strategy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STRATEGY).toString()));
        }
    }

    public static V1beta1LeaseCandidateSpec fromJson(String jsonString) throws IOException {
        return (V1beta1LeaseCandidateSpec)JSON.getGson().fromJson(jsonString, V1beta1LeaseCandidateSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BINARY_VERSION);
        openapiFields.add(SERIALIZED_NAME_EMULATION_VERSION);
        openapiFields.add(SERIALIZED_NAME_LEASE_NAME);
        openapiFields.add(SERIALIZED_NAME_PING_TIME);
        openapiFields.add(SERIALIZED_NAME_RENEW_TIME);
        openapiFields.add(SERIALIZED_NAME_STRATEGY);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_BINARY_VERSION);
        openapiRequiredFields.add(SERIALIZED_NAME_LEASE_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_STRATEGY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta1LeaseCandidateSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta1LeaseCandidateSpec.class));
            return new TypeAdapter<V1beta1LeaseCandidateSpec>(){

                public void write(JsonWriter out, V1beta1LeaseCandidateSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta1LeaseCandidateSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta1LeaseCandidateSpec.validateJsonElement(jsonElement);
                    return (V1beta1LeaseCandidateSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

