/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1Affinity;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1EphemeralContainer;
import io.kubernetes.client.openapi.models.V1HostAlias;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.kubernetes.client.openapi.models.V1PodDNSConfig;
import io.kubernetes.client.openapi.models.V1PodOS;
import io.kubernetes.client.openapi.models.V1PodReadinessGate;
import io.kubernetes.client.openapi.models.V1PodResourceClaim;
import io.kubernetes.client.openapi.models.V1PodSchedulingGate;
import io.kubernetes.client.openapi.models.V1PodSecurityContext;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1Toleration;
import io.kubernetes.client.openapi.models.V1TopologySpreadConstraint;
import io.kubernetes.client.openapi.models.V1Volume;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PodSpec is a description of a pod.")
public class V1PodSpec {
    public static final String SERIALIZED_NAME_ACTIVE_DEADLINE_SECONDS = "activeDeadlineSeconds";
    @SerializedName(value="activeDeadlineSeconds")
    @Nullable
    private Long activeDeadlineSeconds;
    public static final String SERIALIZED_NAME_AFFINITY = "affinity";
    @SerializedName(value="affinity")
    @Nullable
    private V1Affinity affinity;
    public static final String SERIALIZED_NAME_AUTOMOUNT_SERVICE_ACCOUNT_TOKEN = "automountServiceAccountToken";
    @SerializedName(value="automountServiceAccountToken")
    @Nullable
    private Boolean automountServiceAccountToken;
    public static final String SERIALIZED_NAME_CONTAINERS = "containers";
    @SerializedName(value="containers")
    @Nonnull
    private List<V1Container> containers = new ArrayList<V1Container>();
    public static final String SERIALIZED_NAME_DNS_CONFIG = "dnsConfig";
    @SerializedName(value="dnsConfig")
    @Nullable
    private V1PodDNSConfig dnsConfig;
    public static final String SERIALIZED_NAME_DNS_POLICY = "dnsPolicy";
    @SerializedName(value="dnsPolicy")
    @Nullable
    private String dnsPolicy;
    public static final String SERIALIZED_NAME_ENABLE_SERVICE_LINKS = "enableServiceLinks";
    @SerializedName(value="enableServiceLinks")
    @Nullable
    private Boolean enableServiceLinks;
    public static final String SERIALIZED_NAME_EPHEMERAL_CONTAINERS = "ephemeralContainers";
    @SerializedName(value="ephemeralContainers")
    @Nullable
    private List<V1EphemeralContainer> ephemeralContainers = new ArrayList<V1EphemeralContainer>();
    public static final String SERIALIZED_NAME_HOST_ALIASES = "hostAliases";
    @SerializedName(value="hostAliases")
    @Nullable
    private List<V1HostAlias> hostAliases = new ArrayList<V1HostAlias>();
    public static final String SERIALIZED_NAME_HOST_I_P_C = "hostIPC";
    @SerializedName(value="hostIPC")
    @Nullable
    private Boolean hostIPC;
    public static final String SERIALIZED_NAME_HOST_NETWORK = "hostNetwork";
    @SerializedName(value="hostNetwork")
    @Nullable
    private Boolean hostNetwork;
    public static final String SERIALIZED_NAME_HOST_P_I_D = "hostPID";
    @SerializedName(value="hostPID")
    @Nullable
    private Boolean hostPID;
    public static final String SERIALIZED_NAME_HOST_USERS = "hostUsers";
    @SerializedName(value="hostUsers")
    @Nullable
    private Boolean hostUsers;
    public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
    @SerializedName(value="hostname")
    @Nullable
    private String hostname;
    public static final String SERIALIZED_NAME_HOSTNAME_OVERRIDE = "hostnameOverride";
    @SerializedName(value="hostnameOverride")
    @Nullable
    private String hostnameOverride;
    public static final String SERIALIZED_NAME_IMAGE_PULL_SECRETS = "imagePullSecrets";
    @SerializedName(value="imagePullSecrets")
    @Nullable
    private List<V1LocalObjectReference> imagePullSecrets = new ArrayList<V1LocalObjectReference>();
    public static final String SERIALIZED_NAME_INIT_CONTAINERS = "initContainers";
    @SerializedName(value="initContainers")
    @Nullable
    private List<V1Container> initContainers = new ArrayList<V1Container>();
    public static final String SERIALIZED_NAME_NODE_NAME = "nodeName";
    @SerializedName(value="nodeName")
    @Nullable
    private String nodeName;
    public static final String SERIALIZED_NAME_NODE_SELECTOR = "nodeSelector";
    @SerializedName(value="nodeSelector")
    @Nullable
    private Map<String, String> nodeSelector = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_OS = "os";
    @SerializedName(value="os")
    @Nullable
    private V1PodOS os;
    public static final String SERIALIZED_NAME_OVERHEAD = "overhead";
    @SerializedName(value="overhead")
    @Nullable
    private Map<String, Quantity> overhead = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_PREEMPTION_POLICY = "preemptionPolicy";
    @SerializedName(value="preemptionPolicy")
    @Nullable
    private String preemptionPolicy;
    public static final String SERIALIZED_NAME_PRIORITY = "priority";
    @SerializedName(value="priority")
    @Nullable
    private Integer priority;
    public static final String SERIALIZED_NAME_PRIORITY_CLASS_NAME = "priorityClassName";
    @SerializedName(value="priorityClassName")
    @Nullable
    private String priorityClassName;
    public static final String SERIALIZED_NAME_READINESS_GATES = "readinessGates";
    @SerializedName(value="readinessGates")
    @Nullable
    private List<V1PodReadinessGate> readinessGates = new ArrayList<V1PodReadinessGate>();
    public static final String SERIALIZED_NAME_RESOURCE_CLAIMS = "resourceClaims";
    @SerializedName(value="resourceClaims")
    @Nullable
    private List<V1PodResourceClaim> resourceClaims = new ArrayList<V1PodResourceClaim>();
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    @Nullable
    private V1ResourceRequirements resources;
    public static final String SERIALIZED_NAME_RESTART_POLICY = "restartPolicy";
    @SerializedName(value="restartPolicy")
    @Nullable
    private String restartPolicy;
    public static final String SERIALIZED_NAME_RUNTIME_CLASS_NAME = "runtimeClassName";
    @SerializedName(value="runtimeClassName")
    @Nullable
    private String runtimeClassName;
    public static final String SERIALIZED_NAME_SCHEDULER_NAME = "schedulerName";
    @SerializedName(value="schedulerName")
    @Nullable
    private String schedulerName;
    public static final String SERIALIZED_NAME_SCHEDULING_GATES = "schedulingGates";
    @SerializedName(value="schedulingGates")
    @Nullable
    private List<V1PodSchedulingGate> schedulingGates = new ArrayList<V1PodSchedulingGate>();
    public static final String SERIALIZED_NAME_SECURITY_CONTEXT = "securityContext";
    @SerializedName(value="securityContext")
    @Nullable
    private V1PodSecurityContext securityContext;
    public static final String SERIALIZED_NAME_SERVICE_ACCOUNT = "serviceAccount";
    @SerializedName(value="serviceAccount")
    @Nullable
    private String serviceAccount;
    public static final String SERIALIZED_NAME_SERVICE_ACCOUNT_NAME = "serviceAccountName";
    @SerializedName(value="serviceAccountName")
    @Nullable
    private String serviceAccountName;
    public static final String SERIALIZED_NAME_SET_HOSTNAME_AS_F_Q_D_N = "setHostnameAsFQDN";
    @SerializedName(value="setHostnameAsFQDN")
    @Nullable
    private Boolean setHostnameAsFQDN;
    public static final String SERIALIZED_NAME_SHARE_PROCESS_NAMESPACE = "shareProcessNamespace";
    @SerializedName(value="shareProcessNamespace")
    @Nullable
    private Boolean shareProcessNamespace;
    public static final String SERIALIZED_NAME_SUBDOMAIN = "subdomain";
    @SerializedName(value="subdomain")
    @Nullable
    private String subdomain;
    public static final String SERIALIZED_NAME_TERMINATION_GRACE_PERIOD_SECONDS = "terminationGracePeriodSeconds";
    @SerializedName(value="terminationGracePeriodSeconds")
    @Nullable
    private Long terminationGracePeriodSeconds;
    public static final String SERIALIZED_NAME_TOLERATIONS = "tolerations";
    @SerializedName(value="tolerations")
    @Nullable
    private List<V1Toleration> tolerations = new ArrayList<V1Toleration>();
    public static final String SERIALIZED_NAME_TOPOLOGY_SPREAD_CONSTRAINTS = "topologySpreadConstraints";
    @SerializedName(value="topologySpreadConstraints")
    @Nullable
    private List<V1TopologySpreadConstraint> topologySpreadConstraints = new ArrayList<V1TopologySpreadConstraint>();
    public static final String SERIALIZED_NAME_VOLUMES = "volumes";
    @SerializedName(value="volumes")
    @Nullable
    private List<V1Volume> volumes = new ArrayList<V1Volume>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1PodSpec activeDeadlineSeconds(@Nullable Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.")
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public void setActiveDeadlineSeconds(@Nullable Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
    }

    public V1PodSpec affinity(@Nullable V1Affinity affinity) {
        this.affinity = affinity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1Affinity getAffinity() {
        return this.affinity;
    }

    public void setAffinity(@Nullable V1Affinity affinity) {
        this.affinity = affinity;
    }

    public V1PodSpec automountServiceAccountToken(@Nullable Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.")
    public Boolean getAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    public void setAutomountServiceAccountToken(@Nullable Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
    }

    public V1PodSpec containers(@Nonnull List<V1Container> containers) {
        this.containers = containers;
        return this;
    }

    public V1PodSpec addContainersItem(V1Container containersItem) {
        if (this.containers == null) {
            this.containers = new ArrayList<V1Container>();
        }
        this.containers.add(containersItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated.")
    public List<V1Container> getContainers() {
        return this.containers;
    }

    public void setContainers(@Nonnull List<V1Container> containers) {
        this.containers = containers;
    }

    public V1PodSpec dnsConfig(@Nullable V1PodDNSConfig dnsConfig) {
        this.dnsConfig = dnsConfig;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1PodDNSConfig getDnsConfig() {
        return this.dnsConfig;
    }

    public void setDnsConfig(@Nullable V1PodDNSConfig dnsConfig) {
        this.dnsConfig = dnsConfig;
    }

    public V1PodSpec dnsPolicy(@Nullable String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set DNS policy for the pod. Defaults to \"ClusterFirst\". Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'.")
    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    public void setDnsPolicy(@Nullable String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
    }

    public V1PodSpec enableServiceLinks(@Nullable Boolean enableServiceLinks) {
        this.enableServiceLinks = enableServiceLinks;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EnableServiceLinks indicates whether information about services should be injected into pod's environment variables, matching the syntax of Docker links. Optional: Defaults to true.")
    public Boolean getEnableServiceLinks() {
        return this.enableServiceLinks;
    }

    public void setEnableServiceLinks(@Nullable Boolean enableServiceLinks) {
        this.enableServiceLinks = enableServiceLinks;
    }

    public V1PodSpec ephemeralContainers(@Nullable List<V1EphemeralContainer> ephemeralContainers) {
        this.ephemeralContainers = ephemeralContainers;
        return this;
    }

    public V1PodSpec addEphemeralContainersItem(V1EphemeralContainer ephemeralContainersItem) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList<V1EphemeralContainer>();
        }
        this.ephemeralContainers.add(ephemeralContainersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of ephemeral containers run in this pod. Ephemeral containers may be run in an existing pod to perform user-initiated actions such as debugging. This list cannot be specified when creating a pod, and it cannot be modified by updating the pod spec. In order to add an ephemeral container to an existing pod, use the pod's ephemeralcontainers subresource.")
    public List<V1EphemeralContainer> getEphemeralContainers() {
        return this.ephemeralContainers;
    }

    public void setEphemeralContainers(@Nullable List<V1EphemeralContainer> ephemeralContainers) {
        this.ephemeralContainers = ephemeralContainers;
    }

    public V1PodSpec hostAliases(@Nullable List<V1HostAlias> hostAliases) {
        this.hostAliases = hostAliases;
        return this;
    }

    public V1PodSpec addHostAliasesItem(V1HostAlias hostAliasesItem) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList<V1HostAlias>();
        }
        this.hostAliases.add(hostAliasesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HostAliases is an optional list of hosts and IPs that will be injected into the pod's hosts file if specified.")
    public List<V1HostAlias> getHostAliases() {
        return this.hostAliases;
    }

    public void setHostAliases(@Nullable List<V1HostAlias> hostAliases) {
        this.hostAliases = hostAliases;
    }

    public V1PodSpec hostIPC(@Nullable Boolean hostIPC) {
        this.hostIPC = hostIPC;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Use the host's ipc namespace. Optional: Default to false.")
    public Boolean getHostIPC() {
        return this.hostIPC;
    }

    public void setHostIPC(@Nullable Boolean hostIPC) {
        this.hostIPC = hostIPC;
    }

    public V1PodSpec hostNetwork(@Nullable Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Host networking requested for this pod. Use the host's network namespace. When using HostNetwork you should specify ports so the scheduler is aware. When `hostNetwork` is true, specified `hostPort` fields in port definitions must match `containerPort`, and unspecified `hostPort` fields in port definitions are defaulted to match `containerPort`. Default to false.")
    public Boolean getHostNetwork() {
        return this.hostNetwork;
    }

    public void setHostNetwork(@Nullable Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
    }

    public V1PodSpec hostPID(@Nullable Boolean hostPID) {
        this.hostPID = hostPID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Use the host's pid namespace. Optional: Default to false.")
    public Boolean getHostPID() {
        return this.hostPID;
    }

    public void setHostPID(@Nullable Boolean hostPID) {
        this.hostPID = hostPID;
    }

    public V1PodSpec hostUsers(@Nullable Boolean hostUsers) {
        this.hostUsers = hostUsers;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Use the host's user namespace. Optional: Default to true. If set to true or not present, the pod will be run in the host user namespace, useful for when the pod needs a feature only available to the host user namespace, such as loading a kernel module with CAP_SYS_MODULE. When set to false, a new userns is created for the pod. Setting false is useful for mitigating container breakout vulnerabilities even allowing users to run their containers as root without actually having root privileges on the host. This field is alpha-level and is only honored by servers that enable the UserNamespacesSupport feature.")
    public Boolean getHostUsers() {
        return this.hostUsers;
    }

    public void setHostUsers(@Nullable Boolean hostUsers) {
        this.hostUsers = hostUsers;
    }

    public V1PodSpec hostname(@Nullable String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(@Nullable String hostname) {
        this.hostname = hostname;
    }

    public V1PodSpec hostnameOverride(@Nullable String hostnameOverride) {
        this.hostnameOverride = hostnameOverride;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HostnameOverride specifies an explicit override for the pod's hostname as perceived by the pod. This field only specifies the pod's hostname and does not affect its DNS records. When this field is set to a non-empty string: - It takes precedence over the values set in `hostname` and `subdomain`. - The Pod's hostname will be set to this value. - `setHostnameAsFQDN` must be nil or set to false. - `hostNetwork` must be set to false.  This field must be a valid DNS subdomain as defined in RFC 1123 and contain at most 64 characters. Requires the HostnameOverride feature gate to be enabled.")
    public String getHostnameOverride() {
        return this.hostnameOverride;
    }

    public void setHostnameOverride(@Nullable String hostnameOverride) {
        this.hostnameOverride = hostnameOverride;
    }

    public V1PodSpec imagePullSecrets(@Nullable List<V1LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
        return this;
    }

    public V1PodSpec addImagePullSecretsItem(V1LocalObjectReference imagePullSecretsItem) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<V1LocalObjectReference>();
        }
        this.imagePullSecrets.add(imagePullSecretsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod")
    public List<V1LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public void setImagePullSecrets(@Nullable List<V1LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    public V1PodSpec initContainers(@Nullable List<V1Container> initContainers) {
        this.initContainers = initContainers;
        return this;
    }

    public V1PodSpec addInitContainersItem(V1Container initContainersItem) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList<V1Container>();
        }
        this.initContainers.add(initContainersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added or removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/")
    public List<V1Container> getInitContainers() {
        return this.initContainers;
    }

    public void setInitContainers(@Nullable List<V1Container> initContainers) {
        this.initContainers = initContainers;
    }

    public V1PodSpec nodeName(@Nullable String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NodeName indicates in which node this pod is scheduled. If empty, this pod is a candidate for scheduling by the scheduler defined in schedulerName. Once this field is set, the kubelet for this node becomes responsible for the lifecycle of this pod. This field should not be used to express a desire for the pod to be scheduled on a specific node. https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#nodename")
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(@Nullable String nodeName) {
        this.nodeName = nodeName;
    }

    public V1PodSpec nodeSelector(@Nullable Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    public V1PodSpec putNodeSelectorItem(String key, String nodeSelectorItem) {
        if (this.nodeSelector == null) {
            this.nodeSelector = new HashMap<String, String>();
        }
        this.nodeSelector.put(key, nodeSelectorItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/")
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(@Nullable Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public V1PodSpec os(@Nullable V1PodOS os) {
        this.os = os;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1PodOS getOs() {
        return this.os;
    }

    public void setOs(@Nullable V1PodOS os) {
        this.os = os;
    }

    public V1PodSpec overhead(@Nullable Map<String, Quantity> overhead) {
        this.overhead = overhead;
        return this;
    }

    public V1PodSpec putOverheadItem(String key, Quantity overheadItem) {
        if (this.overhead == null) {
            this.overhead = new HashMap<String, Quantity>();
        }
        this.overhead.put(key, overheadItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Overhead represents the resource overhead associated with running a pod for a given RuntimeClass. This field will be autopopulated at admission time by the RuntimeClass admission controller. If the RuntimeClass admission controller is enabled, overhead must not be set in Pod create requests. The RuntimeClass admission controller will reject Pod create requests which have the overhead already set. If RuntimeClass is configured and selected in the PodSpec, Overhead will be set to the value defined in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero. More info: https://git.k8s.io/enhancements/keps/sig-node/688-pod-overhead/README.md")
    public Map<String, Quantity> getOverhead() {
        return this.overhead;
    }

    public void setOverhead(@Nullable Map<String, Quantity> overhead) {
        this.overhead = overhead;
    }

    public V1PodSpec preemptionPolicy(@Nullable String preemptionPolicy) {
        this.preemptionPolicy = preemptionPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PreemptionPolicy is the Policy for preempting pods with lower priority. One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset.")
    public String getPreemptionPolicy() {
        return this.preemptionPolicy;
    }

    public void setPreemptionPolicy(@Nullable String preemptionPolicy) {
        this.preemptionPolicy = preemptionPolicy;
    }

    public V1PodSpec priority(@Nullable Integer priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The priority value. Various system components use this field to find the priority of the pod. When Priority Admission Controller is enabled, it prevents users from setting this field. The admission controller populates this field from PriorityClassName. The higher the value, the higher the priority.")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(@Nullable Integer priority) {
        this.priority = priority;
    }

    public V1PodSpec priorityClassName(@Nullable String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, indicates the pod's priority. \"system-node-critical\" and \"system-cluster-critical\" are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.")
    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    public void setPriorityClassName(@Nullable String priorityClassName) {
        this.priorityClassName = priorityClassName;
    }

    public V1PodSpec readinessGates(@Nullable List<V1PodReadinessGate> readinessGates) {
        this.readinessGates = readinessGates;
        return this;
    }

    public V1PodSpec addReadinessGatesItem(V1PodReadinessGate readinessGatesItem) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList<V1PodReadinessGate>();
        }
        this.readinessGates.add(readinessGatesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, all readiness gates will be evaluated for pod readiness. A pod is ready when all its containers are ready AND all conditions specified in the readiness gates have status equal to \"True\" More info: https://git.k8s.io/enhancements/keps/sig-network/580-pod-readiness-gates")
    public List<V1PodReadinessGate> getReadinessGates() {
        return this.readinessGates;
    }

    public void setReadinessGates(@Nullable List<V1PodReadinessGate> readinessGates) {
        this.readinessGates = readinessGates;
    }

    public V1PodSpec resourceClaims(@Nullable List<V1PodResourceClaim> resourceClaims) {
        this.resourceClaims = resourceClaims;
        return this;
    }

    public V1PodSpec addResourceClaimsItem(V1PodResourceClaim resourceClaimsItem) {
        if (this.resourceClaims == null) {
            this.resourceClaims = new ArrayList<V1PodResourceClaim>();
        }
        this.resourceClaims.add(resourceClaimsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceClaims defines which ResourceClaims must be allocated and reserved before the Pod is allowed to start. The resources will be made available to those containers which consume them by name.  This is an alpha field and requires enabling the DynamicResourceAllocation feature gate.  This field is immutable.")
    public List<V1PodResourceClaim> getResourceClaims() {
        return this.resourceClaims;
    }

    public void setResourceClaims(@Nullable List<V1PodResourceClaim> resourceClaims) {
        this.resourceClaims = resourceClaims;
    }

    public V1PodSpec resources(@Nullable V1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(@Nullable V1ResourceRequirements resources) {
        this.resources = resources;
    }

    public V1PodSpec restartPolicy(@Nullable String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restart policy for all containers within the pod. One of Always, OnFailure, Never. In some contexts, only a subset of those values may be permitted. Default to Always. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy")
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(@Nullable String restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public V1PodSpec runtimeClassName(@Nullable String runtimeClassName) {
        this.runtimeClassName = runtimeClassName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group, which should be used to run this pod.  If no RuntimeClass resource matches the named class, the pod will not be run. If unset or empty, the \"legacy\" RuntimeClass will be used, which is an implicit class with an empty definition that uses the default runtime handler. More info: https://git.k8s.io/enhancements/keps/sig-node/585-runtime-class")
    public String getRuntimeClassName() {
        return this.runtimeClassName;
    }

    public void setRuntimeClassName(@Nullable String runtimeClassName) {
        this.runtimeClassName = runtimeClassName;
    }

    public V1PodSpec schedulerName(@Nullable String schedulerName) {
        this.schedulerName = schedulerName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, the pod will be dispatched by specified scheduler. If not specified, the pod will be dispatched by default scheduler.")
    public String getSchedulerName() {
        return this.schedulerName;
    }

    public void setSchedulerName(@Nullable String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public V1PodSpec schedulingGates(@Nullable List<V1PodSchedulingGate> schedulingGates) {
        this.schedulingGates = schedulingGates;
        return this;
    }

    public V1PodSpec addSchedulingGatesItem(V1PodSchedulingGate schedulingGatesItem) {
        if (this.schedulingGates == null) {
            this.schedulingGates = new ArrayList<V1PodSchedulingGate>();
        }
        this.schedulingGates.add(schedulingGatesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SchedulingGates is an opaque list of values that if specified will block scheduling the pod. If schedulingGates is not empty, the pod will stay in the SchedulingGated state and the scheduler will not attempt to schedule the pod.  SchedulingGates can only be set at pod creation time, and be removed only afterwards.")
    public List<V1PodSchedulingGate> getSchedulingGates() {
        return this.schedulingGates;
    }

    public void setSchedulingGates(@Nullable List<V1PodSchedulingGate> schedulingGates) {
        this.schedulingGates = schedulingGates;
    }

    public V1PodSpec securityContext(@Nullable V1PodSecurityContext securityContext) {
        this.securityContext = securityContext;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1PodSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(@Nullable V1PodSecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public V1PodSpec serviceAccount(@Nullable String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DeprecatedServiceAccount is a deprecated alias for ServiceAccountName. Deprecated: Use serviceAccountName instead.")
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public void setServiceAccount(@Nullable String serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public V1PodSpec serviceAccountName(@Nullable String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/")
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public void setServiceAccountName(@Nullable String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
    }

    public V1PodSpec setHostnameAsFQDN(@Nullable Boolean setHostnameAsFQDN) {
        this.setHostnameAsFQDN = setHostnameAsFQDN;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default). In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname). In Windows containers, this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\\\\SYSTEM\\\\CurrentControlSet\\\\Services\\\\Tcpip\\\\Parameters to FQDN. If a pod does not have FQDN, this has no effect. Default to false.")
    public Boolean getSetHostnameAsFQDN() {
        return this.setHostnameAsFQDN;
    }

    public void setSetHostnameAsFQDN(@Nullable Boolean setHostnameAsFQDN) {
        this.setHostnameAsFQDN = setHostnameAsFQDN;
    }

    public V1PodSpec shareProcessNamespace(@Nullable Boolean shareProcessNamespace) {
        this.shareProcessNamespace = shareProcessNamespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Share a single process namespace between all of the containers in a pod. When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Default to false.")
    public Boolean getShareProcessNamespace() {
        return this.shareProcessNamespace;
    }

    public void setShareProcessNamespace(@Nullable Boolean shareProcessNamespace) {
        this.shareProcessNamespace = shareProcessNamespace;
    }

    public V1PodSpec subdomain(@Nullable String subdomain) {
        this.subdomain = subdomain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, the fully qualified Pod hostname will be \"<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>\". If not specified, the pod will not have a domainname at all.")
    public String getSubdomain() {
        return this.subdomain;
    }

    public void setSubdomain(@Nullable String subdomain) {
        this.subdomain = subdomain;
    }

    public V1PodSpec terminationGracePeriodSeconds(@Nullable Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 30 seconds.")
    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public void setTerminationGracePeriodSeconds(@Nullable Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
    }

    public V1PodSpec tolerations(@Nullable List<V1Toleration> tolerations) {
        this.tolerations = tolerations;
        return this;
    }

    public V1PodSpec addTolerationsItem(V1Toleration tolerationsItem) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1Toleration>();
        }
        this.tolerations.add(tolerationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, the pod's tolerations.")
    public List<V1Toleration> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(@Nullable List<V1Toleration> tolerations) {
        this.tolerations = tolerations;
    }

    public V1PodSpec topologySpreadConstraints(@Nullable List<V1TopologySpreadConstraint> topologySpreadConstraints) {
        this.topologySpreadConstraints = topologySpreadConstraints;
        return this;
    }

    public V1PodSpec addTopologySpreadConstraintsItem(V1TopologySpreadConstraint topologySpreadConstraintsItem) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<V1TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.add(topologySpreadConstraintsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="TopologySpreadConstraints describes how a group of pods ought to spread across topology domains. Scheduler will schedule pods in a way which abides by the constraints. All topologySpreadConstraints are ANDed.")
    public List<V1TopologySpreadConstraint> getTopologySpreadConstraints() {
        return this.topologySpreadConstraints;
    }

    public void setTopologySpreadConstraints(@Nullable List<V1TopologySpreadConstraint> topologySpreadConstraints) {
        this.topologySpreadConstraints = topologySpreadConstraints;
    }

    public V1PodSpec volumes(@Nullable List<V1Volume> volumes) {
        this.volumes = volumes;
        return this;
    }

    public V1PodSpec addVolumesItem(V1Volume volumesItem) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<V1Volume>();
        }
        this.volumes.add(volumesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes")
    public List<V1Volume> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(@Nullable List<V1Volume> volumes) {
        this.volumes = volumes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodSpec v1PodSpec = (V1PodSpec)o;
        return Objects.equals(this.activeDeadlineSeconds, v1PodSpec.activeDeadlineSeconds) && Objects.equals(this.affinity, v1PodSpec.affinity) && Objects.equals(this.automountServiceAccountToken, v1PodSpec.automountServiceAccountToken) && Objects.equals(this.containers, v1PodSpec.containers) && Objects.equals(this.dnsConfig, v1PodSpec.dnsConfig) && Objects.equals(this.dnsPolicy, v1PodSpec.dnsPolicy) && Objects.equals(this.enableServiceLinks, v1PodSpec.enableServiceLinks) && Objects.equals(this.ephemeralContainers, v1PodSpec.ephemeralContainers) && Objects.equals(this.hostAliases, v1PodSpec.hostAliases) && Objects.equals(this.hostIPC, v1PodSpec.hostIPC) && Objects.equals(this.hostNetwork, v1PodSpec.hostNetwork) && Objects.equals(this.hostPID, v1PodSpec.hostPID) && Objects.equals(this.hostUsers, v1PodSpec.hostUsers) && Objects.equals(this.hostname, v1PodSpec.hostname) && Objects.equals(this.hostnameOverride, v1PodSpec.hostnameOverride) && Objects.equals(this.imagePullSecrets, v1PodSpec.imagePullSecrets) && Objects.equals(this.initContainers, v1PodSpec.initContainers) && Objects.equals(this.nodeName, v1PodSpec.nodeName) && Objects.equals(this.nodeSelector, v1PodSpec.nodeSelector) && Objects.equals(this.os, v1PodSpec.os) && Objects.equals(this.overhead, v1PodSpec.overhead) && Objects.equals(this.preemptionPolicy, v1PodSpec.preemptionPolicy) && Objects.equals(this.priority, v1PodSpec.priority) && Objects.equals(this.priorityClassName, v1PodSpec.priorityClassName) && Objects.equals(this.readinessGates, v1PodSpec.readinessGates) && Objects.equals(this.resourceClaims, v1PodSpec.resourceClaims) && Objects.equals(this.resources, v1PodSpec.resources) && Objects.equals(this.restartPolicy, v1PodSpec.restartPolicy) && Objects.equals(this.runtimeClassName, v1PodSpec.runtimeClassName) && Objects.equals(this.schedulerName, v1PodSpec.schedulerName) && Objects.equals(this.schedulingGates, v1PodSpec.schedulingGates) && Objects.equals(this.securityContext, v1PodSpec.securityContext) && Objects.equals(this.serviceAccount, v1PodSpec.serviceAccount) && Objects.equals(this.serviceAccountName, v1PodSpec.serviceAccountName) && Objects.equals(this.setHostnameAsFQDN, v1PodSpec.setHostnameAsFQDN) && Objects.equals(this.shareProcessNamespace, v1PodSpec.shareProcessNamespace) && Objects.equals(this.subdomain, v1PodSpec.subdomain) && Objects.equals(this.terminationGracePeriodSeconds, v1PodSpec.terminationGracePeriodSeconds) && Objects.equals(this.tolerations, v1PodSpec.tolerations) && Objects.equals(this.topologySpreadConstraints, v1PodSpec.topologySpreadConstraints) && Objects.equals(this.volumes, v1PodSpec.volumes);
    }

    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.affinity, this.automountServiceAccountToken, this.containers, this.dnsConfig, this.dnsPolicy, this.enableServiceLinks, this.ephemeralContainers, this.hostAliases, this.hostIPC, this.hostNetwork, this.hostPID, this.hostUsers, this.hostname, this.hostnameOverride, this.imagePullSecrets, this.initContainers, this.nodeName, this.nodeSelector, this.os, this.overhead, this.preemptionPolicy, this.priority, this.priorityClassName, this.readinessGates, this.resourceClaims, this.resources, this.restartPolicy, this.runtimeClassName, this.schedulerName, this.schedulingGates, this.securityContext, this.serviceAccount, this.serviceAccountName, this.setHostnameAsFQDN, this.shareProcessNamespace, this.subdomain, this.terminationGracePeriodSeconds, this.tolerations, this.topologySpreadConstraints, this.volumes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodSpec {\n");
        sb.append("    activeDeadlineSeconds: ").append(this.toIndentedString(this.activeDeadlineSeconds)).append("\n");
        sb.append("    affinity: ").append(this.toIndentedString(this.affinity)).append("\n");
        sb.append("    automountServiceAccountToken: ").append(this.toIndentedString(this.automountServiceAccountToken)).append("\n");
        sb.append("    containers: ").append(this.toIndentedString(this.containers)).append("\n");
        sb.append("    dnsConfig: ").append(this.toIndentedString(this.dnsConfig)).append("\n");
        sb.append("    dnsPolicy: ").append(this.toIndentedString(this.dnsPolicy)).append("\n");
        sb.append("    enableServiceLinks: ").append(this.toIndentedString(this.enableServiceLinks)).append("\n");
        sb.append("    ephemeralContainers: ").append(this.toIndentedString(this.ephemeralContainers)).append("\n");
        sb.append("    hostAliases: ").append(this.toIndentedString(this.hostAliases)).append("\n");
        sb.append("    hostIPC: ").append(this.toIndentedString(this.hostIPC)).append("\n");
        sb.append("    hostNetwork: ").append(this.toIndentedString(this.hostNetwork)).append("\n");
        sb.append("    hostPID: ").append(this.toIndentedString(this.hostPID)).append("\n");
        sb.append("    hostUsers: ").append(this.toIndentedString(this.hostUsers)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    hostnameOverride: ").append(this.toIndentedString(this.hostnameOverride)).append("\n");
        sb.append("    imagePullSecrets: ").append(this.toIndentedString(this.imagePullSecrets)).append("\n");
        sb.append("    initContainers: ").append(this.toIndentedString(this.initContainers)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    nodeSelector: ").append(this.toIndentedString(this.nodeSelector)).append("\n");
        sb.append("    os: ").append(this.toIndentedString(this.os)).append("\n");
        sb.append("    overhead: ").append(this.toIndentedString(this.overhead)).append("\n");
        sb.append("    preemptionPolicy: ").append(this.toIndentedString(this.preemptionPolicy)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    priorityClassName: ").append(this.toIndentedString(this.priorityClassName)).append("\n");
        sb.append("    readinessGates: ").append(this.toIndentedString(this.readinessGates)).append("\n");
        sb.append("    resourceClaims: ").append(this.toIndentedString(this.resourceClaims)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    restartPolicy: ").append(this.toIndentedString(this.restartPolicy)).append("\n");
        sb.append("    runtimeClassName: ").append(this.toIndentedString(this.runtimeClassName)).append("\n");
        sb.append("    schedulerName: ").append(this.toIndentedString(this.schedulerName)).append("\n");
        sb.append("    schedulingGates: ").append(this.toIndentedString(this.schedulingGates)).append("\n");
        sb.append("    securityContext: ").append(this.toIndentedString(this.securityContext)).append("\n");
        sb.append("    serviceAccount: ").append(this.toIndentedString(this.serviceAccount)).append("\n");
        sb.append("    serviceAccountName: ").append(this.toIndentedString(this.serviceAccountName)).append("\n");
        sb.append("    setHostnameAsFQDN: ").append(this.toIndentedString(this.setHostnameAsFQDN)).append("\n");
        sb.append("    shareProcessNamespace: ").append(this.toIndentedString(this.shareProcessNamespace)).append("\n");
        sb.append("    subdomain: ").append(this.toIndentedString(this.subdomain)).append("\n");
        sb.append("    terminationGracePeriodSeconds: ").append(this.toIndentedString(this.terminationGracePeriodSeconds)).append("\n");
        sb.append("    tolerations: ").append(this.toIndentedString(this.tolerations)).append("\n");
        sb.append("    topologySpreadConstraints: ").append(this.toIndentedString(this.topologySpreadConstraints)).append("\n");
        sb.append("    volumes: ").append(this.toIndentedString(this.volumes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayvolumes;
        JsonArray jsonArraytopologySpreadConstraints;
        JsonArray jsonArraytolerations;
        JsonArray jsonArrayschedulingGates;
        JsonArray jsonArrayresourceClaims;
        JsonArray jsonArrayreadinessGates;
        JsonArray jsonArrayinitContainers;
        JsonArray jsonArrayimagePullSecrets;
        JsonArray jsonArrayhostAliases;
        int i;
        JsonArray jsonArrayephemeralContainers;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1PodSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1PodSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_AFFINITY) != null && !jsonObj.get(SERIALIZED_NAME_AFFINITY).isJsonNull()) {
            V1Affinity.validateJsonElement(jsonObj.get(SERIALIZED_NAME_AFFINITY));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CONTAINERS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `containers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINERS).toString()));
        }
        JsonArray jsonArraycontainers = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONTAINERS);
        for (int i2 = 0; i2 < jsonArraycontainers.size(); ++i2) {
            V1Container.validateJsonElement(jsonArraycontainers.get(i2));
        }
        if (jsonObj.get(SERIALIZED_NAME_DNS_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_DNS_CONFIG).isJsonNull()) {
            V1PodDNSConfig.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DNS_CONFIG));
        }
        if (jsonObj.get(SERIALIZED_NAME_DNS_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_DNS_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DNS_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `dnsPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DNS_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EPHEMERAL_CONTAINERS) != null && !jsonObj.get(SERIALIZED_NAME_EPHEMERAL_CONTAINERS).isJsonNull() && (jsonArrayephemeralContainers = jsonObj.getAsJsonArray(SERIALIZED_NAME_EPHEMERAL_CONTAINERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_EPHEMERAL_CONTAINERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `ephemeralContainers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EPHEMERAL_CONTAINERS).toString()));
            }
            for (i = 0; i < jsonArrayephemeralContainers.size(); ++i) {
                V1EphemeralContainer.validateJsonElement(jsonArrayephemeralContainers.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_HOST_ALIASES) != null && !jsonObj.get(SERIALIZED_NAME_HOST_ALIASES).isJsonNull() && (jsonArrayhostAliases = jsonObj.getAsJsonArray(SERIALIZED_NAME_HOST_ALIASES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_HOST_ALIASES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `hostAliases` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOST_ALIASES).toString()));
            }
            for (i = 0; i < jsonArrayhostAliases.size(); ++i) {
                V1HostAlias.validateJsonElement(jsonArrayhostAliases.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTNAME) != null && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostname` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTNAME_OVERRIDE) != null && !jsonObj.get(SERIALIZED_NAME_HOSTNAME_OVERRIDE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTNAME_OVERRIDE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostnameOverride` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTNAME_OVERRIDE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_PULL_SECRETS) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_PULL_SECRETS).isJsonNull() && (jsonArrayimagePullSecrets = jsonObj.getAsJsonArray(SERIALIZED_NAME_IMAGE_PULL_SECRETS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_IMAGE_PULL_SECRETS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `imagePullSecrets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_PULL_SECRETS).toString()));
            }
            for (i = 0; i < jsonArrayimagePullSecrets.size(); ++i) {
                V1LocalObjectReference.validateJsonElement(jsonArrayimagePullSecrets.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_INIT_CONTAINERS) != null && !jsonObj.get(SERIALIZED_NAME_INIT_CONTAINERS).isJsonNull() && (jsonArrayinitContainers = jsonObj.getAsJsonArray(SERIALIZED_NAME_INIT_CONTAINERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_INIT_CONTAINERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `initContainers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INIT_CONTAINERS).toString()));
            }
            for (i = 0; i < jsonArrayinitContainers.size(); ++i) {
                V1Container.validateJsonElement(jsonArrayinitContainers.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_NODE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NODE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NODE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `nodeName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NODE_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OS) != null && !jsonObj.get(SERIALIZED_NAME_OS).isJsonNull()) {
            V1PodOS.validateJsonElement(jsonObj.get(SERIALIZED_NAME_OS));
        }
        if (jsonObj.get(SERIALIZED_NAME_PREEMPTION_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_PREEMPTION_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PREEMPTION_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `preemptionPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PREEMPTION_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRIORITY_CLASS_NAME) != null && !jsonObj.get(SERIALIZED_NAME_PRIORITY_CLASS_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PRIORITY_CLASS_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `priorityClassName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRIORITY_CLASS_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_READINESS_GATES) != null && !jsonObj.get(SERIALIZED_NAME_READINESS_GATES).isJsonNull() && (jsonArrayreadinessGates = jsonObj.getAsJsonArray(SERIALIZED_NAME_READINESS_GATES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_READINESS_GATES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `readinessGates` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_READINESS_GATES).toString()));
            }
            for (i = 0; i < jsonArrayreadinessGates.size(); ++i) {
                V1PodReadinessGate.validateJsonElement(jsonArrayreadinessGates.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIMS) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIMS).isJsonNull() && (jsonArrayresourceClaims = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESOURCE_CLAIMS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `resourceClaims` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIMS).toString()));
            }
            for (i = 0; i < jsonArrayresourceClaims.size(); ++i) {
                V1PodResourceClaim.validateJsonElement(jsonArrayresourceClaims.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonNull()) {
            V1ResourceRequirements.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESOURCES));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESTART_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `restartPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RUNTIME_CLASS_NAME) != null && !jsonObj.get(SERIALIZED_NAME_RUNTIME_CLASS_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RUNTIME_CLASS_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `runtimeClassName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RUNTIME_CLASS_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCHEDULER_NAME) != null && !jsonObj.get(SERIALIZED_NAME_SCHEDULER_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SCHEDULER_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `schedulerName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCHEDULER_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCHEDULING_GATES) != null && !jsonObj.get(SERIALIZED_NAME_SCHEDULING_GATES).isJsonNull() && (jsonArrayschedulingGates = jsonObj.getAsJsonArray(SERIALIZED_NAME_SCHEDULING_GATES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SCHEDULING_GATES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `schedulingGates` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCHEDULING_GATES).toString()));
            }
            for (i = 0; i < jsonArrayschedulingGates.size(); ++i) {
                V1PodSchedulingGate.validateJsonElement(jsonArrayschedulingGates.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SECURITY_CONTEXT) != null && !jsonObj.get(SERIALIZED_NAME_SECURITY_CONTEXT).isJsonNull()) {
            V1PodSecurityContext.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SECURITY_CONTEXT));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERVICE_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_SERVICE_ACCOUNT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SERVICE_ACCOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `serviceAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERVICE_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERVICE_ACCOUNT_NAME) != null && !jsonObj.get(SERIALIZED_NAME_SERVICE_ACCOUNT_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SERVICE_ACCOUNT_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `serviceAccountName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERVICE_ACCOUNT_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUBDOMAIN) != null && !jsonObj.get(SERIALIZED_NAME_SUBDOMAIN).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SUBDOMAIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subdomain` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUBDOMAIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TOLERATIONS) != null && !jsonObj.get(SERIALIZED_NAME_TOLERATIONS).isJsonNull() && (jsonArraytolerations = jsonObj.getAsJsonArray(SERIALIZED_NAME_TOLERATIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TOLERATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `tolerations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOLERATIONS).toString()));
            }
            for (i = 0; i < jsonArraytolerations.size(); ++i) {
                V1Toleration.validateJsonElement(jsonArraytolerations.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TOPOLOGY_SPREAD_CONSTRAINTS) != null && !jsonObj.get(SERIALIZED_NAME_TOPOLOGY_SPREAD_CONSTRAINTS).isJsonNull() && (jsonArraytopologySpreadConstraints = jsonObj.getAsJsonArray(SERIALIZED_NAME_TOPOLOGY_SPREAD_CONSTRAINTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TOPOLOGY_SPREAD_CONSTRAINTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `topologySpreadConstraints` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TOPOLOGY_SPREAD_CONSTRAINTS).toString()));
            }
            for (i = 0; i < jsonArraytopologySpreadConstraints.size(); ++i) {
                V1TopologySpreadConstraint.validateJsonElement(jsonArraytopologySpreadConstraints.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES).isJsonNull() && (jsonArrayvolumes = jsonObj.getAsJsonArray(SERIALIZED_NAME_VOLUMES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VOLUMES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `volumes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES).toString()));
            }
            for (i = 0; i < jsonArrayvolumes.size(); ++i) {
                V1Volume.validateJsonElement(jsonArrayvolumes.get(i));
            }
        }
    }

    public static V1PodSpec fromJson(String jsonString) throws IOException {
        return (V1PodSpec)JSON.getGson().fromJson(jsonString, V1PodSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACTIVE_DEADLINE_SECONDS);
        openapiFields.add(SERIALIZED_NAME_AFFINITY);
        openapiFields.add(SERIALIZED_NAME_AUTOMOUNT_SERVICE_ACCOUNT_TOKEN);
        openapiFields.add(SERIALIZED_NAME_CONTAINERS);
        openapiFields.add(SERIALIZED_NAME_DNS_CONFIG);
        openapiFields.add(SERIALIZED_NAME_DNS_POLICY);
        openapiFields.add(SERIALIZED_NAME_ENABLE_SERVICE_LINKS);
        openapiFields.add(SERIALIZED_NAME_EPHEMERAL_CONTAINERS);
        openapiFields.add(SERIALIZED_NAME_HOST_ALIASES);
        openapiFields.add(SERIALIZED_NAME_HOST_I_P_C);
        openapiFields.add(SERIALIZED_NAME_HOST_NETWORK);
        openapiFields.add(SERIALIZED_NAME_HOST_P_I_D);
        openapiFields.add(SERIALIZED_NAME_HOST_USERS);
        openapiFields.add(SERIALIZED_NAME_HOSTNAME);
        openapiFields.add(SERIALIZED_NAME_HOSTNAME_OVERRIDE);
        openapiFields.add(SERIALIZED_NAME_IMAGE_PULL_SECRETS);
        openapiFields.add(SERIALIZED_NAME_INIT_CONTAINERS);
        openapiFields.add(SERIALIZED_NAME_NODE_NAME);
        openapiFields.add(SERIALIZED_NAME_NODE_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_OS);
        openapiFields.add(SERIALIZED_NAME_OVERHEAD);
        openapiFields.add(SERIALIZED_NAME_PREEMPTION_POLICY);
        openapiFields.add(SERIALIZED_NAME_PRIORITY);
        openapiFields.add(SERIALIZED_NAME_PRIORITY_CLASS_NAME);
        openapiFields.add(SERIALIZED_NAME_READINESS_GATES);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_CLAIMS);
        openapiFields.add(SERIALIZED_NAME_RESOURCES);
        openapiFields.add(SERIALIZED_NAME_RESTART_POLICY);
        openapiFields.add(SERIALIZED_NAME_RUNTIME_CLASS_NAME);
        openapiFields.add(SERIALIZED_NAME_SCHEDULER_NAME);
        openapiFields.add(SERIALIZED_NAME_SCHEDULING_GATES);
        openapiFields.add(SERIALIZED_NAME_SECURITY_CONTEXT);
        openapiFields.add(SERIALIZED_NAME_SERVICE_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_SERVICE_ACCOUNT_NAME);
        openapiFields.add(SERIALIZED_NAME_SET_HOSTNAME_AS_F_Q_D_N);
        openapiFields.add(SERIALIZED_NAME_SHARE_PROCESS_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_SUBDOMAIN);
        openapiFields.add(SERIALIZED_NAME_TERMINATION_GRACE_PERIOD_SECONDS);
        openapiFields.add(SERIALIZED_NAME_TOLERATIONS);
        openapiFields.add(SERIALIZED_NAME_TOPOLOGY_SPREAD_CONSTRAINTS);
        openapiFields.add(SERIALIZED_NAME_VOLUMES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CONTAINERS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1PodSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1PodSpec.class));
            return new TypeAdapter<V1PodSpec>(){

                public void write(JsonWriter out, V1PodSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1PodSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1PodSpec.validateJsonElement(jsonElement);
                    return (V1PodSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

