/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1Deployment;
import io.kubernetes.client.models.V1DeploymentBuilder;
import io.kubernetes.client.models.V1DeploymentFluentImpl;
import io.kubernetes.client.models.V1DeploymentList;
import io.kubernetes.client.models.V1DeploymentListFluent;
import io.kubernetes.client.models.V1ListMeta;
import io.kubernetes.client.models.V1ListMetaBuilder;
import io.kubernetes.client.models.V1ListMetaFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1DeploymentListFluentImpl<A extends V1DeploymentListFluent<A>>
extends BaseFluent<A>
implements V1DeploymentListFluent<A> {
    private String apiVersion;
    private List<V1DeploymentBuilder> items;
    private String kind;
    private V1ListMetaBuilder metadata;

    public V1DeploymentListFluentImpl() {
    }

    public V1DeploymentListFluentImpl(V1DeploymentList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(int index, V1Deployment item) {
        if (this.items == null) {
            this.items = new ArrayList<V1DeploymentBuilder>();
        }
        V1DeploymentBuilder builder = new V1DeploymentBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, V1Deployment item) {
        if (this.items == null) {
            this.items = new ArrayList<V1DeploymentBuilder>();
        }
        V1DeploymentBuilder builder = new V1DeploymentBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(V1Deployment ... items) {
        if (this.items == null) {
            this.items = new ArrayList<V1DeploymentBuilder>();
        }
        for (V1Deployment item : items) {
            V1DeploymentBuilder builder = new V1DeploymentBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<V1Deployment> items) {
        if (this.items == null) {
            this.items = new ArrayList<V1DeploymentBuilder>();
        }
        for (V1Deployment item : items) {
            V1DeploymentBuilder builder = new V1DeploymentBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(V1Deployment ... items) {
        for (V1Deployment item : items) {
            V1DeploymentBuilder builder = new V1DeploymentBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<V1Deployment> items) {
        for (V1Deployment item : items) {
            V1DeploymentBuilder builder = new V1DeploymentBuilder(item);
            this._visitables.remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1Deployment> getItems() {
        return V1DeploymentListFluentImpl.build(this.items);
    }

    @Override
    public List<V1Deployment> buildItems() {
        return V1DeploymentListFluentImpl.build(this.items);
    }

    @Override
    public V1Deployment buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public V1Deployment buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public V1Deployment buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public V1Deployment buildMatchingItem(Predicate<V1DeploymentBuilder> predicate) {
        for (V1DeploymentBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withItems(List<V1Deployment> items) {
        if (this.items != null) {
            this._visitables.removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<V1DeploymentBuilder>();
            for (V1Deployment item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(V1Deployment ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (V1Deployment item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public V1DeploymentListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public V1DeploymentListFluent.ItemsNested<A> addNewItemLike(V1Deployment item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public V1DeploymentListFluent.ItemsNested<A> setNewItemLike(int index, V1Deployment item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public V1DeploymentListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public V1DeploymentListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public V1DeploymentListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public V1DeploymentListFluent.ItemsNested<A> editMatchingItem(Predicate<V1DeploymentBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply(this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ListMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ListMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ListMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1DeploymentListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1DeploymentListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1DeploymentListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1DeploymentListFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ListMetaBuilder().build());
    }

    @Override
    public V1DeploymentListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1DeploymentListFluentImpl that = (V1DeploymentListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends V1ListMetaFluentImpl<V1DeploymentListFluent.MetadataNested<N>>
    implements V1DeploymentListFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ListMetaBuilder builder;

        MetadataNestedImpl(V1ListMeta item) {
            this.builder = new V1ListMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ListMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1DeploymentListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends V1DeploymentFluentImpl<V1DeploymentListFluent.ItemsNested<N>>
    implements V1DeploymentListFluent.ItemsNested<N>,
    Nested<N> {
        private final V1DeploymentBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, V1Deployment item) {
            this.index = index;
            this.builder = new V1DeploymentBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new V1DeploymentBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1DeploymentListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

