package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Fluent;
import java.util.Collection;

public interface ExtensionsV1beta1PodSecurityPolicySpecFluent<A extends ExtensionsV1beta1PodSecurityPolicySpecFluent<A>> extends Fluent<A>{


    public Boolean isAllowPrivilegeEscalation();
    public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation);
    public Boolean hasAllowPrivilegeEscalation();
    public A withNewAllowPrivilegeEscalation(boolean arg1);
    public A withNewAllowPrivilegeEscalation(String arg1);
    public A addToAllowedCapabilities(int index,String item);
    public A setToAllowedCapabilities(int index,String item);
    public A addToAllowedCapabilities(String... items);
    public A addAllToAllowedCapabilities(Collection<String> items);
    public A removeFromAllowedCapabilities(String... items);
    public A removeAllFromAllowedCapabilities(Collection<String> items);
    public List<String> getAllowedCapabilities();
    public String getAllowedCapability(int index);
    public String getFirstAllowedCapability();
    public String getLastAllowedCapability();
    public String getMatchingAllowedCapability(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withAllowedCapabilities(List<String> allowedCapabilities);
    public A withAllowedCapabilities(String... allowedCapabilities);
    public Boolean hasAllowedCapabilities();
    public A addToAllowedFlexVolumes(int index,ExtensionsV1beta1AllowedFlexVolume item);
    public A setToAllowedFlexVolumes(int index,ExtensionsV1beta1AllowedFlexVolume item);
    public A addToAllowedFlexVolumes(ExtensionsV1beta1AllowedFlexVolume... items);
    public A addAllToAllowedFlexVolumes(Collection<ExtensionsV1beta1AllowedFlexVolume> items);
    public A removeFromAllowedFlexVolumes(ExtensionsV1beta1AllowedFlexVolume... items);
    public A removeAllFromAllowedFlexVolumes(Collection<ExtensionsV1beta1AllowedFlexVolume> items);
    
/**
 * This method has been deprecated, please use method buildAllowedFlexVolumes instead.
 * @return The buildable object.
 */
@Deprecated public List<ExtensionsV1beta1AllowedFlexVolume> getAllowedFlexVolumes();
    public List<ExtensionsV1beta1AllowedFlexVolume> buildAllowedFlexVolumes();
    public ExtensionsV1beta1AllowedFlexVolume buildAllowedFlexVolume(int index);
    public ExtensionsV1beta1AllowedFlexVolume buildFirstAllowedFlexVolume();
    public ExtensionsV1beta1AllowedFlexVolume buildLastAllowedFlexVolume();
    public ExtensionsV1beta1AllowedFlexVolume buildMatchingAllowedFlexVolume(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1AllowedFlexVolumeBuilder> predicate);
    public A withAllowedFlexVolumes(List<ExtensionsV1beta1AllowedFlexVolume> allowedFlexVolumes);
    public A withAllowedFlexVolumes(ExtensionsV1beta1AllowedFlexVolume... allowedFlexVolumes);
    public Boolean hasAllowedFlexVolumes();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolume();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> addNewAllowedFlexVolumeLike(ExtensionsV1beta1AllowedFlexVolume item);
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> setNewAllowedFlexVolumeLike(int index,ExtensionsV1beta1AllowedFlexVolume item);
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editAllowedFlexVolume(int index);
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editFirstAllowedFlexVolume();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editLastAllowedFlexVolume();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<A> editMatchingAllowedFlexVolume(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1AllowedFlexVolumeBuilder> predicate);
    public A addToAllowedHostPaths(int index,ExtensionsV1beta1AllowedHostPath item);
    public A setToAllowedHostPaths(int index,ExtensionsV1beta1AllowedHostPath item);
    public A addToAllowedHostPaths(ExtensionsV1beta1AllowedHostPath... items);
    public A addAllToAllowedHostPaths(Collection<ExtensionsV1beta1AllowedHostPath> items);
    public A removeFromAllowedHostPaths(ExtensionsV1beta1AllowedHostPath... items);
    public A removeAllFromAllowedHostPaths(Collection<ExtensionsV1beta1AllowedHostPath> items);
    
/**
 * This method has been deprecated, please use method buildAllowedHostPaths instead.
 * @return The buildable object.
 */
@Deprecated public List<ExtensionsV1beta1AllowedHostPath> getAllowedHostPaths();
    public List<ExtensionsV1beta1AllowedHostPath> buildAllowedHostPaths();
    public ExtensionsV1beta1AllowedHostPath buildAllowedHostPath(int index);
    public ExtensionsV1beta1AllowedHostPath buildFirstAllowedHostPath();
    public ExtensionsV1beta1AllowedHostPath buildLastAllowedHostPath();
    public ExtensionsV1beta1AllowedHostPath buildMatchingAllowedHostPath(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1AllowedHostPathBuilder> predicate);
    public A withAllowedHostPaths(List<ExtensionsV1beta1AllowedHostPath> allowedHostPaths);
    public A withAllowedHostPaths(ExtensionsV1beta1AllowedHostPath... allowedHostPaths);
    public Boolean hasAllowedHostPaths();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> addNewAllowedHostPath();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> addNewAllowedHostPathLike(ExtensionsV1beta1AllowedHostPath item);
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> setNewAllowedHostPathLike(int index,ExtensionsV1beta1AllowedHostPath item);
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editAllowedHostPath(int index);
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editFirstAllowedHostPath();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editLastAllowedHostPath();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<A> editMatchingAllowedHostPath(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1AllowedHostPathBuilder> predicate);
    public A addToAllowedProcMountTypes(int index,String item);
    public A setToAllowedProcMountTypes(int index,String item);
    public A addToAllowedProcMountTypes(String... items);
    public A addAllToAllowedProcMountTypes(Collection<String> items);
    public A removeFromAllowedProcMountTypes(String... items);
    public A removeAllFromAllowedProcMountTypes(Collection<String> items);
    public List<String> getAllowedProcMountTypes();
    public String getAllowedProcMountType(int index);
    public String getFirstAllowedProcMountType();
    public String getLastAllowedProcMountType();
    public String getMatchingAllowedProcMountType(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withAllowedProcMountTypes(List<String> allowedProcMountTypes);
    public A withAllowedProcMountTypes(String... allowedProcMountTypes);
    public Boolean hasAllowedProcMountTypes();
    public A addToAllowedUnsafeSysctls(int index,String item);
    public A setToAllowedUnsafeSysctls(int index,String item);
    public A addToAllowedUnsafeSysctls(String... items);
    public A addAllToAllowedUnsafeSysctls(Collection<String> items);
    public A removeFromAllowedUnsafeSysctls(String... items);
    public A removeAllFromAllowedUnsafeSysctls(Collection<String> items);
    public List<String> getAllowedUnsafeSysctls();
    public String getAllowedUnsafeSysctl(int index);
    public String getFirstAllowedUnsafeSysctl();
    public String getLastAllowedUnsafeSysctl();
    public String getMatchingAllowedUnsafeSysctl(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withAllowedUnsafeSysctls(List<String> allowedUnsafeSysctls);
    public A withAllowedUnsafeSysctls(String... allowedUnsafeSysctls);
    public Boolean hasAllowedUnsafeSysctls();
    public A addToDefaultAddCapabilities(int index,String item);
    public A setToDefaultAddCapabilities(int index,String item);
    public A addToDefaultAddCapabilities(String... items);
    public A addAllToDefaultAddCapabilities(Collection<String> items);
    public A removeFromDefaultAddCapabilities(String... items);
    public A removeAllFromDefaultAddCapabilities(Collection<String> items);
    public List<String> getDefaultAddCapabilities();
    public String getDefaultAddCapability(int index);
    public String getFirstDefaultAddCapability();
    public String getLastDefaultAddCapability();
    public String getMatchingDefaultAddCapability(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withDefaultAddCapabilities(List<String> defaultAddCapabilities);
    public A withDefaultAddCapabilities(String... defaultAddCapabilities);
    public Boolean hasDefaultAddCapabilities();
    public Boolean isDefaultAllowPrivilegeEscalation();
    public A withDefaultAllowPrivilegeEscalation(Boolean defaultAllowPrivilegeEscalation);
    public Boolean hasDefaultAllowPrivilegeEscalation();
    public A withNewDefaultAllowPrivilegeEscalation(boolean arg1);
    public A withNewDefaultAllowPrivilegeEscalation(String arg1);
    public A addToForbiddenSysctls(int index,String item);
    public A setToForbiddenSysctls(int index,String item);
    public A addToForbiddenSysctls(String... items);
    public A addAllToForbiddenSysctls(Collection<String> items);
    public A removeFromForbiddenSysctls(String... items);
    public A removeAllFromForbiddenSysctls(Collection<String> items);
    public List<String> getForbiddenSysctls();
    public String getForbiddenSysctl(int index);
    public String getFirstForbiddenSysctl();
    public String getLastForbiddenSysctl();
    public String getMatchingForbiddenSysctl(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withForbiddenSysctls(List<String> forbiddenSysctls);
    public A withForbiddenSysctls(String... forbiddenSysctls);
    public Boolean hasForbiddenSysctls();
    
/**
 * This method has been deprecated, please use method buildFsGroup instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1FSGroupStrategyOptions getFsGroup();
    public ExtensionsV1beta1FSGroupStrategyOptions buildFsGroup();
    public A withFsGroup(ExtensionsV1beta1FSGroupStrategyOptions fsGroup);
    public Boolean hasFsGroup();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroup();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroupLike(ExtensionsV1beta1FSGroupStrategyOptions item);
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> editFsGroup();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroup();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroupLike(ExtensionsV1beta1FSGroupStrategyOptions item);
    public Boolean isHostIPC();
    public A withHostIPC(Boolean hostIPC);
    public Boolean hasHostIPC();
    public A withNewHostIPC(boolean arg1);
    public A withNewHostIPC(String arg1);
    public Boolean isHostNetwork();
    public A withHostNetwork(Boolean hostNetwork);
    public Boolean hasHostNetwork();
    public A withNewHostNetwork(boolean arg1);
    public A withNewHostNetwork(String arg1);
    public Boolean isHostPID();
    public A withHostPID(Boolean hostPID);
    public Boolean hasHostPID();
    public A withNewHostPID(boolean arg1);
    public A withNewHostPID(String arg1);
    public A addToHostPorts(int index,ExtensionsV1beta1HostPortRange item);
    public A setToHostPorts(int index,ExtensionsV1beta1HostPortRange item);
    public A addToHostPorts(ExtensionsV1beta1HostPortRange... items);
    public A addAllToHostPorts(Collection<ExtensionsV1beta1HostPortRange> items);
    public A removeFromHostPorts(ExtensionsV1beta1HostPortRange... items);
    public A removeAllFromHostPorts(Collection<ExtensionsV1beta1HostPortRange> items);
    
/**
 * This method has been deprecated, please use method buildHostPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<ExtensionsV1beta1HostPortRange> getHostPorts();
    public List<ExtensionsV1beta1HostPortRange> buildHostPorts();
    public ExtensionsV1beta1HostPortRange buildHostPort(int index);
    public ExtensionsV1beta1HostPortRange buildFirstHostPort();
    public ExtensionsV1beta1HostPortRange buildLastHostPort();
    public ExtensionsV1beta1HostPortRange buildMatchingHostPort(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1HostPortRangeBuilder> predicate);
    public A withHostPorts(List<ExtensionsV1beta1HostPortRange> hostPorts);
    public A withHostPorts(ExtensionsV1beta1HostPortRange... hostPorts);
    public Boolean hasHostPorts();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPort();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPortLike(ExtensionsV1beta1HostPortRange item);
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> setNewHostPortLike(int index,ExtensionsV1beta1HostPortRange item);
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> editHostPort(int index);
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> editFirstHostPort();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> editLastHostPort();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.HostPortsNested<A> editMatchingHostPort(io.kubernetes.client.fluent.Predicate<ExtensionsV1beta1HostPortRangeBuilder> predicate);
    public Boolean isPrivileged();
    public A withPrivileged(Boolean privileged);
    public Boolean hasPrivileged();
    public A withNewPrivileged(boolean arg1);
    public A withNewPrivileged(String arg1);
    public Boolean isReadOnlyRootFilesystem();
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem);
    public Boolean hasReadOnlyRootFilesystem();
    public A withNewReadOnlyRootFilesystem(boolean arg1);
    public A withNewReadOnlyRootFilesystem(String arg1);
    public A addToRequiredDropCapabilities(int index,String item);
    public A setToRequiredDropCapabilities(int index,String item);
    public A addToRequiredDropCapabilities(String... items);
    public A addAllToRequiredDropCapabilities(Collection<String> items);
    public A removeFromRequiredDropCapabilities(String... items);
    public A removeAllFromRequiredDropCapabilities(Collection<String> items);
    public List<String> getRequiredDropCapabilities();
    public String getRequiredDropCapability(int index);
    public String getFirstRequiredDropCapability();
    public String getLastRequiredDropCapability();
    public String getMatchingRequiredDropCapability(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withRequiredDropCapabilities(List<String> requiredDropCapabilities);
    public A withRequiredDropCapabilities(String... requiredDropCapabilities);
    public Boolean hasRequiredDropCapabilities();
    
/**
 * This method has been deprecated, please use method buildRunAsUser instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1RunAsUserStrategyOptions getRunAsUser();
    public ExtensionsV1beta1RunAsUserStrategyOptions buildRunAsUser();
    public A withRunAsUser(ExtensionsV1beta1RunAsUserStrategyOptions runAsUser);
    public Boolean hasRunAsUser();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUser();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUserLike(ExtensionsV1beta1RunAsUserStrategyOptions item);
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> editRunAsUser();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUser();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUserLike(ExtensionsV1beta1RunAsUserStrategyOptions item);
    
/**
 * This method has been deprecated, please use method buildSeLinux instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1SELinuxStrategyOptions getSeLinux();
    public ExtensionsV1beta1SELinuxStrategyOptions buildSeLinux();
    public A withSeLinux(ExtensionsV1beta1SELinuxStrategyOptions seLinux);
    public Boolean hasSeLinux();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinux();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinuxLike(ExtensionsV1beta1SELinuxStrategyOptions item);
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> editSeLinux();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinux();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinuxLike(ExtensionsV1beta1SELinuxStrategyOptions item);
    
/**
 * This method has been deprecated, please use method buildSupplementalGroups instead.
 * @return The buildable object.
 */
@Deprecated public ExtensionsV1beta1SupplementalGroupsStrategyOptions getSupplementalGroups();
    public ExtensionsV1beta1SupplementalGroupsStrategyOptions buildSupplementalGroups();
    public A withSupplementalGroups(ExtensionsV1beta1SupplementalGroupsStrategyOptions supplementalGroups);
    public Boolean hasSupplementalGroups();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroups();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(ExtensionsV1beta1SupplementalGroupsStrategyOptions item);
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editSupplementalGroups();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups();
    public ExtensionsV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(ExtensionsV1beta1SupplementalGroupsStrategyOptions item);
    public A addToVolumes(int index,String item);
    public A setToVolumes(int index,String item);
    public A addToVolumes(String... items);
    public A addAllToVolumes(Collection<String> items);
    public A removeFromVolumes(String... items);
    public A removeAllFromVolumes(Collection<String> items);
    public List<String> getVolumes();
    public String getVolume(int index);
    public String getFirstVolume();
    public String getLastVolume();
    public String getMatchingVolume(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withVolumes(List<String> volumes);
    public A withVolumes(String... volumes);
    public Boolean hasVolumes();

    public interface AllowedFlexVolumesNested<N> extends io.kubernetes.client.fluent.Nested<N>,ExtensionsV1beta1AllowedFlexVolumeFluent<ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedFlexVolumesNested<N>>{

        
    public N and();    public N endAllowedFlexVolume();
}
    public interface AllowedHostPathsNested<N> extends io.kubernetes.client.fluent.Nested<N>,ExtensionsV1beta1AllowedHostPathFluent<ExtensionsV1beta1PodSecurityPolicySpecFluent.AllowedHostPathsNested<N>>{

        
    public N and();    public N endAllowedHostPath();
}
    public interface FsGroupNested<N> extends io.kubernetes.client.fluent.Nested<N>,ExtensionsV1beta1FSGroupStrategyOptionsFluent<ExtensionsV1beta1PodSecurityPolicySpecFluent.FsGroupNested<N>>{

        
    public N and();    public N endFsGroup();
}
    public interface HostPortsNested<N> extends io.kubernetes.client.fluent.Nested<N>,ExtensionsV1beta1HostPortRangeFluent<ExtensionsV1beta1PodSecurityPolicySpecFluent.HostPortsNested<N>>{

        
    public N and();    public N endHostPort();
}
    public interface RunAsUserNested<N> extends io.kubernetes.client.fluent.Nested<N>,ExtensionsV1beta1RunAsUserStrategyOptionsFluent<ExtensionsV1beta1PodSecurityPolicySpecFluent.RunAsUserNested<N>>{

        
    public N and();    public N endRunAsUser();
}
    public interface SeLinuxNested<N> extends io.kubernetes.client.fluent.Nested<N>,ExtensionsV1beta1SELinuxStrategyOptionsFluent<ExtensionsV1beta1PodSecurityPolicySpecFluent.SeLinuxNested<N>>{

        
    public N and();    public N endSeLinux();
}
    public interface SupplementalGroupsNested<N> extends io.kubernetes.client.fluent.Nested<N>,ExtensionsV1beta1SupplementalGroupsStrategyOptionsFluent<ExtensionsV1beta1PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>>{

        
    public N and();    public N endSupplementalGroups();
}


}
