package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1RollingUpdateDeploymentBuilder extends ExtensionsV1beta1RollingUpdateDeploymentFluentImpl<ExtensionsV1beta1RollingUpdateDeploymentBuilder> implements VisitableBuilder<ExtensionsV1beta1RollingUpdateDeployment,ExtensionsV1beta1RollingUpdateDeploymentBuilder>{

    ExtensionsV1beta1RollingUpdateDeploymentFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1RollingUpdateDeploymentBuilder(){
            this(true);
    }
    public ExtensionsV1beta1RollingUpdateDeploymentBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1RollingUpdateDeployment(), validationEnabled);
    }
    public ExtensionsV1beta1RollingUpdateDeploymentBuilder(ExtensionsV1beta1RollingUpdateDeploymentFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1RollingUpdateDeploymentBuilder(ExtensionsV1beta1RollingUpdateDeploymentFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1RollingUpdateDeployment(), validationEnabled);
    }
    public ExtensionsV1beta1RollingUpdateDeploymentBuilder(ExtensionsV1beta1RollingUpdateDeploymentFluent<?> fluent,ExtensionsV1beta1RollingUpdateDeployment instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1RollingUpdateDeploymentBuilder(ExtensionsV1beta1RollingUpdateDeploymentFluent<?> fluent,ExtensionsV1beta1RollingUpdateDeployment instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMaxSurge(instance.getMaxSurge());

            fluent.withMaxUnavailable(instance.getMaxUnavailable());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1RollingUpdateDeploymentBuilder(ExtensionsV1beta1RollingUpdateDeployment instance){
            this(instance,true);
    }
    public ExtensionsV1beta1RollingUpdateDeploymentBuilder(ExtensionsV1beta1RollingUpdateDeployment instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMaxSurge(instance.getMaxSurge());

            this.withMaxUnavailable(instance.getMaxUnavailable());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1RollingUpdateDeployment build(){
            ExtensionsV1beta1RollingUpdateDeployment buildable = new ExtensionsV1beta1RollingUpdateDeployment();
            buildable.setMaxSurge(fluent.getMaxSurge());
            buildable.setMaxUnavailable(fluent.getMaxUnavailable());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1RollingUpdateDeploymentBuilder that = (ExtensionsV1beta1RollingUpdateDeploymentBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
