package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class V1EndpointSubsetFluentImpl<A extends V1EndpointSubsetFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1EndpointSubsetFluent<A>{

    private List<V1EndpointAddressBuilder> addresses;
    private List<V1EndpointAddressBuilder> notReadyAddresses;
    private List<V1EndpointPortBuilder> ports;

    public V1EndpointSubsetFluentImpl(){
    }
    public V1EndpointSubsetFluentImpl(V1EndpointSubset instance){
            this.withAddresses(instance.getAddresses());

            this.withNotReadyAddresses(instance.getNotReadyAddresses());

            this.withPorts(instance.getPorts());

    }

    public A addToAddresses(int index,V1EndpointAddress item){
            if (this.addresses == null) {this.addresses = new ArrayList<V1EndpointAddressBuilder>();}
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.addresses.add(index >= 0 ? index : addresses.size(), builder); return (A)this;
    }

    public A setToAddresses(int index,V1EndpointAddress item){
            if (this.addresses == null) {this.addresses = new ArrayList<V1EndpointAddressBuilder>();}
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= addresses.size()) { addresses.add(builder); } else { addresses.set(index, builder);}
             return (A)this;
    }

    public A addToAddresses(V1EndpointAddress... items){
            if (this.addresses == null) {this.addresses = new ArrayList<V1EndpointAddressBuilder>();}
            for (V1EndpointAddress item : items) {V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);_visitables.add(builder);this.addresses.add(builder);} return (A)this;
    }

    public A addAllToAddresses(Collection<V1EndpointAddress> items){
            if (this.addresses == null) {this.addresses = new ArrayList<V1EndpointAddressBuilder>();}
            for (V1EndpointAddress item : items) {V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);_visitables.add(builder);this.addresses.add(builder);} return (A)this;
    }

    public A removeFromAddresses(V1EndpointAddress... items){
            for (V1EndpointAddress item : items) {V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);_visitables.remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
    }

    public A removeAllFromAddresses(Collection<V1EndpointAddress> items){
            for (V1EndpointAddress item : items) {V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);_visitables.remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildAddresses instead.
 * @return The buildable object.
 */
@Deprecated public List<V1EndpointAddress> getAddresses(){
            return build(addresses);
    }

    public List<V1EndpointAddress> buildAddresses(){
            return build(addresses);
    }

    public V1EndpointAddress buildAddress(int index){
            return this.addresses.get(index).build();
    }

    public V1EndpointAddress buildFirstAddress(){
            return this.addresses.get(0).build();
    }

    public V1EndpointAddress buildLastAddress(){
            return this.addresses.get(addresses.size() - 1).build();
    }

    public V1EndpointAddress buildMatchingAddress(io.kubernetes.client.fluent.Predicate<V1EndpointAddressBuilder> predicate){
            for (V1EndpointAddressBuilder item: addresses) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withAddresses(List<V1EndpointAddress> addresses){
            if (this.addresses != null) { _visitables.removeAll(this.addresses);}
            if (addresses != null) {this.addresses = new ArrayList<V1EndpointAddressBuilder>(); for (V1EndpointAddress item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
    }

    public A withAddresses(V1EndpointAddress... addresses){
            if (this.addresses != null) {this.addresses.clear();}
            if (addresses != null) {for (V1EndpointAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
    }

    public Boolean hasAddresses(){
            return addresses != null && !addresses.isEmpty();
    }

    public V1EndpointSubsetFluent.AddressesNested<A> addNewAddress(){
            return new AddressesNestedImpl();
    }

    public V1EndpointSubsetFluent.AddressesNested<A> addNewAddressLike(V1EndpointAddress item){
            return new AddressesNestedImpl(-1, item);
    }

    public V1EndpointSubsetFluent.AddressesNested<A> setNewAddressLike(int index,V1EndpointAddress item){
            return new AddressesNestedImpl(index, item);
    }

    public V1EndpointSubsetFluent.AddressesNested<A> editAddress(int index){
            if (addresses.size() <= index) throw new RuntimeException("Can't edit addresses. Index exceeds size.");
            return setNewAddressLike(index, buildAddress(index));
    }

    public V1EndpointSubsetFluent.AddressesNested<A> editFirstAddress(){
            if (addresses.size() == 0) throw new RuntimeException("Can't edit first addresses. The list is empty.");
            return setNewAddressLike(0, buildAddress(0));
    }

    public V1EndpointSubsetFluent.AddressesNested<A> editLastAddress(){
            int index = addresses.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last addresses. The list is empty.");
            return setNewAddressLike(index, buildAddress(index));
    }

    public V1EndpointSubsetFluent.AddressesNested<A> editMatchingAddress(io.kubernetes.client.fluent.Predicate<V1EndpointAddressBuilder> predicate){
            int index = -1;
            for (int i=0;i<addresses.size();i++) { 
            if (predicate.apply(addresses.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching addresses. No match found.");
            return setNewAddressLike(index, buildAddress(index));
    }

    public A addToNotReadyAddresses(int index,V1EndpointAddress item){
            if (this.notReadyAddresses == null) {this.notReadyAddresses = new ArrayList<V1EndpointAddressBuilder>();}
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.notReadyAddresses.add(index >= 0 ? index : notReadyAddresses.size(), builder); return (A)this;
    }

    public A setToNotReadyAddresses(int index,V1EndpointAddress item){
            if (this.notReadyAddresses == null) {this.notReadyAddresses = new ArrayList<V1EndpointAddressBuilder>();}
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= notReadyAddresses.size()) { notReadyAddresses.add(builder); } else { notReadyAddresses.set(index, builder);}
             return (A)this;
    }

    public A addToNotReadyAddresses(V1EndpointAddress... items){
            if (this.notReadyAddresses == null) {this.notReadyAddresses = new ArrayList<V1EndpointAddressBuilder>();}
            for (V1EndpointAddress item : items) {V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);_visitables.add(builder);this.notReadyAddresses.add(builder);} return (A)this;
    }

    public A addAllToNotReadyAddresses(Collection<V1EndpointAddress> items){
            if (this.notReadyAddresses == null) {this.notReadyAddresses = new ArrayList<V1EndpointAddressBuilder>();}
            for (V1EndpointAddress item : items) {V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);_visitables.add(builder);this.notReadyAddresses.add(builder);} return (A)this;
    }

    public A removeFromNotReadyAddresses(V1EndpointAddress... items){
            for (V1EndpointAddress item : items) {V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);_visitables.remove(builder);if (this.notReadyAddresses != null) {this.notReadyAddresses.remove(builder);}} return (A)this;
    }

    public A removeAllFromNotReadyAddresses(Collection<V1EndpointAddress> items){
            for (V1EndpointAddress item : items) {V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);_visitables.remove(builder);if (this.notReadyAddresses != null) {this.notReadyAddresses.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildNotReadyAddresses instead.
 * @return The buildable object.
 */
@Deprecated public List<V1EndpointAddress> getNotReadyAddresses(){
            return build(notReadyAddresses);
    }

    public List<V1EndpointAddress> buildNotReadyAddresses(){
            return build(notReadyAddresses);
    }

    public V1EndpointAddress buildNotReadyAddress(int index){
            return this.notReadyAddresses.get(index).build();
    }

    public V1EndpointAddress buildFirstNotReadyAddress(){
            return this.notReadyAddresses.get(0).build();
    }

    public V1EndpointAddress buildLastNotReadyAddress(){
            return this.notReadyAddresses.get(notReadyAddresses.size() - 1).build();
    }

    public V1EndpointAddress buildMatchingNotReadyAddress(io.kubernetes.client.fluent.Predicate<V1EndpointAddressBuilder> predicate){
            for (V1EndpointAddressBuilder item: notReadyAddresses) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withNotReadyAddresses(List<V1EndpointAddress> notReadyAddresses){
            if (this.notReadyAddresses != null) { _visitables.removeAll(this.notReadyAddresses);}
            if (notReadyAddresses != null) {this.notReadyAddresses = new ArrayList<V1EndpointAddressBuilder>(); for (V1EndpointAddress item : notReadyAddresses){this.addToNotReadyAddresses(item);}} else { this.notReadyAddresses = null;} return (A) this;
    }

    public A withNotReadyAddresses(V1EndpointAddress... notReadyAddresses){
            if (this.notReadyAddresses != null) {this.notReadyAddresses.clear();}
            if (notReadyAddresses != null) {for (V1EndpointAddress item :notReadyAddresses){ this.addToNotReadyAddresses(item);}} return (A) this;
    }

    public Boolean hasNotReadyAddresses(){
            return notReadyAddresses != null && !notReadyAddresses.isEmpty();
    }

    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddress(){
            return new NotReadyAddressesNestedImpl();
    }

    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddressLike(V1EndpointAddress item){
            return new NotReadyAddressesNestedImpl(-1, item);
    }

    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> setNewNotReadyAddressLike(int index,V1EndpointAddress item){
            return new NotReadyAddressesNestedImpl(index, item);
    }

    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> editNotReadyAddress(int index){
            if (notReadyAddresses.size() <= index) throw new RuntimeException("Can't edit notReadyAddresses. Index exceeds size.");
            return setNewNotReadyAddressLike(index, buildNotReadyAddress(index));
    }

    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> editFirstNotReadyAddress(){
            if (notReadyAddresses.size() == 0) throw new RuntimeException("Can't edit first notReadyAddresses. The list is empty.");
            return setNewNotReadyAddressLike(0, buildNotReadyAddress(0));
    }

    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> editLastNotReadyAddress(){
            int index = notReadyAddresses.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last notReadyAddresses. The list is empty.");
            return setNewNotReadyAddressLike(index, buildNotReadyAddress(index));
    }

    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> editMatchingNotReadyAddress(io.kubernetes.client.fluent.Predicate<V1EndpointAddressBuilder> predicate){
            int index = -1;
            for (int i=0;i<notReadyAddresses.size();i++) { 
            if (predicate.apply(notReadyAddresses.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching notReadyAddresses. No match found.");
            return setNewNotReadyAddressLike(index, buildNotReadyAddress(index));
    }

    public A addToPorts(int index,V1EndpointPort item){
            if (this.ports == null) {this.ports = new ArrayList<V1EndpointPortBuilder>();}
            V1EndpointPortBuilder builder = new V1EndpointPortBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
    }

    public A setToPorts(int index,V1EndpointPort item){
            if (this.ports == null) {this.ports = new ArrayList<V1EndpointPortBuilder>();}
            V1EndpointPortBuilder builder = new V1EndpointPortBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
             return (A)this;
    }

    public A addToPorts(V1EndpointPort... items){
            if (this.ports == null) {this.ports = new ArrayList<V1EndpointPortBuilder>();}
            for (V1EndpointPort item : items) {V1EndpointPortBuilder builder = new V1EndpointPortBuilder(item);_visitables.add(builder);this.ports.add(builder);} return (A)this;
    }

    public A addAllToPorts(Collection<V1EndpointPort> items){
            if (this.ports == null) {this.ports = new ArrayList<V1EndpointPortBuilder>();}
            for (V1EndpointPort item : items) {V1EndpointPortBuilder builder = new V1EndpointPortBuilder(item);_visitables.add(builder);this.ports.add(builder);} return (A)this;
    }

    public A removeFromPorts(V1EndpointPort... items){
            for (V1EndpointPort item : items) {V1EndpointPortBuilder builder = new V1EndpointPortBuilder(item);_visitables.remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    public A removeAllFromPorts(Collection<V1EndpointPort> items){
            for (V1EndpointPort item : items) {V1EndpointPortBuilder builder = new V1EndpointPortBuilder(item);_visitables.remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPorts instead.
 * @return The buildable object.
 */
@Deprecated public List<V1EndpointPort> getPorts(){
            return build(ports);
    }

    public List<V1EndpointPort> buildPorts(){
            return build(ports);
    }

    public V1EndpointPort buildPort(int index){
            return this.ports.get(index).build();
    }

    public V1EndpointPort buildFirstPort(){
            return this.ports.get(0).build();
    }

    public V1EndpointPort buildLastPort(){
            return this.ports.get(ports.size() - 1).build();
    }

    public V1EndpointPort buildMatchingPort(io.kubernetes.client.fluent.Predicate<V1EndpointPortBuilder> predicate){
            for (V1EndpointPortBuilder item: ports) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withPorts(List<V1EndpointPort> ports){
            if (this.ports != null) { _visitables.removeAll(this.ports);}
            if (ports != null) {this.ports = new ArrayList<V1EndpointPortBuilder>(); for (V1EndpointPort item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
    }

    public A withPorts(V1EndpointPort... ports){
            if (this.ports != null) {this.ports.clear();}
            if (ports != null) {for (V1EndpointPort item :ports){ this.addToPorts(item);}} return (A) this;
    }

    public Boolean hasPorts(){
            return ports != null && !ports.isEmpty();
    }

    public V1EndpointSubsetFluent.PortsNested<A> addNewPort(){
            return new PortsNestedImpl();
    }

    public V1EndpointSubsetFluent.PortsNested<A> addNewPortLike(V1EndpointPort item){
            return new PortsNestedImpl(-1, item);
    }

    public V1EndpointSubsetFluent.PortsNested<A> setNewPortLike(int index,V1EndpointPort item){
            return new PortsNestedImpl(index, item);
    }

    public V1EndpointSubsetFluent.PortsNested<A> editPort(int index){
            if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
            return setNewPortLike(index, buildPort(index));
    }

    public V1EndpointSubsetFluent.PortsNested<A> editFirstPort(){
            if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
            return setNewPortLike(0, buildPort(0));
    }

    public V1EndpointSubsetFluent.PortsNested<A> editLastPort(){
            int index = ports.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
            return setNewPortLike(index, buildPort(index));
    }

    public V1EndpointSubsetFluent.PortsNested<A> editMatchingPort(io.kubernetes.client.fluent.Predicate<V1EndpointPortBuilder> predicate){
            int index = -1;
            for (int i=0;i<ports.size();i++) { 
            if (predicate.apply(ports.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
            return setNewPortLike(index, buildPort(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1EndpointSubsetFluentImpl that = (V1EndpointSubsetFluentImpl) o;
            if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
            if (notReadyAddresses != null ? !notReadyAddresses.equals(that.notReadyAddresses) :that.notReadyAddresses != null) return false;
            if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
            return true;
    }


    public class AddressesNestedImpl<N> extends V1EndpointAddressFluentImpl<V1EndpointSubsetFluent.AddressesNested<N>> implements V1EndpointSubsetFluent.AddressesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1EndpointAddressBuilder builder;
        private final int index;
    
            AddressesNestedImpl(int index,V1EndpointAddress item){
                    this.index = index;
                    this.builder = new V1EndpointAddressBuilder(this, item);
            }
            AddressesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1EndpointAddressBuilder(this);
            }
    
    public N and(){
            return (N) V1EndpointSubsetFluentImpl.this.setToAddresses(index, builder.build());
    }
    public N endAddress(){
            return and();
    }

}
    public class NotReadyAddressesNestedImpl<N> extends V1EndpointAddressFluentImpl<V1EndpointSubsetFluent.NotReadyAddressesNested<N>> implements V1EndpointSubsetFluent.NotReadyAddressesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1EndpointAddressBuilder builder;
        private final int index;
    
            NotReadyAddressesNestedImpl(int index,V1EndpointAddress item){
                    this.index = index;
                    this.builder = new V1EndpointAddressBuilder(this, item);
            }
            NotReadyAddressesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1EndpointAddressBuilder(this);
            }
    
    public N and(){
            return (N) V1EndpointSubsetFluentImpl.this.setToNotReadyAddresses(index, builder.build());
    }
    public N endNotReadyAddress(){
            return and();
    }

}
    public class PortsNestedImpl<N> extends V1EndpointPortFluentImpl<V1EndpointSubsetFluent.PortsNested<N>> implements V1EndpointSubsetFluent.PortsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1EndpointPortBuilder builder;
        private final int index;
    
            PortsNestedImpl(int index,V1EndpointPort item){
                    this.index = index;
                    this.builder = new V1EndpointPortBuilder(this, item);
            }
            PortsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1EndpointPortBuilder(this);
            }
    
    public N and(){
            return (N) V1EndpointSubsetFluentImpl.this.setToPorts(index, builder.build());
    }
    public N endPort(){
            return and();
    }

}


}
