package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Predicate;

public interface V1HostAliasFluent<A extends V1HostAliasFluent<A>> extends Fluent<A>{


    public A addToHostnames(int index,String item);
    public A setToHostnames(int index,String item);
    public A addToHostnames(String... items);
    public A addAllToHostnames(Collection<String> items);
    public A removeFromHostnames(String... items);
    public A removeAllFromHostnames(Collection<String> items);
    public List<String> getHostnames();
    public String getHostname(int index);
    public String getFirstHostname();
    public String getLastHostname();
    public String getMatchingHostname(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withHostnames(List<String> hostnames);
    public A withHostnames(String... hostnames);
    public Boolean hasHostnames();
    public String getIp();
    public A withIp(String ip);
    public Boolean hasIp();



}
