package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1PodReadinessGateBuilder extends V1PodReadinessGateFluentImpl<V1PodReadinessGateBuilder> implements VisitableBuilder<V1PodReadinessGate,V1PodReadinessGateBuilder>{

    V1PodReadinessGateFluent<?> fluent;
    Boolean validationEnabled;

    public V1PodReadinessGateBuilder(){
            this(true);
    }
    public V1PodReadinessGateBuilder(Boolean validationEnabled){
            this(new V1PodReadinessGate(), validationEnabled);
    }
    public V1PodReadinessGateBuilder(V1PodReadinessGateFluent<?> fluent){
            this(fluent, true);
    }
    public V1PodReadinessGateBuilder(V1PodReadinessGateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1PodReadinessGate(), validationEnabled);
    }
    public V1PodReadinessGateBuilder(V1PodReadinessGateFluent<?> fluent,V1PodReadinessGate instance){
            this(fluent, instance, true);
    }
    public V1PodReadinessGateBuilder(V1PodReadinessGateFluent<?> fluent,V1PodReadinessGate instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConditionType(instance.getConditionType());

            this.validationEnabled = validationEnabled; 
    }
    public V1PodReadinessGateBuilder(V1PodReadinessGate instance){
            this(instance,true);
    }
    public V1PodReadinessGateBuilder(V1PodReadinessGate instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConditionType(instance.getConditionType());

            this.validationEnabled = validationEnabled; 
    }

    public V1PodReadinessGate build(){
            V1PodReadinessGate buildable = new V1PodReadinessGate();
            buildable.setConditionType(fluent.getConditionType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1PodReadinessGateBuilder that = (V1PodReadinessGateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
