package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PodPresetBuilder extends V1alpha1PodPresetFluentImpl<V1alpha1PodPresetBuilder> implements VisitableBuilder<V1alpha1PodPreset,V1alpha1PodPresetBuilder>{

    V1alpha1PodPresetFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PodPresetBuilder(){
            this(true);
    }
    public V1alpha1PodPresetBuilder(Boolean validationEnabled){
            this(new V1alpha1PodPreset(), validationEnabled);
    }
    public V1alpha1PodPresetBuilder(V1alpha1PodPresetFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PodPresetBuilder(V1alpha1PodPresetFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PodPreset(), validationEnabled);
    }
    public V1alpha1PodPresetBuilder(V1alpha1PodPresetFluent<?> fluent,V1alpha1PodPreset instance){
            this(fluent, instance, true);
    }
    public V1alpha1PodPresetBuilder(V1alpha1PodPresetFluent<?> fluent,V1alpha1PodPreset instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PodPresetBuilder(V1alpha1PodPreset instance){
            this(instance,true);
    }
    public V1alpha1PodPresetBuilder(V1alpha1PodPreset instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PodPreset build(){
            V1alpha1PodPreset buildable = new V1alpha1PodPreset();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PodPresetBuilder that = (V1alpha1PodPresetBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
