package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1beta1CustomResourceSubresourceScaleFluentImpl<A extends V1beta1CustomResourceSubresourceScaleFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1CustomResourceSubresourceScaleFluent<A>{

    private String labelSelectorPath;
    private String specReplicasPath;
    private String statusReplicasPath;

    public V1beta1CustomResourceSubresourceScaleFluentImpl(){
    }
    public V1beta1CustomResourceSubresourceScaleFluentImpl(V1beta1CustomResourceSubresourceScale instance){
            this.withLabelSelectorPath(instance.getLabelSelectorPath());

            this.withSpecReplicasPath(instance.getSpecReplicasPath());

            this.withStatusReplicasPath(instance.getStatusReplicasPath());

    }

    public String getLabelSelectorPath(){
            return this.labelSelectorPath;
    }

    public A withLabelSelectorPath(String labelSelectorPath){
            this.labelSelectorPath=labelSelectorPath; return (A) this;
    }

    public Boolean hasLabelSelectorPath(){
            return this.labelSelectorPath != null;
    }

    public String getSpecReplicasPath(){
            return this.specReplicasPath;
    }

    public A withSpecReplicasPath(String specReplicasPath){
            this.specReplicasPath=specReplicasPath; return (A) this;
    }

    public Boolean hasSpecReplicasPath(){
            return this.specReplicasPath != null;
    }

    public String getStatusReplicasPath(){
            return this.statusReplicasPath;
    }

    public A withStatusReplicasPath(String statusReplicasPath){
            this.statusReplicasPath=statusReplicasPath; return (A) this;
    }

    public Boolean hasStatusReplicasPath(){
            return this.statusReplicasPath != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1CustomResourceSubresourceScaleFluentImpl that = (V1beta1CustomResourceSubresourceScaleFluentImpl) o;
            if (labelSelectorPath != null ? !labelSelectorPath.equals(that.labelSelectorPath) :that.labelSelectorPath != null) return false;
            if (specReplicasPath != null ? !specReplicasPath.equals(that.specReplicasPath) :that.specReplicasPath != null) return false;
            if (statusReplicasPath != null ? !statusReplicasPath.equals(that.statusReplicasPath) :that.statusReplicasPath != null) return false;
            return true;
    }




}
