package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2DeploymentConditionBuilder extends V1beta2DeploymentConditionFluentImpl<V1beta2DeploymentConditionBuilder> implements VisitableBuilder<V1beta2DeploymentCondition,V1beta2DeploymentConditionBuilder>{

    V1beta2DeploymentConditionFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2DeploymentConditionBuilder(){
            this(true);
    }
    public V1beta2DeploymentConditionBuilder(Boolean validationEnabled){
            this(new V1beta2DeploymentCondition(), validationEnabled);
    }
    public V1beta2DeploymentConditionBuilder(V1beta2DeploymentConditionFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2DeploymentConditionBuilder(V1beta2DeploymentConditionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2DeploymentCondition(), validationEnabled);
    }
    public V1beta2DeploymentConditionBuilder(V1beta2DeploymentConditionFluent<?> fluent,V1beta2DeploymentCondition instance){
            this(fluent, instance, true);
    }
    public V1beta2DeploymentConditionBuilder(V1beta2DeploymentConditionFluent<?> fluent,V1beta2DeploymentCondition instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLastTransitionTime(instance.getLastTransitionTime());

            fluent.withLastUpdateTime(instance.getLastUpdateTime());

            fluent.withMessage(instance.getMessage());

            fluent.withReason(instance.getReason());

            fluent.withStatus(instance.getStatus());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2DeploymentConditionBuilder(V1beta2DeploymentCondition instance){
            this(instance,true);
    }
    public V1beta2DeploymentConditionBuilder(V1beta2DeploymentCondition instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLastTransitionTime(instance.getLastTransitionTime());

            this.withLastUpdateTime(instance.getLastUpdateTime());

            this.withMessage(instance.getMessage());

            this.withReason(instance.getReason());

            this.withStatus(instance.getStatus());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2DeploymentCondition build(){
            V1beta2DeploymentCondition buildable = new V1beta2DeploymentCondition();
            buildable.setLastTransitionTime(fluent.getLastTransitionTime());
            buildable.setLastUpdateTime(fluent.getLastUpdateTime());
            buildable.setMessage(fluent.getMessage());
            buildable.setReason(fluent.getReason());
            buildable.setStatus(fluent.getStatus());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2DeploymentConditionBuilder that = (V1beta2DeploymentConditionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
