package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta1PodsMetricStatusFluentImpl<A extends V2beta1PodsMetricStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V2beta1PodsMetricStatusFluent<A>{

    private String currentAverageValue;
    private String metricName;
    private V1LabelSelectorBuilder selector;

    public V2beta1PodsMetricStatusFluentImpl(){
    }
    public V2beta1PodsMetricStatusFluentImpl(V2beta1PodsMetricStatus instance){
            this.withCurrentAverageValue(instance.getCurrentAverageValue());

            this.withMetricName(instance.getMetricName());

            this.withSelector(instance.getSelector());

    }

    public String getCurrentAverageValue(){
            return this.currentAverageValue;
    }

    public A withCurrentAverageValue(String currentAverageValue){
            this.currentAverageValue=currentAverageValue; return (A) this;
    }

    public Boolean hasCurrentAverageValue(){
            return this.currentAverageValue != null;
    }

    public String getMetricName(){
            return this.metricName;
    }

    public A withMetricName(String metricName){
            this.metricName=metricName; return (A) this;
    }

    public Boolean hasMetricName(){
            return this.metricName != null;
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public V1LabelSelector buildSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(V1LabelSelector selector){
            _visitables.remove(this.selector);
            if (selector!=null){ this.selector= new V1LabelSelectorBuilder(selector); _visitables.add(this.selector);} return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector != null;
    }

    public V2beta1PodsMetricStatusFluent.SelectorNested<A> withNewSelector(){
            return new SelectorNestedImpl();
    }

    public V2beta1PodsMetricStatusFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item){
            return new SelectorNestedImpl(item);
    }

    public V2beta1PodsMetricStatusFluent.SelectorNested<A> editSelector(){
            return withNewSelectorLike(getSelector());
    }

    public V2beta1PodsMetricStatusFluent.SelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new V1LabelSelectorBuilder().build());
    }

    public V2beta1PodsMetricStatusFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta1PodsMetricStatusFluentImpl that = (V2beta1PodsMetricStatusFluentImpl) o;
            if (currentAverageValue != null ? !currentAverageValue.equals(that.currentAverageValue) :that.currentAverageValue != null) return false;
            if (metricName != null ? !metricName.equals(that.metricName) :that.metricName != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            return true;
    }


    public class SelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V2beta1PodsMetricStatusFluent.SelectorNested<N>> implements V2beta1PodsMetricStatusFluent.SelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            SelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            SelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V2beta1PodsMetricStatusFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector(){
            return and();
    }

}


}
