package io.kubernetes.client.models;

import java.lang.Integer;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.custom.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V2beta2MetricTargetFluentImpl<A extends V2beta2MetricTargetFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V2beta2MetricTargetFluent<A>{

    private Integer averageUtilization;
    private Quantity averageValue;
    private String type;
    private Quantity value;

    public V2beta2MetricTargetFluentImpl(){
    }
    public V2beta2MetricTargetFluentImpl(V2beta2MetricTarget instance){
            this.withAverageUtilization(instance.getAverageUtilization());

            this.withAverageValue(instance.getAverageValue());

            this.withType(instance.getType());

            this.withValue(instance.getValue());

    }

    public Integer getAverageUtilization(){
            return this.averageUtilization;
    }

    public A withAverageUtilization(Integer averageUtilization){
            this.averageUtilization=averageUtilization; return (A) this;
    }

    public Boolean hasAverageUtilization(){
            return this.averageUtilization != null;
    }

    public A withNewAverageUtilization(int arg1){
            return (A)withAverageUtilization(new Integer(arg1));
    }

    public A withNewAverageUtilization(String arg1){
            return (A)withAverageUtilization(new Integer(arg1));
    }

    public Quantity getAverageValue(){
            return this.averageValue;
    }

    public A withAverageValue(Quantity averageValue){
            this.averageValue=averageValue; return (A) this;
    }

    public Boolean hasAverageValue(){
            return this.averageValue != null;
    }

    public A withNewAverageValue(final String value){
            return (A)withAverageValue(new Quantity(value));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public Quantity getValue(){
            return this.value;
    }

    public A withValue(Quantity value){
            this.value=value; return (A) this;
    }

    public Boolean hasValue(){
            return this.value != null;
    }

    public A withNewValue(final String value){
            return (A)withValue(new Quantity(value));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta2MetricTargetFluentImpl that = (V2beta2MetricTargetFluentImpl) o;
            if (averageUtilization != null ? !averageUtilization.equals(that.averageUtilization) :that.averageUtilization != null) return false;
            if (averageValue != null ? !averageValue.equals(that.averageValue) :that.averageValue != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            if (value != null ? !value.equals(that.value) :that.value != null) return false;
            return true;
    }




}
