/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.apis;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.kubernetes.client.ApiCallback;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.ApiResponse;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.Pair;
import io.kubernetes.client.ProgressRequestBody;
import io.kubernetes.client.ProgressResponseBody;
import io.kubernetes.client.models.V1DeleteOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class CustomObjectsApi {
    private ApiClient apiClient;

    public CustomObjectsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomObjectsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createClusterCustomObjectCall(String group, String version, String plural, Object body, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createClusterCustomObjectValidateBeforeCall(String group, String version, String plural, Object body, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling createClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling createClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling createClusterCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createClusterCustomObject(Async)");
        }
        Call call = this.createClusterCustomObjectCall(group, version, plural, body, pretty, progressListener, progressRequestListener);
        return call;
    }

    public Object createClusterCustomObject(String group, String version, String plural, Object body, String pretty) throws ApiException {
        ApiResponse<Object> resp = this.createClusterCustomObjectWithHttpInfo(group, version, plural, body, pretty);
        return resp.getData();
    }

    public ApiResponse<Object> createClusterCustomObjectWithHttpInfo(String group, String version, String plural, Object body, String pretty) throws ApiException {
        Call call = this.createClusterCustomObjectValidateBeforeCall(group, version, plural, body, pretty, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createClusterCustomObjectAsync(String group, String version, String plural, Object body, String pretty, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createClusterCustomObjectValidateBeforeCall(group, version, plural, body, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createNamespacedCustomObjectCall(String group, String version, String namespace, String plural, Object body, String pretty, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createNamespacedCustomObjectValidateBeforeCall(String group, String version, String namespace, String plural, Object body, String pretty, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling createNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling createNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling createNamespacedCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createNamespacedCustomObject(Async)");
        }
        Call call = this.createNamespacedCustomObjectCall(group, version, namespace, plural, body, pretty, progressListener, progressRequestListener);
        return call;
    }

    public Object createNamespacedCustomObject(String group, String version, String namespace, String plural, Object body, String pretty) throws ApiException {
        ApiResponse<Object> resp = this.createNamespacedCustomObjectWithHttpInfo(group, version, namespace, plural, body, pretty);
        return resp.getData();
    }

    public ApiResponse<Object> createNamespacedCustomObjectWithHttpInfo(String group, String version, String namespace, String plural, Object body, String pretty) throws ApiException {
        Call call = this.createNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, body, pretty, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createNamespacedCustomObjectAsync(String group, String version, String namespace, String plural, Object body, String pretty, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, body, pretty, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteClusterCustomObjectCall(String group, String version, String plural, String name, V1DeleteOptions body, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteClusterCustomObjectValidateBeforeCall(String group, String version, String plural, String name, V1DeleteOptions body, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling deleteClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling deleteClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling deleteClusterCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteClusterCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling deleteClusterCustomObject(Async)");
        }
        Call call = this.deleteClusterCustomObjectCall(group, version, plural, name, body, gracePeriodSeconds, orphanDependents, propagationPolicy, progressListener, progressRequestListener);
        return call;
    }

    public Object deleteClusterCustomObject(String group, String version, String plural, String name, V1DeleteOptions body, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy) throws ApiException {
        ApiResponse<Object> resp = this.deleteClusterCustomObjectWithHttpInfo(group, version, plural, name, body, gracePeriodSeconds, orphanDependents, propagationPolicy);
        return resp.getData();
    }

    public ApiResponse<Object> deleteClusterCustomObjectWithHttpInfo(String group, String version, String plural, String name, V1DeleteOptions body, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy) throws ApiException {
        Call call = this.deleteClusterCustomObjectValidateBeforeCall(group, version, plural, name, body, gracePeriodSeconds, orphanDependents, propagationPolicy, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteClusterCustomObjectAsync(String group, String version, String plural, String name, V1DeleteOptions body, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteClusterCustomObjectValidateBeforeCall(group, version, plural, name, body, gracePeriodSeconds, orphanDependents, propagationPolicy, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteNamespacedCustomObjectCall(String group, String version, String namespace, String plural, String name, V1DeleteOptions body, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteNamespacedCustomObjectValidateBeforeCall(String group, String version, String namespace, String plural, String name, V1DeleteOptions body, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling deleteNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling deleteNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling deleteNamespacedCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteNamespacedCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling deleteNamespacedCustomObject(Async)");
        }
        Call call = this.deleteNamespacedCustomObjectCall(group, version, namespace, plural, name, body, gracePeriodSeconds, orphanDependents, propagationPolicy, progressListener, progressRequestListener);
        return call;
    }

    public Object deleteNamespacedCustomObject(String group, String version, String namespace, String plural, String name, V1DeleteOptions body, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy) throws ApiException {
        ApiResponse<Object> resp = this.deleteNamespacedCustomObjectWithHttpInfo(group, version, namespace, plural, name, body, gracePeriodSeconds, orphanDependents, propagationPolicy);
        return resp.getData();
    }

    public ApiResponse<Object> deleteNamespacedCustomObjectWithHttpInfo(String group, String version, String namespace, String plural, String name, V1DeleteOptions body, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy) throws ApiException {
        Call call = this.deleteNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, body, gracePeriodSeconds, orphanDependents, propagationPolicy, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deleteNamespacedCustomObjectAsync(String group, String version, String namespace, String plural, String name, V1DeleteOptions body, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, body, gracePeriodSeconds, orphanDependents, propagationPolicy, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getClusterCustomObjectCall(String group, String version, String plural, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getClusterCustomObjectValidateBeforeCall(String group, String version, String plural, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getClusterCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getClusterCustomObject(Async)");
        }
        Call call = this.getClusterCustomObjectCall(group, version, plural, name, progressListener, progressRequestListener);
        return call;
    }

    public Object getClusterCustomObject(String group, String version, String plural, String name) throws ApiException {
        ApiResponse<Object> resp = this.getClusterCustomObjectWithHttpInfo(group, version, plural, name);
        return resp.getData();
    }

    public ApiResponse<Object> getClusterCustomObjectWithHttpInfo(String group, String version, String plural, String name) throws ApiException {
        Call call = this.getClusterCustomObjectValidateBeforeCall(group, version, plural, name, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getClusterCustomObjectAsync(String group, String version, String plural, String name, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getClusterCustomObjectValidateBeforeCall(group, version, plural, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getClusterCustomObjectScaleCall(String group, String version, String plural, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/scale".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getClusterCustomObjectScaleValidateBeforeCall(String group, String version, String plural, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getClusterCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getClusterCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getClusterCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getClusterCustomObjectScale(Async)");
        }
        Call call = this.getClusterCustomObjectScaleCall(group, version, plural, name, progressListener, progressRequestListener);
        return call;
    }

    public Object getClusterCustomObjectScale(String group, String version, String plural, String name) throws ApiException {
        ApiResponse<Object> resp = this.getClusterCustomObjectScaleWithHttpInfo(group, version, plural, name);
        return resp.getData();
    }

    public ApiResponse<Object> getClusterCustomObjectScaleWithHttpInfo(String group, String version, String plural, String name) throws ApiException {
        Call call = this.getClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getClusterCustomObjectScaleAsync(String group, String version, String plural, String name, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getClusterCustomObjectStatusCall(String group, String version, String plural, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/status".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getClusterCustomObjectStatusValidateBeforeCall(String group, String version, String plural, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getClusterCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getClusterCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getClusterCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getClusterCustomObjectStatus(Async)");
        }
        Call call = this.getClusterCustomObjectStatusCall(group, version, plural, name, progressListener, progressRequestListener);
        return call;
    }

    public Object getClusterCustomObjectStatus(String group, String version, String plural, String name) throws ApiException {
        ApiResponse<Object> resp = this.getClusterCustomObjectStatusWithHttpInfo(group, version, plural, name);
        return resp.getData();
    }

    public ApiResponse<Object> getClusterCustomObjectStatusWithHttpInfo(String group, String version, String plural, String name) throws ApiException {
        Call call = this.getClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getClusterCustomObjectStatusAsync(String group, String version, String plural, String name, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getNamespacedCustomObjectCall(String group, String version, String namespace, String plural, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getNamespacedCustomObjectValidateBeforeCall(String group, String version, String namespace, String plural, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getNamespacedCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getNamespacedCustomObject(Async)");
        }
        Call call = this.getNamespacedCustomObjectCall(group, version, namespace, plural, name, progressListener, progressRequestListener);
        return call;
    }

    public Object getNamespacedCustomObject(String group, String version, String namespace, String plural, String name) throws ApiException {
        ApiResponse<Object> resp = this.getNamespacedCustomObjectWithHttpInfo(group, version, namespace, plural, name);
        return resp.getData();
    }

    public ApiResponse<Object> getNamespacedCustomObjectWithHttpInfo(String group, String version, String namespace, String plural, String name) throws ApiException {
        Call call = this.getNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getNamespacedCustomObjectAsync(String group, String version, String namespace, String plural, String name, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getNamespacedCustomObjectScaleCall(String group, String version, String namespace, String plural, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getNamespacedCustomObjectScaleValidateBeforeCall(String group, String version, String namespace, String plural, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getNamespacedCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getNamespacedCustomObjectScale(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getNamespacedCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getNamespacedCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getNamespacedCustomObjectScale(Async)");
        }
        Call call = this.getNamespacedCustomObjectScaleCall(group, version, namespace, plural, name, progressListener, progressRequestListener);
        return call;
    }

    public Object getNamespacedCustomObjectScale(String group, String version, String namespace, String plural, String name) throws ApiException {
        ApiResponse<Object> resp = this.getNamespacedCustomObjectScaleWithHttpInfo(group, version, namespace, plural, name);
        return resp.getData();
    }

    public ApiResponse<Object> getNamespacedCustomObjectScaleWithHttpInfo(String group, String version, String namespace, String plural, String name) throws ApiException {
        Call call = this.getNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getNamespacedCustomObjectScaleAsync(String group, String version, String namespace, String plural, String name, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getNamespacedCustomObjectStatusCall(String group, String version, String namespace, String plural, String name, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getNamespacedCustomObjectStatusValidateBeforeCall(String group, String version, String namespace, String plural, String name, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling getNamespacedCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling getNamespacedCustomObjectStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getNamespacedCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling getNamespacedCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getNamespacedCustomObjectStatus(Async)");
        }
        Call call = this.getNamespacedCustomObjectStatusCall(group, version, namespace, plural, name, progressListener, progressRequestListener);
        return call;
    }

    public Object getNamespacedCustomObjectStatus(String group, String version, String namespace, String plural, String name) throws ApiException {
        ApiResponse<Object> resp = this.getNamespacedCustomObjectStatusWithHttpInfo(group, version, namespace, plural, name);
        return resp.getData();
    }

    public ApiResponse<Object> getNamespacedCustomObjectStatusWithHttpInfo(String group, String version, String namespace, String plural, String name) throws ApiException {
        Call call = this.getNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getNamespacedCustomObjectStatusAsync(String group, String version, String namespace, String plural, String name, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listClusterCustomObjectCall(String group, String version, String plural, String pretty, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/{plural}".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/json;stream=watch"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listClusterCustomObjectValidateBeforeCall(String group, String version, String plural, String pretty, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling listClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling listClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling listClusterCustomObject(Async)");
        }
        Call call = this.listClusterCustomObjectCall(group, version, plural, pretty, labelSelector, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        return call;
    }

    public Object listClusterCustomObject(String group, String version, String plural, String pretty, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<Object> resp = this.listClusterCustomObjectWithHttpInfo(group, version, plural, pretty, labelSelector, resourceVersion, timeoutSeconds, watch);
        return resp.getData();
    }

    public ApiResponse<Object> listClusterCustomObjectWithHttpInfo(String group, String version, String plural, String pretty, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call call = this.listClusterCustomObjectValidateBeforeCall(group, version, plural, pretty, labelSelector, resourceVersion, timeoutSeconds, watch, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listClusterCustomObjectAsync(String group, String version, String plural, String pretty, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listClusterCustomObjectValidateBeforeCall(group, version, plural, pretty, labelSelector, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call listNamespacedCustomObjectCall(String group, String version, String namespace, String plural, String pretty, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("pretty", pretty));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/json;stream=watch"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call listNamespacedCustomObjectValidateBeforeCall(String group, String version, String namespace, String plural, String pretty, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling listNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling listNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling listNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling listNamespacedCustomObject(Async)");
        }
        Call call = this.listNamespacedCustomObjectCall(group, version, namespace, plural, pretty, labelSelector, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        return call;
    }

    public Object listNamespacedCustomObject(String group, String version, String namespace, String plural, String pretty, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<Object> resp = this.listNamespacedCustomObjectWithHttpInfo(group, version, namespace, plural, pretty, labelSelector, resourceVersion, timeoutSeconds, watch);
        return resp.getData();
    }

    public ApiResponse<Object> listNamespacedCustomObjectWithHttpInfo(String group, String version, String namespace, String plural, String pretty, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call call = this.listNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, pretty, labelSelector, resourceVersion, timeoutSeconds, watch, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call listNamespacedCustomObjectAsync(String group, String version, String namespace, String plural, String pretty, String labelSelector, String resourceVersion, Integer timeoutSeconds, Boolean watch, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.listNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, pretty, labelSelector, resourceVersion, timeoutSeconds, watch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchClusterCustomObjectCall(String group, String version, String plural, String name, Object body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/merge-patch+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchClusterCustomObjectValidateBeforeCall(String group, String version, String plural, String name, Object body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchClusterCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchClusterCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchClusterCustomObject(Async)");
        }
        Call call = this.patchClusterCustomObjectCall(group, version, plural, name, body, progressListener, progressRequestListener);
        return call;
    }

    public Object patchClusterCustomObject(String group, String version, String plural, String name, Object body) throws ApiException {
        ApiResponse<Object> resp = this.patchClusterCustomObjectWithHttpInfo(group, version, plural, name, body);
        return resp.getData();
    }

    public ApiResponse<Object> patchClusterCustomObjectWithHttpInfo(String group, String version, String plural, String name, Object body) throws ApiException {
        Call call = this.patchClusterCustomObjectValidateBeforeCall(group, version, plural, name, body, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchClusterCustomObjectAsync(String group, String version, String plural, String name, Object body, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchClusterCustomObjectValidateBeforeCall(group, version, plural, name, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchClusterCustomObjectScaleCall(String group, String version, String plural, String name, Object body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/scale".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/merge-patch+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchClusterCustomObjectScaleValidateBeforeCall(String group, String version, String plural, String name, Object body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchClusterCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchClusterCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchClusterCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchClusterCustomObjectScale(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchClusterCustomObjectScale(Async)");
        }
        Call call = this.patchClusterCustomObjectScaleCall(group, version, plural, name, body, progressListener, progressRequestListener);
        return call;
    }

    public Object patchClusterCustomObjectScale(String group, String version, String plural, String name, Object body) throws ApiException {
        ApiResponse<Object> resp = this.patchClusterCustomObjectScaleWithHttpInfo(group, version, plural, name, body);
        return resp.getData();
    }

    public ApiResponse<Object> patchClusterCustomObjectScaleWithHttpInfo(String group, String version, String plural, String name, Object body) throws ApiException {
        Call call = this.patchClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, body, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchClusterCustomObjectScaleAsync(String group, String version, String plural, String name, Object body, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchClusterCustomObjectStatusCall(String group, String version, String plural, String name, Object body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/status".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/merge-patch+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchClusterCustomObjectStatusValidateBeforeCall(String group, String version, String plural, String name, Object body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchClusterCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchClusterCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchClusterCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchClusterCustomObjectStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchClusterCustomObjectStatus(Async)");
        }
        Call call = this.patchClusterCustomObjectStatusCall(group, version, plural, name, body, progressListener, progressRequestListener);
        return call;
    }

    public Object patchClusterCustomObjectStatus(String group, String version, String plural, String name, Object body) throws ApiException {
        ApiResponse<Object> resp = this.patchClusterCustomObjectStatusWithHttpInfo(group, version, plural, name, body);
        return resp.getData();
    }

    public ApiResponse<Object> patchClusterCustomObjectStatusWithHttpInfo(String group, String version, String plural, String name, Object body) throws ApiException {
        Call call = this.patchClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, body, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchClusterCustomObjectStatusAsync(String group, String version, String plural, String name, Object body, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchNamespacedCustomObjectCall(String group, String version, String namespace, String plural, String name, Object body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/merge-patch+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchNamespacedCustomObjectValidateBeforeCall(String group, String version, String namespace, String plural, String name, Object body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchNamespacedCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedCustomObject(Async)");
        }
        Call call = this.patchNamespacedCustomObjectCall(group, version, namespace, plural, name, body, progressListener, progressRequestListener);
        return call;
    }

    public Object patchNamespacedCustomObject(String group, String version, String namespace, String plural, String name, Object body) throws ApiException {
        ApiResponse<Object> resp = this.patchNamespacedCustomObjectWithHttpInfo(group, version, namespace, plural, name, body);
        return resp.getData();
    }

    public ApiResponse<Object> patchNamespacedCustomObjectWithHttpInfo(String group, String version, String namespace, String plural, String name, Object body) throws ApiException {
        Call call = this.patchNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, body, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchNamespacedCustomObjectAsync(String group, String version, String namespace, String plural, String name, Object body, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchNamespacedCustomObjectScaleCall(String group, String version, String namespace, String plural, String name, Object body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/merge-patch+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchNamespacedCustomObjectScaleValidateBeforeCall(String group, String version, String namespace, String plural, String name, Object body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchNamespacedCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchNamespacedCustomObjectScale(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchNamespacedCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedCustomObjectScale(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedCustomObjectScale(Async)");
        }
        Call call = this.patchNamespacedCustomObjectScaleCall(group, version, namespace, plural, name, body, progressListener, progressRequestListener);
        return call;
    }

    public Object patchNamespacedCustomObjectScale(String group, String version, String namespace, String plural, String name, Object body) throws ApiException {
        ApiResponse<Object> resp = this.patchNamespacedCustomObjectScaleWithHttpInfo(group, version, namespace, plural, name, body);
        return resp.getData();
    }

    public ApiResponse<Object> patchNamespacedCustomObjectScaleWithHttpInfo(String group, String version, String namespace, String plural, String name, Object body) throws ApiException {
        Call call = this.patchNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, body, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchNamespacedCustomObjectScaleAsync(String group, String version, String namespace, String plural, String name, Object body, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchNamespacedCustomObjectStatusCall(String group, String version, String namespace, String plural, String name, Object body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/merge-patch+json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchNamespacedCustomObjectStatusValidateBeforeCall(String group, String version, String namespace, String plural, String name, Object body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchNamespacedCustomObjectStatus(Async)");
        }
        Call call = this.patchNamespacedCustomObjectStatusCall(group, version, namespace, plural, name, body, progressListener, progressRequestListener);
        return call;
    }

    public Object patchNamespacedCustomObjectStatus(String group, String version, String namespace, String plural, String name, Object body) throws ApiException {
        ApiResponse<Object> resp = this.patchNamespacedCustomObjectStatusWithHttpInfo(group, version, namespace, plural, name, body);
        return resp.getData();
    }

    public ApiResponse<Object> patchNamespacedCustomObjectStatusWithHttpInfo(String group, String version, String namespace, String plural, String name, Object body) throws ApiException {
        Call call = this.patchNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, body, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchNamespacedCustomObjectStatusAsync(String group, String version, String namespace, String plural, String name, Object body, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call replaceClusterCustomObjectCall(String group, String version, String plural, String name, Object body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call replaceClusterCustomObjectValidateBeforeCall(String group, String version, String plural, String name, Object body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceClusterCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceClusterCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceClusterCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceClusterCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceClusterCustomObject(Async)");
        }
        Call call = this.replaceClusterCustomObjectCall(group, version, plural, name, body, progressListener, progressRequestListener);
        return call;
    }

    public Object replaceClusterCustomObject(String group, String version, String plural, String name, Object body) throws ApiException {
        ApiResponse<Object> resp = this.replaceClusterCustomObjectWithHttpInfo(group, version, plural, name, body);
        return resp.getData();
    }

    public ApiResponse<Object> replaceClusterCustomObjectWithHttpInfo(String group, String version, String plural, String name, Object body) throws ApiException {
        Call call = this.replaceClusterCustomObjectValidateBeforeCall(group, version, plural, name, body, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call replaceClusterCustomObjectAsync(String group, String version, String plural, String name, Object body, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.replaceClusterCustomObjectValidateBeforeCall(group, version, plural, name, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call replaceClusterCustomObjectScaleCall(String group, String version, String plural, String name, Object body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/scale".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call replaceClusterCustomObjectScaleValidateBeforeCall(String group, String version, String plural, String name, Object body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceClusterCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceClusterCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceClusterCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceClusterCustomObjectScale(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceClusterCustomObjectScale(Async)");
        }
        Call call = this.replaceClusterCustomObjectScaleCall(group, version, plural, name, body, progressListener, progressRequestListener);
        return call;
    }

    public Object replaceClusterCustomObjectScale(String group, String version, String plural, String name, Object body) throws ApiException {
        ApiResponse<Object> resp = this.replaceClusterCustomObjectScaleWithHttpInfo(group, version, plural, name, body);
        return resp.getData();
    }

    public ApiResponse<Object> replaceClusterCustomObjectScaleWithHttpInfo(String group, String version, String plural, String name, Object body) throws ApiException {
        Call call = this.replaceClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, body, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call replaceClusterCustomObjectScaleAsync(String group, String version, String plural, String name, Object body, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.replaceClusterCustomObjectScaleValidateBeforeCall(group, version, plural, name, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call replaceClusterCustomObjectStatusCall(String group, String version, String plural, String name, Object body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/{plural}/{name}/status".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call replaceClusterCustomObjectStatusValidateBeforeCall(String group, String version, String plural, String name, Object body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceClusterCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceClusterCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceClusterCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceClusterCustomObjectStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceClusterCustomObjectStatus(Async)");
        }
        Call call = this.replaceClusterCustomObjectStatusCall(group, version, plural, name, body, progressListener, progressRequestListener);
        return call;
    }

    public Object replaceClusterCustomObjectStatus(String group, String version, String plural, String name, Object body) throws ApiException {
        ApiResponse<Object> resp = this.replaceClusterCustomObjectStatusWithHttpInfo(group, version, plural, name, body);
        return resp.getData();
    }

    public ApiResponse<Object> replaceClusterCustomObjectStatusWithHttpInfo(String group, String version, String plural, String name, Object body) throws ApiException {
        Call call = this.replaceClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, body, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call replaceClusterCustomObjectStatusAsync(String group, String version, String plural, String name, Object body, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.replaceClusterCustomObjectStatusValidateBeforeCall(group, version, plural, name, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call replaceNamespacedCustomObjectCall(String group, String version, String namespace, String plural, String name, Object body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call replaceNamespacedCustomObjectValidateBeforeCall(String group, String version, String namespace, String plural, String name, Object body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceNamespacedCustomObject(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceNamespacedCustomObject(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedCustomObject(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceNamespacedCustomObject(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedCustomObject(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedCustomObject(Async)");
        }
        Call call = this.replaceNamespacedCustomObjectCall(group, version, namespace, plural, name, body, progressListener, progressRequestListener);
        return call;
    }

    public Object replaceNamespacedCustomObject(String group, String version, String namespace, String plural, String name, Object body) throws ApiException {
        ApiResponse<Object> resp = this.replaceNamespacedCustomObjectWithHttpInfo(group, version, namespace, plural, name, body);
        return resp.getData();
    }

    public ApiResponse<Object> replaceNamespacedCustomObjectWithHttpInfo(String group, String version, String namespace, String plural, String name, Object body) throws ApiException {
        Call call = this.replaceNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, body, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call replaceNamespacedCustomObjectAsync(String group, String version, String namespace, String plural, String name, Object body, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.replaceNamespacedCustomObjectValidateBeforeCall(group, version, namespace, plural, name, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call replaceNamespacedCustomObjectScaleCall(String group, String version, String namespace, String plural, String name, Object body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/scale".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call replaceNamespacedCustomObjectScaleValidateBeforeCall(String group, String version, String namespace, String plural, String name, Object body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedCustomObjectScale(Async)");
        }
        Call call = this.replaceNamespacedCustomObjectScaleCall(group, version, namespace, plural, name, body, progressListener, progressRequestListener);
        return call;
    }

    public Object replaceNamespacedCustomObjectScale(String group, String version, String namespace, String plural, String name, Object body) throws ApiException {
        ApiResponse<Object> resp = this.replaceNamespacedCustomObjectScaleWithHttpInfo(group, version, namespace, plural, name, body);
        return resp.getData();
    }

    public ApiResponse<Object> replaceNamespacedCustomObjectScaleWithHttpInfo(String group, String version, String namespace, String plural, String name, Object body) throws ApiException {
        Call call = this.replaceNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, body, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call replaceNamespacedCustomObjectScaleAsync(String group, String version, String namespace, String plural, String name, Object body, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.replaceNamespacedCustomObjectScaleValidateBeforeCall(group, version, namespace, plural, name, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call replaceNamespacedCustomObjectStatusCall(String group, String version, String namespace, String plural, String name, Object body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/apis/{group}/{version}/namespaces/{namespace}/{plural}/{name}/status".replaceAll("\\{group\\}", this.apiClient.escapeString(group.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString())).replaceAll("\\{namespace\\}", this.apiClient.escapeString(namespace.toString())).replaceAll("\\{plural\\}", this.apiClient.escapeString(plural.toString())).replaceAll("\\{name\\}", this.apiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"*/*"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call replaceNamespacedCustomObjectStatusValidateBeforeCall(String group, String version, String namespace, String plural, String name, Object body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (group == null) {
            throw new ApiException("Missing the required parameter 'group' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        if (version == null) {
            throw new ApiException("Missing the required parameter 'version' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        if (plural == null) {
            throw new ApiException("Missing the required parameter 'plural' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceNamespacedCustomObjectStatus(Async)");
        }
        Call call = this.replaceNamespacedCustomObjectStatusCall(group, version, namespace, plural, name, body, progressListener, progressRequestListener);
        return call;
    }

    public Object replaceNamespacedCustomObjectStatus(String group, String version, String namespace, String plural, String name, Object body) throws ApiException {
        ApiResponse<Object> resp = this.replaceNamespacedCustomObjectStatusWithHttpInfo(group, version, namespace, plural, name, body);
        return resp.getData();
    }

    public ApiResponse<Object> replaceNamespacedCustomObjectStatusWithHttpInfo(String group, String version, String namespace, String plural, String name, Object body) throws ApiException {
        Call call = this.replaceNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, body, null, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call replaceNamespacedCustomObjectStatusAsync(String group, String version, String namespace, String plural, String name, Object body, final ApiCallback<Object> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.replaceNamespacedCustomObjectStatusValidateBeforeCall(group, version, namespace, plural, name, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

