/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1ContainerStatus;
import io.kubernetes.client.models.V1ContainerStatusBuilder;
import io.kubernetes.client.models.V1ContainerStatusFluentImpl;
import io.kubernetes.client.models.V1PodCondition;
import io.kubernetes.client.models.V1PodConditionBuilder;
import io.kubernetes.client.models.V1PodConditionFluentImpl;
import io.kubernetes.client.models.V1PodStatus;
import io.kubernetes.client.models.V1PodStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.joda.time.DateTime;

public class V1PodStatusFluentImpl<A extends V1PodStatusFluent<A>>
extends BaseFluent<A>
implements V1PodStatusFluent<A> {
    private List<V1PodConditionBuilder> conditions;
    private List<V1ContainerStatusBuilder> containerStatuses;
    private String hostIP;
    private List<V1ContainerStatusBuilder> initContainerStatuses;
    private String message;
    private String nominatedNodeName;
    private String phase;
    private String podIP;
    private String qosClass;
    private String reason;
    private DateTime startTime;

    public V1PodStatusFluentImpl() {
    }

    public V1PodStatusFluentImpl(V1PodStatus instance) {
        this.withConditions(instance.getConditions());
        this.withContainerStatuses(instance.getContainerStatuses());
        this.withHostIP(instance.getHostIP());
        this.withInitContainerStatuses(instance.getInitContainerStatuses());
        this.withMessage(instance.getMessage());
        this.withNominatedNodeName(instance.getNominatedNodeName());
        this.withPhase(instance.getPhase());
        this.withPodIP(instance.getPodIP());
        this.withQosClass(instance.getQosClass());
        this.withReason(instance.getReason());
        this.withStartTime(instance.getStartTime());
    }

    @Override
    public A addToConditions(int index, V1PodCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1PodConditionBuilder>();
        }
        V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, V1PodCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1PodConditionBuilder>();
        }
        V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(V1PodCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1PodConditionBuilder>();
        }
        for (V1PodCondition item : items) {
            V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<V1PodCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1PodConditionBuilder>();
        }
        for (V1PodCondition item : items) {
            V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(V1PodCondition ... items) {
        for (V1PodCondition item : items) {
            V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<V1PodCondition> items) {
        for (V1PodCondition item : items) {
            V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1PodCondition> getConditions() {
        return V1PodStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<V1PodCondition> buildConditions() {
        return V1PodStatusFluentImpl.build(this.conditions);
    }

    @Override
    public V1PodCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public V1PodCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public V1PodCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public V1PodCondition buildMatchingCondition(Predicate<V1PodConditionBuilder> predicate) {
        for (V1PodConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<V1PodConditionBuilder> predicate) {
        for (V1PodConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<V1PodCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<V1PodConditionBuilder>();
            for (V1PodCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(V1PodCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (V1PodCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public V1PodStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V1PodStatusFluent.ConditionsNested<A> addNewConditionLike(V1PodCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public V1PodStatusFluent.ConditionsNested<A> setNewConditionLike(int index, V1PodCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public V1PodStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1PodStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public V1PodStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1PodStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<V1PodConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public A addToContainerStatuses(int index, V1ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList<V1ContainerStatusBuilder>();
        }
        V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
        this._visitables.get("containerStatuses").add(index >= 0 ? index : this._visitables.get("containerStatuses").size(), builder);
        this.containerStatuses.add(index >= 0 ? index : this.containerStatuses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToContainerStatuses(int index, V1ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList<V1ContainerStatusBuilder>();
        }
        V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get("containerStatuses").size()) {
            this._visitables.get("containerStatuses").add(builder);
        } else {
            this._visitables.get("containerStatuses").set(index, builder);
        }
        if (index < 0 || index >= this.containerStatuses.size()) {
            this.containerStatuses.add(builder);
        } else {
            this.containerStatuses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainerStatuses(V1ContainerStatus ... items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList<V1ContainerStatusBuilder>();
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainerStatuses(Collection<V1ContainerStatus> items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList<V1ContainerStatusBuilder>();
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainerStatuses(V1ContainerStatus ... items) {
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").remove(builder);
            if (this.containerStatuses == null) continue;
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainerStatuses(Collection<V1ContainerStatus> items) {
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").remove(builder);
            if (this.containerStatuses == null) continue;
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1ContainerStatus> getContainerStatuses() {
        return V1PodStatusFluentImpl.build(this.containerStatuses);
    }

    @Override
    public List<V1ContainerStatus> buildContainerStatuses() {
        return V1PodStatusFluentImpl.build(this.containerStatuses);
    }

    @Override
    public V1ContainerStatus buildContainerStatus(int index) {
        return this.containerStatuses.get(index).build();
    }

    @Override
    public V1ContainerStatus buildFirstContainerStatus() {
        return this.containerStatuses.get(0).build();
    }

    @Override
    public V1ContainerStatus buildLastContainerStatus() {
        return this.containerStatuses.get(this.containerStatuses.size() - 1).build();
    }

    @Override
    public V1ContainerStatus buildMatchingContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        for (V1ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        for (V1ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainerStatuses(List<V1ContainerStatus> containerStatuses) {
        if (this.containerStatuses != null) {
            this._visitables.get("containerStatuses").removeAll(this.containerStatuses);
        }
        if (containerStatuses != null) {
            this.containerStatuses = new ArrayList<V1ContainerStatusBuilder>();
            for (V1ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        } else {
            this.containerStatuses = null;
        }
        return (A)this;
    }

    @Override
    public A withContainerStatuses(V1ContainerStatus ... containerStatuses) {
        if (this.containerStatuses != null) {
            this.containerStatuses.clear();
        }
        if (containerStatuses != null) {
            for (V1ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainerStatuses() {
        return this.containerStatuses != null && !this.containerStatuses.isEmpty();
    }

    @Override
    public V1PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatus() {
        return new ContainerStatusesNestedImpl();
    }

    @Override
    public V1PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(V1ContainerStatus item) {
        return new ContainerStatusesNestedImpl(-1, item);
    }

    @Override
    public V1PodStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(int index, V1ContainerStatus item) {
        return new ContainerStatusesNestedImpl(index, item);
    }

    @Override
    public V1PodStatusFluent.ContainerStatusesNested<A> editContainerStatus(int index) {
        if (this.containerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public V1PodStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus() {
        if (this.containerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(0, this.buildContainerStatus(0));
    }

    @Override
    public V1PodStatusFluent.ContainerStatusesNested<A> editLastContainerStatus() {
        int index = this.containerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public V1PodStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containerStatuses.size(); ++i) {
            if (!predicate.apply(this.containerStatuses.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public String getHostIP() {
        return this.hostIP;
    }

    @Override
    public A withHostIP(String hostIP) {
        this.hostIP = hostIP;
        return (A)this;
    }

    @Override
    public Boolean hasHostIP() {
        return this.hostIP != null;
    }

    @Override
    public A withNewHostIP(String arg1) {
        return this.withHostIP(new String(arg1));
    }

    @Override
    public A withNewHostIP(StringBuilder arg1) {
        return this.withHostIP(new String(arg1));
    }

    @Override
    public A withNewHostIP(StringBuffer arg1) {
        return this.withHostIP(new String(arg1));
    }

    @Override
    public A addToInitContainerStatuses(int index, V1ContainerStatus item) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList<V1ContainerStatusBuilder>();
        }
        V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
        this._visitables.get("initContainerStatuses").add(index >= 0 ? index : this._visitables.get("initContainerStatuses").size(), builder);
        this.initContainerStatuses.add(index >= 0 ? index : this.initContainerStatuses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInitContainerStatuses(int index, V1ContainerStatus item) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList<V1ContainerStatusBuilder>();
        }
        V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get("initContainerStatuses").size()) {
            this._visitables.get("initContainerStatuses").add(builder);
        } else {
            this._visitables.get("initContainerStatuses").set(index, builder);
        }
        if (index < 0 || index >= this.initContainerStatuses.size()) {
            this.initContainerStatuses.add(builder);
        } else {
            this.initContainerStatuses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInitContainerStatuses(V1ContainerStatus ... items) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList<V1ContainerStatusBuilder>();
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInitContainerStatuses(Collection<V1ContainerStatus> items) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList<V1ContainerStatusBuilder>();
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitContainerStatuses(V1ContainerStatus ... items) {
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").remove(builder);
            if (this.initContainerStatuses == null) continue;
            this.initContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInitContainerStatuses(Collection<V1ContainerStatus> items) {
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").remove(builder);
            if (this.initContainerStatuses == null) continue;
            this.initContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1ContainerStatus> getInitContainerStatuses() {
        return V1PodStatusFluentImpl.build(this.initContainerStatuses);
    }

    @Override
    public List<V1ContainerStatus> buildInitContainerStatuses() {
        return V1PodStatusFluentImpl.build(this.initContainerStatuses);
    }

    @Override
    public V1ContainerStatus buildInitContainerStatus(int index) {
        return this.initContainerStatuses.get(index).build();
    }

    @Override
    public V1ContainerStatus buildFirstInitContainerStatus() {
        return this.initContainerStatuses.get(0).build();
    }

    @Override
    public V1ContainerStatus buildLastInitContainerStatus() {
        return this.initContainerStatuses.get(this.initContainerStatuses.size() - 1).build();
    }

    @Override
    public V1ContainerStatus buildMatchingInitContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        for (V1ContainerStatusBuilder item : this.initContainerStatuses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInitContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        for (V1ContainerStatusBuilder item : this.initContainerStatuses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withInitContainerStatuses(List<V1ContainerStatus> initContainerStatuses) {
        if (this.initContainerStatuses != null) {
            this._visitables.get("initContainerStatuses").removeAll(this.initContainerStatuses);
        }
        if (initContainerStatuses != null) {
            this.initContainerStatuses = new ArrayList<V1ContainerStatusBuilder>();
            for (V1ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        } else {
            this.initContainerStatuses = null;
        }
        return (A)this;
    }

    @Override
    public A withInitContainerStatuses(V1ContainerStatus ... initContainerStatuses) {
        if (this.initContainerStatuses != null) {
            this.initContainerStatuses.clear();
        }
        if (initContainerStatuses != null) {
            for (V1ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitContainerStatuses() {
        return this.initContainerStatuses != null && !this.initContainerStatuses.isEmpty();
    }

    @Override
    public V1PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatus() {
        return new InitContainerStatusesNestedImpl();
    }

    @Override
    public V1PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatusLike(V1ContainerStatus item) {
        return new InitContainerStatusesNestedImpl(-1, item);
    }

    @Override
    public V1PodStatusFluent.InitContainerStatusesNested<A> setNewInitContainerStatusLike(int index, V1ContainerStatus item) {
        return new InitContainerStatusesNestedImpl(index, item);
    }

    @Override
    public V1PodStatusFluent.InitContainerStatusesNested<A> editInitContainerStatus(int index) {
        if (this.initContainerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit initContainerStatuses. Index exceeds size.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    @Override
    public V1PodStatusFluent.InitContainerStatusesNested<A> editFirstInitContainerStatus() {
        if (this.initContainerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(0, this.buildInitContainerStatus(0));
    }

    @Override
    public V1PodStatusFluent.InitContainerStatusesNested<A> editLastInitContainerStatus() {
        int index = this.initContainerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    @Override
    public V1PodStatusFluent.InitContainerStatusesNested<A> editMatchingInitContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainerStatuses.size(); ++i) {
            if (!predicate.apply(this.initContainerStatuses.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainerStatuses. No match found.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public Boolean hasMessage() {
        return this.message != null;
    }

    @Override
    public A withNewMessage(String arg1) {
        return this.withMessage(new String(arg1));
    }

    @Override
    public A withNewMessage(StringBuilder arg1) {
        return this.withMessage(new String(arg1));
    }

    @Override
    public A withNewMessage(StringBuffer arg1) {
        return this.withMessage(new String(arg1));
    }

    @Override
    public String getNominatedNodeName() {
        return this.nominatedNodeName;
    }

    @Override
    public A withNominatedNodeName(String nominatedNodeName) {
        this.nominatedNodeName = nominatedNodeName;
        return (A)this;
    }

    @Override
    public Boolean hasNominatedNodeName() {
        return this.nominatedNodeName != null;
    }

    @Override
    public A withNewNominatedNodeName(String arg1) {
        return this.withNominatedNodeName(new String(arg1));
    }

    @Override
    public A withNewNominatedNodeName(StringBuilder arg1) {
        return this.withNominatedNodeName(new String(arg1));
    }

    @Override
    public A withNewNominatedNodeName(StringBuffer arg1) {
        return this.withNominatedNodeName(new String(arg1));
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    @Override
    public Boolean hasPhase() {
        return this.phase != null;
    }

    @Override
    public A withNewPhase(String arg1) {
        return this.withPhase(new String(arg1));
    }

    @Override
    public A withNewPhase(StringBuilder arg1) {
        return this.withPhase(new String(arg1));
    }

    @Override
    public A withNewPhase(StringBuffer arg1) {
        return this.withPhase(new String(arg1));
    }

    @Override
    public String getPodIP() {
        return this.podIP;
    }

    @Override
    public A withPodIP(String podIP) {
        this.podIP = podIP;
        return (A)this;
    }

    @Override
    public Boolean hasPodIP() {
        return this.podIP != null;
    }

    @Override
    public A withNewPodIP(String arg1) {
        return this.withPodIP(new String(arg1));
    }

    @Override
    public A withNewPodIP(StringBuilder arg1) {
        return this.withPodIP(new String(arg1));
    }

    @Override
    public A withNewPodIP(StringBuffer arg1) {
        return this.withPodIP(new String(arg1));
    }

    @Override
    public String getQosClass() {
        return this.qosClass;
    }

    @Override
    public A withQosClass(String qosClass) {
        this.qosClass = qosClass;
        return (A)this;
    }

    @Override
    public Boolean hasQosClass() {
        return this.qosClass != null;
    }

    @Override
    public A withNewQosClass(String arg1) {
        return this.withQosClass(new String(arg1));
    }

    @Override
    public A withNewQosClass(StringBuilder arg1) {
        return this.withQosClass(new String(arg1));
    }

    @Override
    public A withNewQosClass(StringBuffer arg1) {
        return this.withQosClass(new String(arg1));
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public Boolean hasReason() {
        return this.reason != null;
    }

    @Override
    public A withNewReason(String arg1) {
        return this.withReason(new String(arg1));
    }

    @Override
    public A withNewReason(StringBuilder arg1) {
        return this.withReason(new String(arg1));
    }

    @Override
    public A withNewReason(StringBuffer arg1) {
        return this.withReason(new String(arg1));
    }

    @Override
    public DateTime getStartTime() {
        return this.startTime;
    }

    @Override
    public A withStartTime(DateTime startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    @Override
    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    @Override
    public A withNewStartTime(int arg0, int arg1, int arg2, int arg3, int arg4) {
        return this.withStartTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewStartTime(Object arg0) {
        return this.withStartTime(new DateTime(arg0));
    }

    @Override
    public A withNewStartTime(long arg0) {
        return this.withStartTime(new DateTime(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1PodStatusFluentImpl that = (V1PodStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.containerStatuses != null ? !this.containerStatuses.equals(that.containerStatuses) : that.containerStatuses != null) {
            return false;
        }
        if (this.hostIP != null ? !this.hostIP.equals(that.hostIP) : that.hostIP != null) {
            return false;
        }
        if (this.initContainerStatuses != null ? !this.initContainerStatuses.equals(that.initContainerStatuses) : that.initContainerStatuses != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.nominatedNodeName != null ? !this.nominatedNodeName.equals(that.nominatedNodeName) : that.nominatedNodeName != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.podIP != null ? !this.podIP.equals(that.podIP) : that.podIP != null) {
            return false;
        }
        if (this.qosClass != null ? !this.qosClass.equals(that.qosClass) : that.qosClass != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        return !(this.startTime != null ? !this.startTime.equals((Object)that.startTime) : that.startTime != null);
    }

    public class InitContainerStatusesNestedImpl<N>
    extends V1ContainerStatusFluentImpl<V1PodStatusFluent.InitContainerStatusesNested<N>>
    implements V1PodStatusFluent.InitContainerStatusesNested<N>,
    Nested<N> {
        private final V1ContainerStatusBuilder builder;
        private final int index;

        InitContainerStatusesNestedImpl(int index, V1ContainerStatus item) {
            this.index = index;
            this.builder = new V1ContainerStatusBuilder(this, item);
        }

        InitContainerStatusesNestedImpl() {
            this.index = -1;
            this.builder = new V1ContainerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodStatusFluentImpl.this.setToInitContainerStatuses(this.index, this.builder.build());
        }

        @Override
        public N endInitContainerStatus() {
            return this.and();
        }
    }

    public class ContainerStatusesNestedImpl<N>
    extends V1ContainerStatusFluentImpl<V1PodStatusFluent.ContainerStatusesNested<N>>
    implements V1PodStatusFluent.ContainerStatusesNested<N>,
    Nested<N> {
        private final V1ContainerStatusBuilder builder;
        private final int index;

        ContainerStatusesNestedImpl(int index, V1ContainerStatus item) {
            this.index = index;
            this.builder = new V1ContainerStatusBuilder(this, item);
        }

        ContainerStatusesNestedImpl() {
            this.index = -1;
            this.builder = new V1ContainerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodStatusFluentImpl.this.setToContainerStatuses(this.index, this.builder.build());
        }

        @Override
        public N endContainerStatus() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends V1PodConditionFluentImpl<V1PodStatusFluent.ConditionsNested<N>>
    implements V1PodStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final V1PodConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, V1PodCondition item) {
            this.index = index;
            this.builder = new V1PodConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1PodConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

