/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1Handler;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.")
public class V1Lifecycle {
    @SerializedName(value="postStart")
    private V1Handler postStart = null;
    @SerializedName(value="preStop")
    private V1Handler preStop = null;

    public V1Lifecycle postStart(V1Handler postStart) {
        this.postStart = postStart;
        return this;
    }

    @ApiModelProperty(value="PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks")
    public V1Handler getPostStart() {
        return this.postStart;
    }

    public void setPostStart(V1Handler postStart) {
        this.postStart = postStart;
    }

    public V1Lifecycle preStop(V1Handler preStop) {
        this.preStop = preStop;
        return this;
    }

    @ApiModelProperty(value="PreStop is called immediately before a container is terminated due to an API request or management event such as liveness probe failure, preemption, resource contention, etc. The handler is not called if the container crashes or exits. The reason for termination is passed to the handler. The Pod's termination grace period countdown begins before the PreStop hooked is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period. Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks")
    public V1Handler getPreStop() {
        return this.preStop;
    }

    public void setPreStop(V1Handler preStop) {
        this.preStop = preStop;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Lifecycle v1Lifecycle = (V1Lifecycle)o;
        return Objects.equals(this.postStart, v1Lifecycle.postStart) && Objects.equals(this.preStop, v1Lifecycle.preStop);
    }

    public int hashCode() {
        return Objects.hash(this.postStart, this.preStop);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Lifecycle {\n");
        sb.append("    postStart: ").append(this.toIndentedString(this.postStart)).append("\n");
        sb.append("    preStop: ").append(this.toIndentedString(this.preStop)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

