/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="TokenReviewSpec is a description of the token authentication request.")
public class V1TokenReviewSpec {
    @SerializedName(value="audiences")
    private List<String> audiences = null;
    @SerializedName(value="token")
    private String token = null;

    public V1TokenReviewSpec audiences(List<String> audiences) {
        this.audiences = audiences;
        return this;
    }

    public V1TokenReviewSpec addAudiencesItem(String audiencesItem) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(audiencesItem);
        return this;
    }

    @ApiModelProperty(value="Audiences is a list of the identifiers that the resource server presented with the token identifies as. Audience-aware token authenticators will verify that the token was intended for at least one of the audiences in this list. If no audiences are provided, the audience will default to the audience of the Kubernetes apiserver.")
    public List<String> getAudiences() {
        return this.audiences;
    }

    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    public V1TokenReviewSpec token(String token) {
        this.token = token;
        return this;
    }

    @ApiModelProperty(value="Token is the opaque bearer token.")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1TokenReviewSpec v1TokenReviewSpec = (V1TokenReviewSpec)o;
        return Objects.equals(this.audiences, v1TokenReviewSpec.audiences) && Objects.equals(this.token, v1TokenReviewSpec.token);
    }

    public int hashCode() {
        return Objects.hash(this.audiences, this.token);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1TokenReviewSpec {\n");
        sb.append("    audiences: ").append(this.toIndentedString(this.audiences)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

