/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1LabelSelector;
import io.kubernetes.client.models.V1beta1NetworkPolicyEgressRule;
import io.kubernetes.client.models.V1beta1NetworkPolicyIngressRule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DEPRECATED 1.9 - This group version of NetworkPolicySpec is deprecated by networking/v1/NetworkPolicySpec.")
public class V1beta1NetworkPolicySpec {
    @SerializedName(value="egress")
    private List<V1beta1NetworkPolicyEgressRule> egress = null;
    @SerializedName(value="ingress")
    private List<V1beta1NetworkPolicyIngressRule> ingress = null;
    @SerializedName(value="podSelector")
    private V1LabelSelector podSelector = null;
    @SerializedName(value="policyTypes")
    private List<String> policyTypes = null;

    public V1beta1NetworkPolicySpec egress(List<V1beta1NetworkPolicyEgressRule> egress) {
        this.egress = egress;
        return this;
    }

    public V1beta1NetworkPolicySpec addEgressItem(V1beta1NetworkPolicyEgressRule egressItem) {
        if (this.egress == null) {
            this.egress = new ArrayList<V1beta1NetworkPolicyEgressRule>();
        }
        this.egress.add(egressItem);
        return this;
    }

    @ApiModelProperty(value="List of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8")
    public List<V1beta1NetworkPolicyEgressRule> getEgress() {
        return this.egress;
    }

    public void setEgress(List<V1beta1NetworkPolicyEgressRule> egress) {
        this.egress = egress;
    }

    public V1beta1NetworkPolicySpec ingress(List<V1beta1NetworkPolicyIngressRule> ingress) {
        this.ingress = ingress;
        return this;
    }

    public V1beta1NetworkPolicySpec addIngressItem(V1beta1NetworkPolicyIngressRule ingressItem) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<V1beta1NetworkPolicyIngressRule>();
        }
        this.ingress.add(ingressItem);
        return this;
    }

    @ApiModelProperty(value="List of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default).")
    public List<V1beta1NetworkPolicyIngressRule> getIngress() {
        return this.ingress;
    }

    public void setIngress(List<V1beta1NetworkPolicyIngressRule> ingress) {
        this.ingress = ingress;
    }

    public V1beta1NetworkPolicySpec podSelector(V1LabelSelector podSelector) {
        this.podSelector = podSelector;
        return this;
    }

    @ApiModelProperty(required=true, value="Selects the pods to which this NetworkPolicy object applies.  The array of ingress rules is applied to any pods selected by this field. Multiple network policies can select the same set of pods.  In this case, the ingress rules for each are combined additively. This field is NOT optional and follows standard label selector semantics. An empty podSelector matches all pods in this namespace.")
    public V1LabelSelector getPodSelector() {
        return this.podSelector;
    }

    public void setPodSelector(V1LabelSelector podSelector) {
        this.podSelector = podSelector;
    }

    public V1beta1NetworkPolicySpec policyTypes(List<String> policyTypes) {
        this.policyTypes = policyTypes;
        return this;
    }

    public V1beta1NetworkPolicySpec addPolicyTypesItem(String policyTypesItem) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        this.policyTypes.add(policyTypesItem);
        return this;
    }

    @ApiModelProperty(value="List of rule types that the NetworkPolicy relates to. Valid options are \"Ingress\", \"Egress\", or \"Ingress,Egress\". If this field is not specified, it will default based on the existence of Ingress or Egress rules; policies that contain an Egress section are assumed to affect Egress, and all policies (whether or not they contain an Ingress section) are assumed to affect Ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ \"Egress\" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include \"Egress\" (since such a policy would not include an Egress section and would otherwise default to just [ \"Ingress\" ]). This field is beta-level in 1.8")
    public List<String> getPolicyTypes() {
        return this.policyTypes;
    }

    public void setPolicyTypes(List<String> policyTypes) {
        this.policyTypes = policyTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1NetworkPolicySpec v1beta1NetworkPolicySpec = (V1beta1NetworkPolicySpec)o;
        return Objects.equals(this.egress, v1beta1NetworkPolicySpec.egress) && Objects.equals(this.ingress, v1beta1NetworkPolicySpec.ingress) && Objects.equals(this.podSelector, v1beta1NetworkPolicySpec.podSelector) && Objects.equals(this.policyTypes, v1beta1NetworkPolicySpec.policyTypes);
    }

    public int hashCode() {
        return Objects.hash(this.egress, this.ingress, this.podSelector, this.policyTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1NetworkPolicySpec {\n");
        sb.append("    egress: ").append(this.toIndentedString(this.egress)).append("\n");
        sb.append("    ingress: ").append(this.toIndentedString(this.ingress)).append("\n");
        sb.append("    podSelector: ").append(this.toIndentedString(this.podSelector)).append("\n");
        sb.append("    policyTypes: ").append(this.toIndentedString(this.policyTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

